/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.ias.gui;

import com.github.mrebhan.ingameaccountswitcher.tools.Config;
import com.github.mrebhan.ingameaccountswitcher.tools.Tools;
import com.github.mrebhan.ingameaccountswitcher.tools.alt.AccountData;
import com.github.mrebhan.ingameaccountswitcher.tools.alt.AltDatabase;
import com.github.mrebhan.ingameaccountswitcher.tools.alt.AltManager;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.StringUtils;
import ru.vidtu.iasfork.SlotGui;
import the_fireplace.ias.account.AlreadyLoggedInException;
import the_fireplace.ias.account.ExtendedAccountData;
import the_fireplace.ias.config.ConfigValues;
import the_fireplace.ias.gui.GuiAddAccount;
import the_fireplace.ias.gui.GuiEditAccount;
import the_fireplace.ias.tools.HttpTools;
import the_fireplace.ias.tools.JavaTools;
import the_fireplace.ias.tools.SkinTools;
import the_fireplace.iasencrypt.EncryptionTools;

public class GuiAccountSelector
extends Screen {
    private int selectedAccountIndex = 0;
    private int prevIndex = 0;
    private Throwable loginfailed;
    private ArrayList<ExtendedAccountData> queriedaccounts = this.convertData();
    private List accountsgui;
    private Button login;
    private Button loginoffline;
    private Button delete;
    private Button edit;
    private Button reloadskins;
    private String prevQuery = "";
    private TextFieldWidget search;

    public GuiAccountSelector() {
        super((ITextComponent)new TranslationTextComponent("ias.selectaccount"));
    }

    protected void func_231160_c_() {
        this.accountsgui = new List(this.field_230706_i_);
        this.field_230705_e_.add(this.accountsgui);
        this.reloadskins = new Button(2, 2, 120, 20, (ITextComponent)new TranslationTextComponent("ias.reloadskins"), btn -> this.reloadSkins());
        this.func_230480_a_((Widget)this.reloadskins);
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 4 + 40, this.field_230709_l_ - 52, 120, 20, (ITextComponent)new TranslationTextComponent("ias.addaccount"), btn -> this.add()));
        this.login = new Button(this.field_230708_k_ / 2 - 154 - 10, this.field_230709_l_ - 52, 120, 20, (ITextComponent)new TranslationTextComponent("ias.login"), btn -> this.login(this.selectedAccountIndex));
        this.func_230480_a_((Widget)this.login);
        this.edit = new Button(this.field_230708_k_ / 2 - 40, this.field_230709_l_ - 52, 80, 20, (ITextComponent)new TranslationTextComponent("ias.edit"), btn -> this.edit());
        this.func_230480_a_((Widget)this.edit);
        this.loginoffline = new Button(this.field_230708_k_ / 2 - 154 - 10, this.field_230709_l_ - 28, 110, 20, (ITextComponent)new TranslationTextComponent("ias.login").func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("ias.offline")), btn -> this.logino(this.selectedAccountIndex));
        this.func_230480_a_((Widget)this.loginoffline);
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 4 + 50, this.field_230709_l_ - 28, 110, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), btn -> this.escape()));
        this.delete = new Button(this.field_230708_k_ / 2 - 50, this.field_230709_l_ - 28, 100, 20, (ITextComponent)new TranslationTextComponent("ias.delete"), btn -> this.delete());
        this.func_230480_a_((Widget)this.delete);
        this.search = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 80, 14, 160, 16, (ITextComponent)new TranslationTextComponent("ias.search"));
        this.func_230480_a_((Widget)this.search);
        this.updateButtons();
        this.updateShownSkin();
    }

    private void updateShownSkin() {
        if (!this.queriedaccounts.isEmpty()) {
            SkinTools.buildSkin(this.queriedaccounts.get((int)this.selectedAccountIndex).alias);
        }
    }

    public void func_231023_e_() {
        this.updateButtons();
        if (this.prevIndex != this.selectedAccountIndex) {
            this.prevIndex = this.selectedAccountIndex;
            this.updateShownSkin();
        }
        if (!this.prevQuery.equals(this.search.func_146179_b())) {
            this.updateQueried();
            this.prevQuery = this.search.func_146179_b();
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        this.accountsgui.func_231044_a_(mouseX, mouseY, mouseButton);
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public void func_231164_f_() {
        Config.save();
    }

    public void func_230430_a_(MatrixStack ms, int mx, int my, float delta) {
        this.func_230446_a_(ms);
        this.accountsgui.func_230430_a_(ms, mx, my, delta);
        GuiAccountSelector.func_238472_a_((MatrixStack)ms, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)4, (int)-1);
        if (this.loginfailed != null) {
            GuiAccountSelector.func_238471_a_((MatrixStack)ms, (FontRenderer)this.field_230712_o_, (String)this.loginfailed.getLocalizedMessage(), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ - 62), (int)0xFF6464);
        }
        super.func_230430_a_(ms, mx, my, delta);
        if (!this.queriedaccounts.isEmpty()) {
            SkinTools.javDrawSkin(ms, 8, this.field_230709_l_ / 2 - 64 - 16, 64, 128);
            Tools.drawBorderedRect(ms, this.field_230708_k_ - 8 - 64, this.field_230709_l_ / 2 - 64 - 16, this.field_230708_k_ - 8, this.field_230709_l_ / 2 + 64 - 16, 2, -5855578, -13421773);
            if (this.queriedaccounts.get((int)this.selectedAccountIndex).premium != null) {
                if (this.queriedaccounts.get((int)this.selectedAccountIndex).premium.booleanValue()) {
                    GuiAccountSelector.func_238475_b_((MatrixStack)ms, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("ias.premium"), (int)(this.field_230708_k_ - 8 - 61), (int)(this.field_230709_l_ / 2 - 64 - 13), (int)0x64FF64);
                } else {
                    GuiAccountSelector.func_238475_b_((MatrixStack)ms, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("ias.notpremium"), (int)(this.field_230708_k_ - 8 - 61), (int)(this.field_230709_l_ / 2 - 64 - 13), (int)0xFF6464);
                }
            }
            GuiAccountSelector.func_238475_b_((MatrixStack)ms, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("ias.timesused"), (int)(this.field_230708_k_ - 8 - 61), (int)(this.field_230709_l_ / 2 - 64 - 15 + 12), (int)-1);
            GuiAccountSelector.func_238476_c_((MatrixStack)ms, (FontRenderer)this.field_230712_o_, (String)String.valueOf(this.queriedaccounts.get((int)this.selectedAccountIndex).useCount), (int)(this.field_230708_k_ - 8 - 61), (int)(this.field_230709_l_ / 2 - 64 - 15 + 21), (int)-1);
            if (this.queriedaccounts.get((int)this.selectedAccountIndex).useCount > 0) {
                GuiAccountSelector.func_238475_b_((MatrixStack)ms, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("ias.lastused"), (int)(this.field_230708_k_ - 8 - 61), (int)(this.field_230709_l_ / 2 - 64 - 15 + 30), (int)-1);
                GuiAccountSelector.func_238476_c_((MatrixStack)ms, (FontRenderer)this.field_230712_o_, (String)JavaTools.getFormattedDate(), (int)(this.field_230708_k_ - 8 - 61), (int)(this.field_230709_l_ / 2 - 64 - 15 + 39), (int)-1);
            }
        }
    }

    private void reloadSkins() {
        Config.save();
        SkinTools.cacheSkins(true);
        this.updateShownSkin();
    }

    private void escape() {
        this.field_230706_i_.func_147108_a(null);
    }

    private void delete() {
        AltDatabase.getInstance().getAlts().remove(this.getCurrentAsEditable());
        if (this.selectedAccountIndex > 0) {
            --this.selectedAccountIndex;
        }
        this.updateQueried();
        this.updateButtons();
    }

    private void add() {
        this.field_230706_i_.func_147108_a((Screen)new GuiAddAccount());
    }

    private void logino(int selected) {
        ExtendedAccountData data = this.queriedaccounts.get(selected);
        AltManager.getInstance().setUserOffline(data.alias);
        this.loginfailed = null;
        this.field_230706_i_.func_147108_a(null);
        ExtendedAccountData current = this.getCurrentAsEditable();
        ++current.useCount;
        current.lastused = JavaTools.getDate();
    }

    private void login(int selected) {
        ExtendedAccountData data = this.queriedaccounts.get(selected);
        this.loginfailed = AltManager.getInstance().setUser(data.user, data.pass);
        if (this.loginfailed == null) {
            this.field_230706_i_.func_147108_a(null);
            ExtendedAccountData current = this.getCurrentAsEditable();
            current.premium = true;
            ++current.useCount;
            current.lastused = JavaTools.getDate();
        } else if (this.loginfailed instanceof AlreadyLoggedInException) {
            this.getCurrentAsEditable().lastused = JavaTools.getDate();
        } else if (HttpTools.ping("http://minecraft.net")) {
            this.getCurrentAsEditable().premium = false;
        }
    }

    private void edit() {
        this.field_230706_i_.func_147108_a((Screen)new GuiEditAccount(this.selectedAccountIndex));
    }

    private void updateQueried() {
        this.queriedaccounts = this.convertData();
        if (!this.search.func_146179_b().trim().isEmpty()) {
            for (int i = 0; i < this.queriedaccounts.size(); ++i) {
                if (!this.queriedaccounts.get((int)i).alias.contains(this.search.func_146179_b()) && ConfigValues.CASESENSITIVE) {
                    this.queriedaccounts.remove(i);
                    --i;
                    continue;
                }
                if (this.queriedaccounts.get((int)i).alias.toLowerCase().contains(this.search.func_146179_b().toLowerCase()) || ConfigValues.CASESENSITIVE) continue;
                this.queriedaccounts.remove(i);
                --i;
            }
        }
        if (!this.queriedaccounts.isEmpty()) {
            while (this.selectedAccountIndex >= this.queriedaccounts.size()) {
                --this.selectedAccountIndex;
            }
        }
    }

    public boolean func_231046_a_(int key, int oldkey, int mods) {
        if (key == 265 && !this.queriedaccounts.isEmpty()) {
            if (this.selectedAccountIndex > 0) {
                --this.selectedAccountIndex;
            }
        } else if (key == 264 && !this.queriedaccounts.isEmpty()) {
            if (this.selectedAccountIndex < this.queriedaccounts.size() - 1) {
                ++this.selectedAccountIndex;
            }
        } else if (key == 256) {
            this.escape();
        } else if (key == 261 && this.delete.field_230693_o_) {
            this.delete();
        } else if (key == 257 && !this.search.func_230999_j_() && (this.login.field_230693_o_ || this.loginoffline.field_230693_o_)) {
            if (Screen.func_231173_s_() && this.loginoffline.field_230693_o_) {
                this.logino(this.selectedAccountIndex);
            } else if (this.login.field_230693_o_) {
                this.login(this.selectedAccountIndex);
            }
        } else if (key == 294) {
            this.reloadSkins();
        } else if (this.search.func_230999_j_() && key == 257) {
            this.search.func_146195_b(false);
            return true;
        }
        return super.func_231046_a_(key, oldkey, mods);
    }

    public boolean func_231178_ax__() {
        return false;
    }

    public boolean func_231042_a_(char charT, int mods) {
        if (charT == '+') {
            this.add();
        } else if (charT == '/' && this.edit.field_230693_o_) {
            this.edit();
        } else if (!(this.search.func_230999_j_() || charT != 'r' && charT != 'R')) {
            this.reloadSkins();
        }
        return super.func_231042_a_(charT, mods);
    }

    private ArrayList<ExtendedAccountData> convertData() {
        ArrayList tmp = (ArrayList)AltDatabase.getInstance().getAlts().clone();
        ArrayList<ExtendedAccountData> converted = new ArrayList<ExtendedAccountData>();
        int index = 0;
        for (AccountData data : tmp) {
            if (data instanceof ExtendedAccountData) {
                converted.add((ExtendedAccountData)data);
            } else {
                converted.add(new ExtendedAccountData(EncryptionTools.decode(data.user), EncryptionTools.decode(data.pass), data.alias));
                AltDatabase.getInstance().getAlts().set(index, new ExtendedAccountData(EncryptionTools.decode(data.user), EncryptionTools.decode(data.pass), data.alias));
            }
            ++index;
        }
        return converted;
    }

    private ArrayList<AccountData> getAccountList() {
        return AltDatabase.getInstance().getAlts();
    }

    private ExtendedAccountData getCurrentAsEditable() {
        for (AccountData dat : this.getAccountList()) {
            if (!(dat instanceof ExtendedAccountData) || !dat.equals(this.queriedaccounts.get(this.selectedAccountIndex))) continue;
            return (ExtendedAccountData)dat;
        }
        return null;
    }

    private void updateButtons() {
        this.login.field_230693_o_ = !this.queriedaccounts.isEmpty() && !EncryptionTools.decode(this.queriedaccounts.get((int)this.selectedAccountIndex).pass).equals("");
        this.loginoffline.field_230693_o_ = !this.queriedaccounts.isEmpty();
        this.delete.field_230693_o_ = !this.queriedaccounts.isEmpty();
        this.edit.field_230693_o_ = !this.queriedaccounts.isEmpty();
        this.reloadskins.field_230693_o_ = !AltDatabase.getInstance().getAlts().isEmpty();
    }

    class List
    extends SlotGui {
        public List(Minecraft mcIn) {
            super(mcIn, GuiAccountSelector.this.field_230708_k_, GuiAccountSelector.this.field_230709_l_, 32, GuiAccountSelector.this.field_230709_l_ - 64, 14);
        }

        @Override
        protected int getItemCount() {
            return GuiAccountSelector.this.queriedaccounts.size();
        }

        @Override
        protected boolean isSelectedItem(int i) {
            return i == GuiAccountSelector.this.selectedAccountIndex;
        }

        @Override
        protected void renderBackground(MatrixStack ms) {
            GuiAccountSelector.this.func_230446_a_(ms);
        }

        @Override
        protected void renderItem(MatrixStack ms, int i1, int i2, int i3, int i4, int i5, int i6, float i7) {
            ExtendedAccountData data = (ExtendedAccountData)GuiAccountSelector.this.queriedaccounts.get(i1);
            String s = data.alias;
            if (StringUtils.isEmpty((CharSequence)s)) {
                s = I18n.func_135052_a((String)"ias.alt", (Object[])new Object[0]) + " " + (i1 + 1);
            }
            int color = 0xFFFFFF;
            if (Minecraft.func_71410_x().func_110432_I().func_111285_a().equals(data.alias)) {
                color = 65280;
            }
            List.func_238476_c_((MatrixStack)ms, (FontRenderer)GuiAccountSelector.this.field_230712_o_, (String)s, (int)(i2 + 2), (int)(i3 + 1), (int)color);
        }

        @Override
        public int getItemHeight() {
            return GuiAccountSelector.this.queriedaccounts.size() * 14;
        }

        @Override
        protected boolean selectItem(int i, int i2, double mx, double my) {
            GuiAccountSelector.this.selectedAccountIndex = i;
            GuiAccountSelector.this.updateButtons();
            return super.selectItem(i, i2, mx, my);
        }
    }
}

