/*
 * Decompiled with CFR 0.152.
 */
package com.dragonfight.fight;

import com.dragonfight.DragonfightMod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonDeathPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeMod;

public class DragonFightManagerCustom {
    private static final int CRYSTAL_RESPAWN_TIME = 7000;
    private static final int LIGHTNING_DESTROY_RANGE = 100;
    private static final int ADD_TIMER = 1600;
    private static BlockPos crystalRespawnPos = null;
    private static int crystalRespawnTimer = 0;
    private static int timeSinceLastLanding = 0;
    private static boolean spawnAdds = false;
    private static final BlockPos spawnPos = new BlockPos(0, 68, 0);
    private static int spawnCounter = 0;
    private static List<EnderMan> meleeAdds = new ArrayList<EnderMan>();
    private static int advancingLightningCurrent = 0;
    private static int advancingLightningStop = 0;
    private static int advancingExplosionCurrent = 0;
    private static int advancingExplosionStop = 0;
    private static EnderDragon dragonEntity = null;
    private static boolean isFightRunning = true;
    public static AttributeModifier AA_GRAVITY_MOD = new AttributeModifier("fall", 5.0, AttributeModifier.Operation.ADDITION);
    private static Map<UUID, Integer> flyingPlayers = new HashMap<UUID, Integer>();

    public static void onCrystalDeath(EndCrystal enderCrystalEntity, DamageSource damageSource) {
        AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(enderCrystalEntity.f_19853_, enderCrystalEntity.m_20185_(), enderCrystalEntity.m_20186_(), enderCrystalEntity.m_20189_());
        if (dragonEntity != null) {
            areaeffectcloudentity.m_19718_((LivingEntity)dragonEntity);
        }
        DragonFightManagerCustom.notifyPlayer(enderCrystalEntity.f_19853_, "Crystal died from:" + damageSource);
        areaeffectcloudentity.m_19724_((ParticleOptions)ParticleTypes.f_123799_);
        areaeffectcloudentity.m_19712_(3.0f);
        areaeffectcloudentity.m_19734_(7000 - 200 * DragonFightManagerCustom.getDifficulty());
        areaeffectcloudentity.m_19738_((5.0f - areaeffectcloudentity.m_19743_()) / (float)areaeffectcloudentity.m_19748_());
        areaeffectcloudentity.m_19716_(new MobEffectInstance(MobEffects.f_19602_, 100, Math.min(2, DragonFightManagerCustom.getDifficulty() / 4)));
        areaeffectcloudentity.m_19716_(new MobEffectInstance(MobEffects.f_19610_, 100, 1));
        enderCrystalEntity.f_19853_.m_7967_((Entity)areaeffectcloudentity);
        if (!(damageSource.m_7639_() instanceof Player)) {
            return;
        }
        if (damageSource.m_7639_().m_142538_().m_123331_((Vec3i)enderCrystalEntity.m_142538_()) > 100.0) {
            LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(enderCrystalEntity.f_19853_);
            lightningboltentity.m_6027_(damageSource.m_7639_().m_20185_(), damageSource.m_7639_().m_20186_(), damageSource.m_7639_().m_20189_());
            lightningboltentity.m_20874_(false);
            enderCrystalEntity.f_19853_.m_7967_((Entity)lightningboltentity);
            for (int i = 0; i < Math.min(1, DragonFightManagerCustom.getDifficulty() / 4); ++i) {
                Phantom phantomEntity = (Phantom)EntityType.f_20509_.m_20615_(enderCrystalEntity.f_19853_);
                phantomEntity.m_6710_((LivingEntity)damageSource.m_7639_());
                phantomEntity.m_6027_(damageSource.m_7639_().m_20185_(), damageSource.m_7639_().m_20186_() + 5.0, damageSource.m_7639_().m_20189_());
                enderCrystalEntity.f_19853_.m_7967_((Entity)phantomEntity);
            }
        } else if (dragonEntity != null && dragonEntity.m_21223_() > 100.0f) {
            dragonEntity.m_21153_(dragonEntity.m_21223_() * 0.9f);
            float f = (DragonfightMod.rand.nextFloat() - 0.5f) * 8.0f;
            float f1 = (DragonfightMod.rand.nextFloat() - 0.5f) * 4.0f;
            float f2 = (DragonfightMod.rand.nextFloat() - 0.5f) * 8.0f;
            DragonFightManagerCustom.dragonEntity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123812_, dragonEntity.m_20185_() + (double)f, dragonEntity.m_20186_() + 2.0 + (double)f1, dragonEntity.m_20189_() + (double)f2, 0.0, 0.0, 0.0);
        }
    }

    public static void onWorldTick(Level world) {
        EndDragonFight manager = ((ServerLevel)world).m_8586_();
        if (manager == null || manager.f_64060_.m_8324_().isEmpty() || dragonEntity == null) {
            DragonFightManagerCustom.reset();
            return;
        }
        if (dragonEntity.m_21223_() < dragonEntity.m_21233_() && dragonEntity.m_6084_()) {
            if (!isFightRunning && !manager.f_64060_.m_8324_().isEmpty()) {
                List monsterEntities = world.m_45976_(Monster.class, dragonEntity.m_142469_().m_82400_(150.0));
                for (Monster entity : monsterEntities) {
                    if (entity instanceof Npc || entity.m_21532_()) continue;
                    entity.m_142687_(Entity.RemovalReason.DISCARDED);
                }
                isFightRunning = true;
            }
        } else {
            if (isFightRunning) {
                DragonFightManagerCustom.reset();
            }
            isFightRunning = false;
        }
        if (!isFightRunning) {
            return;
        }
        if (dragonEntity.m_31157_().m_31415_() instanceof DragonDeathPhase && dragonEntity.m_31157_().m_31415_().m_5535_() != null && dragonEntity.m_31157_().m_31415_().m_5535_().m_82531_((double)dragonEntity.m_142538_().m_123341_(), (double)dragonEntity.m_142538_().m_123342_(), dragonEntity.m_20189_()) < 10.0) {
            dragonEntity.m_21153_(0.0f);
        }
        if (++timeSinceLastLanding > 2400 && dragonEntity != null) {
            timeSinceLastLanding = 0;
            dragonEntity.m_31157_().m_31416_(EnderDragonPhase.f_31379_);
            DragonFightManagerCustom.notifyPlayer(world, "Forcing landing phase");
        }
        if (crystalRespawnPos != null) {
            if (--crystalRespawnTimer > 0) {
                if (crystalRespawnTimer == 200) {
                    DragonFightManagerCustom.spawnLightningAtCircle(crystalRespawnPos, 4, world);
                }
            } else {
                DragonFightManagerCustom.notifyPlayer(world, "Respawning crystal at" + crystalRespawnPos);
                DragonFightManagerCustom.respawnCrystalAt(crystalRespawnPos, world);
            }
        }
        if ((double)dragonEntity.m_21223_() > (double)dragonEntity.m_21233_() * 0.9) {
            return;
        }
        for (Player player : manager.f_64060_.m_8324_()) {
            int time = flyingPlayers.computeIfAbsent(player.m_142081_(), s -> 0);
            if (DragonFightManagerCustom.isFlying(player)) {
                if (time == 300) {
                    player.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22118_(AA_GRAVITY_MOD);
                    flyingPlayers.put(player.m_142081_(), ++time);
                    continue;
                }
                if (time > 400) {
                    player.m_6469_(DamageSource.f_19315_, player.m_21233_() * 0.9f);
                    player.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22130_(AA_GRAVITY_MOD);
                    flyingPlayers.put(player.m_142081_(), 0);
                    continue;
                }
                if (time == 100) {
                    player.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22130_(AA_GRAVITY_MOD);
                }
                flyingPlayers.put(player.m_142081_(), ++time);
                continue;
            }
            if (time > 300) {
                player.m_6469_(DamageSource.f_19315_, player.m_21233_() * 0.9f);
                player.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22130_(AA_GRAVITY_MOD);
            }
            flyingPlayers.put(player.m_142081_(), 0);
        }
        if (advancingLightningCurrent > 0 && world.m_46467_() % 100L == 0L) {
            DragonFightManagerCustom.spawnLightningAtCircle(spawnPos, advancingLightningCurrent += 3, world);
            if (advancingLightningCurrent > advancingLightningStop) {
                advancingLightningCurrent = 0;
                advancingLightningStop = 0;
            }
        }
        if (dragonEntity != null && advancingExplosionCurrent == 0 && advancingLightningCurrent == 0 && (double)(dragonEntity.m_21223_() / dragonEntity.m_21233_()) < 0.15) {
            advancingExplosionCurrent = 8;
            advancingExplosionStop = 50;
        }
        if (advancingExplosionCurrent > 0 && world.m_46467_() % 200L == 0L) {
            DragonFightManagerCustom.explodeInCircleAround(spawnPos, advancingExplosionCurrent += 3, world);
            if (advancingExplosionCurrent > advancingExplosionStop) {
                advancingExplosionCurrent = 0;
                advancingExplosionStop = 0;
            }
        }
        if (spawnAdds && spawnCounter++ > 1600 - Math.max(400, DragonFightManagerCustom.getDifficulty() * 50)) {
            DragonFightManagerCustom.notifyPlayer(world, "Spawning melee add");
            DragonFightManagerCustom.spawnMeleeAdds(world);
            spawnCounter = 0;
        }
    }

    private static boolean isFlying(Player player) {
        return player != null && (player.f_19812_ || !player.m_20096_()) && player.f_19789_ <= 0.1f && player.f_19853_.m_46859_(player.m_142538_().m_6625_(2));
    }

    private static void reset() {
        crystalRespawnPos = null;
        spawnAdds = false;
        spawnCounter = 0;
        for (EnderMan endermanEntity : meleeAdds) {
            endermanEntity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        meleeAdds.clear();
    }

    private static void spawnMeleeAdds(Level world) {
        meleeAdds.removeIf(endermanEntity -> endermanEntity.m_146910_());
        if (meleeAdds.size() >= DragonFightManagerCustom.getDifficulty()) {
            return;
        }
        EnderMan endermanEntity2 = (EnderMan)EntityType.f_20566_.m_20615_(world);
        endermanEntity2.m_6027_((double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_());
        world.m_7967_((Entity)endermanEntity2);
        List closesPlayers = world.m_45955_(TargetingConditions.f_26872_, (LivingEntity)endermanEntity2, endermanEntity2.m_142469_().m_82400_(20.0));
        if (!closesPlayers.isEmpty()) {
            Player closestPlayer = (Player)closesPlayers.get(DragonfightMod.rand.nextInt(closesPlayers.size()));
            endermanEntity2.m_6710_((LivingEntity)closestPlayer);
        } else {
            List farPlayers = world.m_45955_(TargetingConditions.f_26872_, (LivingEntity)endermanEntity2, endermanEntity2.m_142469_().m_82377_(60.0, 120.0, 60.0));
            if (!farPlayers.isEmpty()) {
                Player closestPlayer = (Player)farPlayers.get(DragonfightMod.rand.nextInt(farPlayers.size()));
                endermanEntity2.m_6710_((LivingEntity)closestPlayer);
            }
        }
    }

    private static void respawnCrystalAt(BlockPos pos, Level world) {
        if (world.m_45976_(EndCrystal.class, new AABB(pos).m_82400_(2.0)).isEmpty()) {
            EndCrystal crystal = (EndCrystal)EntityType.f_20564_.m_20615_(world);
            crystal.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)crystal);
            for (int i = 0; i < DragonFightManagerCustom.getDifficulty() / 2; ++i) {
                Blaze blaze = (Blaze)EntityType.f_20551_.m_20615_(world);
                blaze.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                world.m_7967_((Entity)blaze);
                blaze.m_6710_((LivingEntity)world.m_45930_((Entity)blaze, 100.0));
            }
            float f = (DragonfightMod.rand.nextFloat() - 0.5f) * 8.0f;
            float f1 = (DragonfightMod.rand.nextFloat() - 0.5f) * 4.0f;
            float f2 = (DragonfightMod.rand.nextFloat() - 0.5f) * 8.0f;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123812_, crystal.m_20185_() + (double)f, crystal.m_20186_() + 2.0 + (double)f1, crystal.m_20189_() + (double)f2, 0.0, 0.0, 0.0);
        }
        crystalRespawnPos = null;
    }

    public static void onDragonHeal(EnderDragon dragonEntity) {
        dragonEntity.m_21153_(Math.min(dragonEntity.m_21233_(), dragonEntity.m_21223_() + (float)DragonFightManagerCustom.getDifficulty() / 5.0f));
    }

    public static float onAttackPlayer(float damage) {
        return damage + (float)(DragonFightManagerCustom.getDifficulty() / 2);
    }

    public static void onPhaseChange(EnderDragonPhase<?> newPhase, EnderDragonPhase<? extends DragonPhaseInstance> oldphase, EnderDragon dragon) {
        if (dragonEntity != dragon) {
            dragonEntity = dragon;
            return;
        }
        if (dragon == null || !(dragon.f_19853_ instanceof ServerLevel) || !dragonEntity.m_6084_()) {
            return;
        }
        EndDragonFight manager = ((ServerLevel)dragon.f_19853_).m_8586_();
        if (manager == null || manager.f_64060_.m_8324_().isEmpty()) {
            return;
        }
        DragonFightManagerCustom.notifyPlayer(dragon.f_19853_, "Next phase:" + newPhase.toString());
        if (newPhase == EnderDragonPhase.f_31381_) {
            spawnAdds = true;
            DragonFightManagerCustom.checkCrystalsToRespawn(dragon.f_19853_);
            if ((double)(dragon.m_21223_() / dragon.m_21233_()) < 0.25 && dragon.m_31158_() != null) {
                dragon.f_19853_.m_7785_(dragon.m_20185_(), dragon.m_20186_(), dragon.m_20189_(), SoundEvents.f_11894_, dragon.m_5720_(), 2.5f, 0.8f + DragonfightMod.rand.nextFloat() * 0.3f, false);
                for (Player playerEntity : dragon.m_31158_().f_64060_.m_8324_()) {
                    playerEntity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 100, DragonFightManagerCustom.getDifficulty() / 3));
                    if (!((double)(dragon.m_21223_() / dragon.m_21233_()) < 0.1)) continue;
                    playerEntity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 200, 1));
                }
            }
        }
        if (newPhase == EnderDragonPhase.f_31379_ || newPhase == EnderDragonPhase.f_31386_) {
            timeSinceLastLanding = 0;
            spawnAdds = false;
        }
        if (oldphase == EnderDragonPhase.f_31380_ && newPhase == EnderDragonPhase.f_31383_) {
            timeSinceLastLanding = 0;
            double healthpercent = dragon.m_21223_() / dragon.m_21233_();
            if (healthpercent < 0.5) {
                advancingLightningCurrent = 6;
                advancingLightningStop = 50;
            } else {
                DragonFightManagerCustom.spawnLightningAtCircle(spawnPos, DragonfightMod.rand.nextInt(16) + 8, dragon.f_19853_);
            }
        }
    }

    private static void checkCrystalsToRespawn(Level world) {
        if (crystalRespawnPos != null) {
            return;
        }
        List spikes = SpikeFeature.m_66858_((WorldGenLevel)((ServerLevel)world));
        Collections.shuffle(spikes, DragonfightMod.rand);
        for (SpikeFeature.EndSpike spike : spikes) {
            BlockPos pos = new BlockPos(spike.m_66886_(), spike.m_66899_(), spike.m_66893_());
            if (!world.m_45976_(EndCrystal.class, spike.m_66905_()).isEmpty()) continue;
            crystalRespawnPos = pos;
            crystalRespawnTimer = Math.max(200, 7000 - 400 * DragonFightManagerCustom.getDifficulty());
            DragonFightManagerCustom.notifyPlayer(world, "Adding respawn at :" + crystalRespawnPos + " in:" + crystalRespawnTimer);
            break;
        }
    }

    private static void spawnLightningAtCircle(BlockPos midPoint, int radius, Level world) {
        Set<BlockPos> lightningPositions = DragonFightManagerCustom.getCircularPositionsAround(midPoint, radius, 5);
        for (BlockPos lightningPos : lightningPositions) {
            DragonFightManagerCustom.notifyPlayer(world, "spawning plightning at!" + new BlockPos(lightningPos.m_123341_(), world.m_5452_(Heightmap.Types.WORLD_SURFACE, lightningPos).m_123342_(), lightningPos.m_123343_()));
            int yLevel = world.m_5452_(Heightmap.Types.WORLD_SURFACE, lightningPos).m_123342_();
            if (Math.abs(midPoint.m_123342_() - yLevel) > 20) continue;
            LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(world);
            lightningboltentity.m_6027_((double)lightningPos.m_123341_(), (double)yLevel, (double)lightningPos.m_123343_());
            lightningboltentity.m_20874_(false);
            world.m_7967_((Entity)lightningboltentity);
        }
    }

    private static void explodeInCircleAround(BlockPos midPoint, int radius, Level world) {
        Set<BlockPos> explodePos = DragonFightManagerCustom.getCircularPositionsAround(midPoint, radius, 15);
        for (BlockPos lightningPos : explodePos) {
            DragonFightManagerCustom.notifyPlayer(world, "spawning explosion at!" + new BlockPos(lightningPos.m_123341_(), world.m_5452_(Heightmap.Types.WORLD_SURFACE, lightningPos).m_123342_(), lightningPos.m_123343_()));
            int yLevel = world.m_5452_(Heightmap.Types.WORLD_SURFACE, lightningPos).m_123342_();
            if (Math.abs(midPoint.m_123342_() - yLevel) > 20) continue;
            world.m_46518_((Entity)dragonEntity, (double)lightningPos.m_123341_(), (double)lightningPos.m_123342_(), (double)lightningPos.m_123343_(), (float)(1 + DragonFightManagerCustom.getDifficulty() / 4), false, Explosion.BlockInteraction.NONE);
        }
    }

    private static Set<BlockPos> getCircularPositionsAround(BlockPos start, int radius, int precision) {
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        for (int i = 0; i < 360; i += precision) {
            int x = (int)Math.round((double)radius * Math.cos(Math.toRadians(i)));
            int z = (int)Math.round((double)radius * Math.sin(Math.toRadians(i)));
            positions.add(start.m_142082_(x, 0, z));
        }
        return positions;
    }

    public static void notifyPlayer(Level world, String message) {
        if (((Boolean)DragonfightMod.config.getCommonConfig().printDragonPhases.get()).booleanValue()) {
            for (Player player : ((ServerLevel)world).m_6907_()) {
                if (world.m_142572_() == null || ((ServerLevel)world).m_142572_().m_129944_(player.m_36316_()) <= 0) continue;
                player.m_6352_((Component)new TextComponent(message), player.m_142081_());
            }
        }
    }

    private static int getDifficulty() {
        int difficulty = (Integer)DragonfightMod.config.getCommonConfig().dragonDifficulty.get();
        if (dragonEntity != null) {
            difficulty += DragonFightManagerCustom.dragonEntity.f_19853_.m_46791_().m_19028_();
            if (dragonEntity.m_31158_() != null) {
                difficulty += DragonFightManagerCustom.dragonEntity.m_31158_().f_64060_.m_8324_().size();
            }
        }
        return difficulty;
    }
}

