/*
 * 	Easy Slider 1.5 - jQuery plugin
 *	written by Alen Grakalic
 */

(function($) {

    $.fn.easySlider = function(options) {
        var defaults = {
            prevId: 'prevBtn',
            prevText: 'Previous',
            nextId: 'nextBtn',
            nextText: 'Next',
            controlsFade: true,
            firstId: 'firstBtn',
            firstText: 'First',
            firstShow: false,
            lastId: 'lastBtn',
            lastText: 'Last',
            lastShow: false,
            vertical: false,
            speed: 300,
            auto: false,
            pause: 2000,
            continuous: false,
            quantity: 1
        };
        var options = $.extend(defaults, options);

        this.each(function() {
            var obj = $(this);
            if ($("li", obj).length <= 0) { return false; }
            var s = $("li", obj).length;
            var w = $("li", obj).width();
            var h = $("li", obj).height();

            var suitcount = (options.quantity >= s) ? s : options.quantity;
            //ʾͼƬܿȱ(Сڻ0)ĻͻΪ1ʾ
            var suitwidth = suitcount * w;
            if ((suitcount * w) > $("ul", obj).width() || suitcount <= 0) {
                suitcount = 1;
                suitwidth = suitcount * w;
            }
            obj.width(suitwidth);
            obj.height(h);
            obj.css("overflow", "hidden");

            var ts = options.vertical ? (parseInt(s / suitcount) - ((s % suitcount > 0) ? 0 : 1)) : (s - suitcount);
            var t = 0;
            if (!options.vertical) {
                $("ul", obj).css('width', s * w);
                $("li", obj).css('float', 'left');
            }
            else {
                $("ul", obj).css('width', suitcount * w)
            }

            $("#" + options.nextId).click(function() {
                //alert("nextId:"+options.nextId);
                animate("next", true);
            });
            $("#" + options.prevId).click(function() {
                //alert("prevId:"+options.prevId);
                animate("prev", true);
            });
            $("#" + options.firstId).click(function() {
                animate("first", true);
            });
            $("#" + options.lastId).click(function() {
                animate("last", true);
            });

            function animate(dir, clicked) {
                var ot = t;
                switch (dir) {
                    case "next":
                        t = (ot >= ts) ? (options.continuous ? 0 : ts) : t + 1;
                        break;
                    case "prev":
                        t = (t <= 0) ? (options.continuous ? ts : 0) : t - 1;
                        break;
                    case "first":
                        t = 0;
                        break;
                    case "last":
                        t = ts;
                        break;
                    default:
                        break;
                };

                var diff = Math.abs(ot - t);
                var speed = diff * options.speed;
                if (!options.vertical) {
                    p = (t * w * -1);
                    $("ul", obj).animate(
						{ marginLeft: p },
						speed
					);
                } else {
                    p = (t * h * -1);
                    $("ul", obj).animate(
						{ marginTop: p },
						speed
					);
                };

                if (!options.continuous && options.controlsFade) {
                    //                    if (t == ts) {
                    //                        $("#" + options.nextId).hide();
                    //                        $("#" + options.lastId).hide();
                    //                    } else {
                    //                        $("#" + options.nextId).show();
                    //                        $("#" + options.lastId).show();
                    //                    };
                    //                    if (t == 0) {
                    //                        $("#" + options.prevId).hide();
                    //                        $("#" + options.firstId).hide();
                    //                    } else {
                    //                        $("#" + options.prevId).show();
                    //                        $("#" + options.firstId).show();
                    //                    };
                };

                if (clicked) clearTimeout(timeout);
                if (options.auto && dir == "next" && !clicked) {
                    ;
                    timeout = setTimeout(function() {
                        animate("next", false);
                    }, diff * options.speed + options.pause);
                };

            };
            // init
            var timeout;
            if (options.auto) {
                ;
                timeout = setTimeout(function() {
                    animate("next", false);
                }, options.pause);
            };

            if (!options.continuous && options.controlsFade) {
                //                $("#" + options.prevId).hide();
                //                $("#" + options.firstId).hide();
            };
            if (s <= options.quantity) {
                //                $("#" + options.prevId).hide();
                //                $("#" + options.nextId).hide(); 
            }
        });

    };

})(jQuery);



