﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="retchinabank.aspx.cs" Inherits="Netsoftok.Web.payservice.chinabank.retchinabank" %>

<%@ Import Namespace="System" %>
<%@ Import Namespace="System.Data" %>
<%@ Import Namespace="cn.com.chinabank.CBSecurity" %>
<%@ Import Namespace="System.Data.SqlClient" %>
<%@ Import Namespace="Netsoftok.Common" %>
<%@ Import Namespace="Netsoftok.Data" %>
<%@ Import Namespace="Netsoftok.AnalysisTemplate" %>
<%@ Import Namespace="System.Text" %>

<script runat="server">
    protected string v_oid;		// 订单号
    protected string v_pstatus;	// 支付状态码
    //20（支付成功，对使用实时银行卡进行扣款的订单）；
    //30（支付失败，对使用实时银行卡进行扣款的订单）；

    protected string v_pstring;	//支付状态描述
    protected string v_pmode;	//支付银行
    protected string v_md5info;	//MD5校验码
    protected string v_amount;	//支付金额
    protected string v_moneytype; //币种		
    protected string remark1;	// 备注1
    protected string remark2;	// 备注1
    protected string v_md5str;
    protected string status_msg;//网银在线服务器在收到“ok”字符串后就不再发送该订单的支付结果信息，否则会自动按照3至4分钟的间隔频率重复发送该支付结果信息

    private void Page_Load(object sender, System.EventArgs e)
    {
        if (!IsPostBack)
        {
           
            // 网银支付账号
            string[] ChinabankConfig = ConfigHelper.GetChinabankByConfig();

            // MD5密钥要跟订单提交页相同，如Send.asp里的 key = "test" ,修改""号内 test 为您的密钥
            string key = ChinabankConfig[1];	// 如果您还没有设置MD5密钥请登陆我们为您提供商户后台，地址：https://merchant3.chinabank.com.cn/
            // 登陆后在上面的导航栏里可能找到“资料管理”，在资料管理的二级导航栏里有“MD5密钥设置”
            // 建议您设置一个16位以上的密钥或更高，密钥最多64位，但设置16位已经足够了

            v_oid = Request["v_oid"];
            v_pstatus = Request["v_pstatus"];
            v_pstring = Request["v_pstring"];
            v_pmode = Request["v_pmode"];
            v_md5str = Request["v_md5str"];
            v_amount = Request["v_amount"];//实际支付金额
            v_moneytype = Request["v_moneytype"];
            remark1 = Request["remark1"];
            remark2 = Request["remark2"];

            string str = v_oid + v_pstatus + v_amount + v_moneytype + key;
            bool isValidMD5Code = MD5Util.verifyMD5(str, v_md5str);
            string result = string.Empty;
            if (isValidMD5Code)
            {
                if (v_pstatus.Equals("20"))
                {
                    //支付成功
                    //在这里商户可以写上自己的业务逻辑

                    //数据库订单比对----订单号，金额值，
                    int re = Netsoftok.Data.UserShopping.UpdateUserPayOrderData(v_oid, v_amount, v_pmode);
                    if (re == 1 || re == 11)
                    {
                        result = "支付成功"; 
                    }
                    else if (re == 2)
                    {
                        result = "支付成功，待管理员审核";
                    }
                    else
                    {
                        result = "支付信息(金额)有误";
                    }
                }
                else if (v_pstatus.Equals("30"))
                {
                    result = "支付失败！";
                }
            }
            else
            {
                result = "支付失败！";
            }

            if (!string.IsNullOrEmpty(v_oid))
            {
                if (v_oid.Substring(0, 1) == "1" || v_oid.Substring(0, 1) == "2" || v_oid.Substring(0, 1) == "7")
                {
                    Response.Redirect(string.Format("/memberpayreturn{5}?orderno={0}&amount={1}&paydate={2}&bankmsg={3}&result={4}",v_oid,v_amount, DateTime.Now.ToString(),Server.UrlEncode("网银在线支付"),Server.UrlEncode(result),ConfigHelper.GetWebFileEx));
                }
                else
                 {
                     Response.Redirect(string.Format("/cartorderpayreturn{5}?orderno={0}&amount={1}&paydate={2}&bankmsg={3}&result={4}", v_oid, v_amount, DateTime.Now.ToString(), Server.UrlEncode("网银在线支付"), Server.UrlEncode(result),ConfigHelper.GetWebFileEx));
                }

            }
        }
    }

</script>

