lmDropdownMenu = function(group_expr, pop_expr, pop_type) {
var that = this;

/* private */
var _menu_length = 0,
_showing = '',
_timer_hide = null,
_group = $(group_expr),
_hovers = _group.children(pop_expr);

/* init */
if (_group.length > 0 && (_menu_length = _hovers.length) > 0) {
_hovers.each(function(i) {
$(this).addClass('lmpop-'+i).css('position', 'relative');
var sub_menu = $(this).children('div.navpop:first');
if (sub_menu.length == 0) {
$(this).addClass('no-sub');
}
});
} else {
return;
}

/* attach event handlers */
if (pop_type == 'hover') {
_hovers.mouseover(function() {that.show(this);});
_hovers.mouseout(function() {that.fade(this);});
}
if (pop_type == 'click') {
_hovers.click(function() {that.show(this);});
_hovers.mouseout(function() {that.fade(this);});
}

/* show */
that.show = function(obj) {
var toshow = '';
var regi_result = obj.className.match(/lmpop-[0-9]+/i);
if (regi_result != null) { // have it right?
toshow = regi_result[0]; // got it.
} else {
return;
}

/* hide other menu */
if (_showing == toshow) {
that.clearFade();
return;
} else if (_showing != '') {
that.hide();
}

var pos_x = $(obj).position().left,
w_win = $(window).width(),
scroll_win_x = $(window).scrollLeft();

if (!$(obj).addClass('on').hasClass('no-sub')) {
var popMenu = $(obj).children('div.navpop:first'),
_gap = popMenu.outerWidth() + pos_x - w_win - scroll_win_x;

if (_gap > 0) {
popMenu.css('left', -1*_gap - 20 + 'px');
} else {
popMenu.css('left', '0px');
}

popMenu.show();
}
_showing = toshow;
};

that.fade = function(obj) {
that.clearFade();
_timer_hide = setTimeout(that.hide, 100);
};

that.clearFade = function() {
if (_timer_hide) {
clearTimeout(_timer_hide);
}
};

that.hide = function() {
that.clearFade();

if (_showing != '') {
var pop = _group.children(pop_expr+'.'+_showing).removeClass('on');
if (!pop.hasClass('no-sub')) {
pop.children('div.navpop:first').hide();
$('#cover_select').hide();
}
_showing = '';
}
};
};

$(document).ready(function() {
var LamiuNav = new lmDropdownMenu('#nav > ul:first', 'li', 'hover');
var LamiuNav = new lmDropdownMenu('#nav2 > ul:first', 'li', 'hover');
var LamiuNav = new lmDropdownMenu('.nav3 > ul', 'li', 'hover');
});
