--
-- CharLi v1 (aka Character Lighting)
-- 2023 by FreakaZ (+FlowerMan)
--
-- https://rootpunk.com/mod/
--

-- init
local CharLi = require("charli.lua")

-- register trigger
registerForEvent("onInit", function()
	CharLi:Initialize()

	-- observe photomode
	Observe('gameuiPhotoModeMenuController', 'OnShow', function()
		CharLi.isPhoto = true
	end)
	Observe('gameuiPhotoModeMenuController', 'OnHide', function()
		CharLi.isPhoto = false
	end)
	Observe('PhotoModePlayerEntityComponent', 'ListAllCurrentItems', function(self)
		CharLi.isModel = self.fakePuppet
	end)
end)

registerForEvent("onUpdate", function ()
	if CharLi.isReady then CharLi:UpdatePlayer() end
end)

registerForEvent("onShutdown", function()
	CharLi:DestroyEverything()
	CharLi.isReady = false
end)

registerForEvent("onOverlayOpen", function()
	if CharLi.isReady then CharLi.isPaint = true end
end)

registerForEvent("onOverlayClose", function()
	if CharLi.isReady then CharLi.isPaint = false end
end)

registerForEvent("onDraw", function()
	if CharLi.isPaint then CharLi:Interface() end
end)

-- EOF