/*!
// iPhone-style Checkboxes jQuery plugin
// Copyright Thomas Reynolds, licensed GPL & MIT
*/;(function($,iphoneStyle){$[iphoneStyle]=function(elem,options){this.$elem=$(elem);var obj=this;$.each(options,function(key,value){obj[key]=value;});this.wrapCheckboxWithDivs();this.attachEvents();this.disableTextSelection();if(this.resizeHandle){this.optionallyResize('handle');}if(this.resizeContainer){this.optionallyResize('container');}this.initialPosition();};$.extend($[iphoneStyle].prototype,{wrapCheckboxWithDivs:function(){this.$elem.wrap('<div class="'+this.containerClass+'" />');this.container=this.$elem.parent();this.offLabel=$('<label class="'+this.labelOffClass+'">'+'<span>'+this.uncheckedLabel+'</span>'+'</label>').appendTo(this.container);this.offSpan=this.offLabel.children('span');this.onLabel=$('<label class="'+this.labelOnClass+'">'+'<span>'+this.checkedLabel+'</span>'+'</label>').appendTo(this.container);this.onSpan=this.onLabel.children('span');this.handle=$('<div class="'+this.handleClass+'">'+'<div class="'+this.handleRightClass+'">'+'<div class="'+this.handleCenterClass+'" />'+'</div>'+'</div>').appendTo(this.container);},disableTextSelection:function(){if(!$.browser.msie){return;}$.each([this.handle,this.offLabel,this.onLabel,this.container],function(){$(this).attr("unselectable","on");});},optionallyResize:function(mode){var onLabelWidth=this.onLabel.width(),offLabelWidth=this.offLabel.width();if(mode=='container'){var newWidth=(onLabelWidth>offLabelWidth)?onLabelWidth:offLabelWidth;newWidth+=this.handle.width()+15;}else{var newWidth=(onLabelWidth<offLabelWidth)?onLabelWidth:offLabelWidth;}this[mode].css({width:newWidth});},attachEvents:function(){var obj=this;this.container.bind('mousedown touchstart',function(event){event.preventDefault();if(obj.$elem.is(':disabled')){return;}var x=event.pageX||event.originalEvent.changedTouches[0].pageX;$[iphoneStyle].currentlyClicking=obj.handle;$[iphoneStyle].dragStartPosition=x;$[iphoneStyle].handleLeftOffset=parseInt(obj.handle.css('left'),10)||0;$[iphoneStyle].dragStartedOn=obj.$elem;}).bind('iPhoneDrag',function(event,x){event.preventDefault();if(obj.$elem.is(':disabled')){return;}if(obj.$elem!=$[iphoneStyle].dragStartedOn){return;}var p=(x+$[iphoneStyle].handleLeftOffset-$[iphoneStyle].dragStartPosition)/obj.rightSide;if(p<0){p=0;}if(p>1){p=1;}obj.handle.css({left:p*obj.rightSide});obj.onLabel.css({width:p*obj.rightSide+4});obj.offSpan.css({marginRight:-p*obj.rightSide});obj.onSpan.css({marginLeft:-(1-p)*obj.rightSide});}).bind('iPhoneDragEnd',function(event,x){if(obj.$elem.is(':disabled')){return;}var checked;if($[iphoneStyle].dragging){var p=(x-$[iphoneStyle].dragStartPosition)/obj.rightSide;checked=(p<0)?Math.abs(p)<0.5:p>=0.5;}else{checked=!obj.$elem.attr('checked');}obj.$elem.attr('checked',checked);$[iphoneStyle].currentlyClicking=null;$[iphoneStyle].dragging=null;obj.$elem.change();});this.$elem.change(function(){if(obj.$elem.is(':disabled')){obj.container.addClass(obj.disabledClass);return false;}else{obj.container.removeClass(obj.disabledClass);}var new_left=obj.$elem.attr('checked')?obj.rightSide:0;obj.handle.animate({left:new_left},obj.duration);obj.onLabel.animate({width:new_left+4},obj.duration);obj.offSpan.animate({marginRight:-new_left},obj.duration);obj.onSpan.animate({marginLeft:new_left-obj.rightSide},obj.duration);});},initialPosition:function(){this.offLabel.css({width:this.container.width()-5});var offset=($.browser.msie&&$.browser.version<7)?3:6;this.rightSide=this.container.width()-this.handle.width()-offset;if(this.$elem.is(':checked')){this.handle.css({left:this.rightSide});this.onLabel.css({width:this.rightSide+4});this.offSpan.css({marginRight:-this.rightSide});}else{this.onLabel.css({width:0});this.onSpan.css({marginLeft:-this.rightSide});}if(this.$elem.is(':disabled')){this.container.addClass(this.disabledClass);}}});$.fn[iphoneStyle]=function(options){var checkboxes=this.filter(':checkbox');if(!checkboxes.length){return this;}var opt=$.extend({},$[iphoneStyle].defaults,options);checkboxes.each(function(){$(this).data(iphoneStyle,new $[iphoneStyle](this,opt));});if(!$[iphoneStyle].initComplete){$(document).bind('mousemove touchmove',function(event){if(!$[iphoneStyle].currentlyClicking){return;}event.preventDefault();var x=event.pageX||event.originalEvent.changedTouches[0].pageX;if(!$[iphoneStyle].dragging&&(Math.abs($[iphoneStyle].dragStartPosition-x)>opt.dragThreshold)){$[iphoneStyle].dragging=true;}$(event.target).trigger('iPhoneDrag',[x]);}).bind('mouseup touchend',function(event){if(!$[iphoneStyle].currentlyClicking){return;}event.preventDefault();var x=event.pageX||event.originalEvent.changedTouches[0].pageX;$($[iphoneStyle].currentlyClicking).trigger('iPhoneDragEnd',[x]);});$[iphoneStyle].initComplete=true;}return this;};$[iphoneStyle].defaults={duration:200,checkedLabel:'ON',uncheckedLabel:'OFF',resizeHandle:true,resizeContainer:true,disabledClass:'iPhoneCheckDisabled',containerClass:'iPhoneCheckContainer',labelOnClass:'iPhoneCheckLabelOn',labelOffClass:'iPhoneCheckLabelOff',handleClass:'iPhoneCheckHandle',handleCenterClass:'iPhoneCheckHandleCenter',handleRightClass:'iPhoneCheckHandleRight',dragThreshold:5};})(jQuery,'iphoneStyle');