//================================================
/*

Zoom
Zoom in or out on web content using the zoom button for more comfortable reading.
Copyright (C) 2012 Stefan vd
www.stefanvd.net

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.


To view a copy of this license, visit http://creativecommons.org/licenses/GPL/2.0/

*/
//================================================


function $(id) { return document.getElementById(id); }
var currentRatio = 1; var ratio = 1; var job = null;

function zoom(ratio){
currentRatio = ratio / 100;
chrome.tabs.query({windowId: chrome.windows.WINDOW_ID_CURRENT, active: true}, function(tabs) {
zoomtab(tabs[0],ratio/100);
});
}

function zoomtab(tab,ratio){
document.getElementById("number").value=Math.round(ratio*100);
document.getElementById("range").value=Math.round(ratio*100);
chrome.tabs.query({active:true}, function(tabs) {job = tabs[0].url;
var webjob = job.match(/^[\w-]+:\/*\[?([\w\.:-]+)\]?(?::\d+)?/)[1];
chrome.extension.sendRequest({name: 'setZoom', value: ratio, urlwebsite: webjob});
});
try{chrome.tabs.executeScript(tab.id,{code:"document.body.style.zoom=" + ratio});}
catch(e){}
}
		
function zoomview(direction){zoom(nextratio(currentRatio*100,direction));}

function nextratio(ratio,direction){
switch(ratio){
	case 50: return (direction==-1)?100:75;
	case 75: return (direction==-1)?50:100;
	case 100: return (direction==-1)?75:125;
	case 125: return (direction==-1)?100:150;
	case 150: return (direction==-1)?125:200;
	case 200: return (direction==-1)?150:400;
	case 400: return (direction==-1)?200:100;
	default: return 100; //more than 400% or less 50% go back to 100%
			}
}

document.addEventListener('DOMContentLoaded', function () {
// default settings
chrome.tabs.query({active:true}, function(tabs) {job = tabs[0].url;
var webjob = job.match(/^[\w-]+:\/*\[?([\w\.:-]+)\]?(?::\d+)?/)[1];
if(localStorage[webjob]){ratio = localStorage[webjob];}
document.getElementById("number").value = Math.round(ratio*100);
document.getElementById("range").value = Math.round(ratio*100);
});

function displayinput(newValue) {document.getElementById("number").value=newValue;}
function showValue(newValue){document.getElementById("range").innerHTML=newValue;document.getElementById("number").value=newValue;zoom(newValue);}
$("range").addEventListener('change', function() {showValue(this.value);});
$("number").addEventListener('change', function() {showValue(this.value);});
$("hund").addEventListener('click', function() {zoom(100);displayinput(100);});
$("minus").addEventListener('click', function() {zoomview(-1);});
$("plus").addEventListener('click', function() {zoomview(+1);});
});