// Generated by CoffeeScript 1.3.1
(function() {

  importScripts('../frameworks/underscore-min.js');

  this.Grouper = (function() {

    Grouper.name = 'Grouper';

    function Grouper() {}

    Grouper.prototype.run = function(visits, options) {
      var intervals,
        _this = this;
      intervals = this.groupByTime(visits, options.interval);
      if (options.domainGrouping) {
        _(intervals).each(function(interval) {
          return interval.visits = _this.groupByDomain(interval.visits);
        });
      }
      return intervals;
    };

    Grouper.prototype.groupByDomain = function(visits) {
      var groupedVisits, previous,
        _this = this;
      groupedVisits = [];
      previous = null;
      _.each(visits, function(visit) {
        if (groupedVisits.length === 0) {
          groupedVisits.push(visit);
          previous = visit;
        } else {
          if (_this._compareVisits(visit, previous)) {
            if (groupedVisits[groupedVisits.length - 1].length === void 0) {
              groupedVisits.pop();
              groupedVisits.push([previous, visit]);
            } else {
              groupedVisits[groupedVisits.length - 1].push(visit);
            }
          } else {
            groupedVisits.push(visit);
          }
        }
        return previous = visit;
      });
      return groupedVisits;
    };

    Grouper.prototype._compareVisits = function(visit1, visit2) {
      if ((visit1 != null) && (visit2 != null)) {
        if (this._domain(visit1) === this._domain(visit2)) {
          return true;
        }
      } else {
        return false;
      }
    };

    Grouper.prototype._domain = function(visit) {
      var match;
      match = visit.url.match(/\/\/(.*?)\//);
      if (match === null) {
        return null;
      } else {
        return match[0];
      }
    };

    Grouper.prototype.groupByTime = function(visits, interval) {
      var arrangedVisits,
        _this = this;
      arrangedVisits = [];
      _.each(visits, function(visit) {
        var id, ids, index, lastVisitTime;
        lastVisitTime = new Date(visit.lastVisitTime);
        id = _this._getTime(lastVisitTime, interval);
        ids = _.pluck(arrangedVisits, 'id');
        index = ids.indexOf(id);
        if (index === -1) {
          arrangedVisits.push({
            datetime: new Date(lastVisitTime.toLocaleDateString() + ' ' + id),
            id: id,
            visits: []
          });
          index = arrangedVisits.length - 1;
        }
        return arrangedVisits[index].visits.push(visit);
      });
      return arrangedVisits;
    };

    Grouper.prototype._minute = function(minutes, interval) {
      minutes = Math.floor(minutes / interval) * interval;
      if (minutes === 0) {
        return '00';
      } else {
        return minutes;
      }
    };

    Grouper.prototype._getTime = function(date, interval) {
      return date.getHours() + ':' + this._minute(date.getMinutes(), interval);
    };

    return Grouper;

  })();

  self.addEventListener('message', function(e) {
    var grouper;
    grouper = new Grouper();
    return postMessage(grouper.run(e.data.visits, {
      interval: e.data.interval,
      domainGrouping: e.data.domainGrouping
    }));
  });

}).call(this);
