// Generated by CoffeeScript 1.3.1
(function() {

  importScripts('../frameworks/underscore-min.js');

  this.VisitsSanitizer = (function() {

    VisitsSanitizer.name = 'VisitsSanitizer';

    function VisitsSanitizer() {}

    VisitsSanitizer.prototype.clean = function(options, results) {
      var prunedResults,
        _this = this;
      this.options = options;
      if (this.options.text) {
        this.terms = options.text.split(' ');
      }
      prunedResults = [];
      _.each(results, function(result) {
        if (_this.options.searching != null) {
          if (prunedResults.length >= 100) {
            return true;
          } else {
            _this.setAdditionalProperties(result);
            if (_this.verifyTextMatch(result)) {
              _this.removeScriptTags(result);
              return prunedResults.push(result);
            }
          }
        } else {
          if (_this.verifyDateRange(result)) {
            _this.setAdditionalProperties(result);
            _this.removeScriptTags(result);
            if (_this.terms && _this.terms.length !== 0) {
              if (_this.verifyTextMatch(result)) {
                return prunedResults.push(result);
              }
            } else {
              return prunedResults.push(result);
            }
          }
        }
      });
      prunedResults.sort(this.sortByTime);
      return prunedResults;
    };

    VisitsSanitizer.prototype.verifyTextMatch = function(result) {
      var hits, regExp;
      hits = [];
      regExp = null;
      _.each(this.terms, function(term) {
        regExp = new RegExp(term, "i");
        if (result.time.match(regExp) || result.url.match(regExp) || result.title.match(regExp)) {
          return hits.push(true);
        }
      });
      if ((this.terms != null) && hits.length === this.terms.length) {
        return true;
      } else {
        return false;
      }
    };

    VisitsSanitizer.prototype.verifyDateRange = function(result) {
      return result.lastVisitTime > this.options.startTime && result.lastVisitTime < this.options.endTime;
    };

    VisitsSanitizer.prototype.removeScriptTags = function(result) {
      var regex;
      regex = /<(.|\n)*?>/ig;
      return _.each(['title', 'url', 'location'], function(property) {
        return result[property] = result[property].replace(regex, "");
      });
    };

    VisitsSanitizer.prototype.setAdditionalProperties = function(result) {
      return result.location = result.url;
    };

    VisitsSanitizer.prototype.sortByTime = function(a, b) {
      if (a.lastVisitTime > b.lastVisitTime) {
        return -1;
      }
      if (a.lastVisitTime < b.lastVisitTime) {
        return 1;
      }
      return 0;
    };

    return VisitsSanitizer;

  })();

  self.addEventListener('message', function(e) {
    var sanitizer;
    sanitizer = new VisitsSanitizer();
    return postMessage(sanitizer.clean(e.data.options, e.data.results));
  });

}).call(this);
