var nameEl = document.getElementById('picker');

var first = []; /* 省，直辖市 */
var second = []; /* 市 */
var third = []; /* 镇 */

var selectedIndex = [0, 0, 0]; /* 默认选中的地区 */

var checked = [0, 0, 0]; /* 已选选项 */

function creatList(obj, list){
  obj.forEach(function(item, index, arr){
  var temp = new Object();
  temp.text = item.name;
  temp.value = index;
  list.push(temp);
  })
}

creatList(city, first);

var select_province=city[selectedIndex[0]]; //省
var select_city;         //市
var select_section;      //县

if (city[selectedIndex[0]].hasOwnProperty('sub')) {
  creatList(city[selectedIndex[0]].sub, second);
  select_city=city[selectedIndex[0]].sub[selectedIndex[1]];
} else {
  second = [{text: '', value: 0}];
}

if (city[selectedIndex[0]].sub[selectedIndex[1]].hasOwnProperty('sub')) {
  creatList(city[selectedIndex[0]].sub[selectedIndex[1]].sub, third);
  select_section=city[selectedIndex[0]].sub[selectedIndex[1]].sub[selectedIndex[2]];
} else {
  third = [{text: '', value: 0}];
}

var picker = new Picker({
	data: [first, second, third],
    selectedIndex: selectedIndex,
	title: '地址选择'
});

picker.on('picker.select', function (selectedVal, selectedIndex) {
  var text1 = first[selectedIndex[0]].text;
  var text2 = second[selectedIndex[1]].text;
  var text3 = third[selectedIndex[2]] ? third[selectedIndex[2]].text : '';
  $("#picker_message").html(text1 + ' ' + text2 + ' ' + text3);
  var  select_province_id=select_province.id;
  var  select_city_id=((select_city!="" && select_city!=undefined)?select_city.id:0);
  var  select_section_id=((select_section!="" && select_section!=undefined)?select_section.aid:0);
  $.ajax({
    type: "get",
    url: "/index.php?case=area&act=select_archive",
    data: {'province_id': select_province_id, "city_id": select_city_id,"aid":select_section_id},
    dataType: 'json',
    async: true,
    success: function (data) {
        if (data.static){
            in_archive(data.archive_data);
        }else{
          alert(data.message);
        }
    }
  });

});
picker.on('picker.change', function (index, selectedIndex) {
  if (index === 0){
    firstChange();
  } else if (index === 1) {
    secondChange();
  }

  function firstChange() {
    second = [];
    third = [];
    checked[0] = selectedIndex;
    var firstCity = city[selectedIndex];
    select_province=firstCity;
    if (firstCity.hasOwnProperty('sub')) {
      creatList(firstCity.sub, second);

      var secondCity = city[selectedIndex].sub[0];
      select_city=secondCity;
      if (secondCity.hasOwnProperty('sub')) {
        creatList(secondCity.sub, third);
        select_section=secondCity.sub[0];
      } else {
        third = [{text: '', value: 0}];
        checked[2] = 0;
        select_section="";
      }
    } else {
      second = [{text: '', value: 0}];
      third = [{text: '', value: 0}];
      checked[1] = 0;
      checked[2] = 0;
      select_city="";
      select_section="";
    }

    picker.refillColumn(1, second);
    picker.refillColumn(2, third);
    picker.scrollColumn(1, 0)
    picker.scrollColumn(2, 0)
  }

  function secondChange() {
    third = [];
    checked[1] = selectedIndex;
    var first_index = checked[0];
    select_city=city[first_index].sub[selectedIndex];
    if (city[first_index].sub[selectedIndex].hasOwnProperty('sub')) {
      var secondCity = city[first_index].sub[selectedIndex];
      select_section=secondCity.sub[0];;
      creatList(secondCity.sub, third);
      picker.refillColumn(2, third);
      picker.scrollColumn(2, 0)
    } else {
      third = [{text: '', value: 0}];
      checked[2] = 0;
      picker.refillColumn(2, third);
      picker.scrollColumn(2, 0);
      select_section="";
    }
  }

});

picker.on('picker.valuechange', function (selectedVal, selectedIndex) {
  console.log(selectedVal);
  console.log(selectedIndex);
});

nameEl.addEventListener('click', function () {
	picker.show();
});



