<?php

if (!defined('ROOT')) exit('Can\'t Access !');

class table_category extends table_mode
{
    function vaild()
    {
        if (!front::post('catname') && !front::post('batch_add')) {
            front::flash(lang_admin('fill_in_the_category_title_etc'));
            return false;
        }
        if (!front::post('langid')) {
            front::flash(lang_admin('please_choose').lang_admin('language_pack'));
            return false;
        }
        if (!front::post('htmldir'))
            front::$post['htmldir'] = pinyin::get2(front::post('catname'));
        return true;
    }

    function view_before(&$data = null)
    {
        $rank = new rank();
        $rank = $rank->getrow('catid=' . front::get('id'));
        if (is_array($rank))
            $data['_ranks'] = unserialize($rank['ranks']);
        else $data['_ranks'] = array();
        unset($data['ranks']);
    }

    function save_after($categoryid = '')
    {
        if (front::$post['_ranks']) {
            $_ranks = serialize(front::post('_ranks'));
            $rank = new rank();
            if (is_array($rank->getrow(array('catid' => front::get('id')))))
                $rank->rec_update(array('ranks' => $_ranks), 'catid=' . $categoryid);
            else
                $rank->rec_insert(array('catid' => front::get('id'), 'ranks' => $_ranks));
        } else {
            $rank = new rank();
            $rank->rec_delete('catid=' . $categoryid);
        }

        //自动加入到用户组配置
        $usergroup=usergroup::getInstance()->getrow('groupid='.user::getuserid());
        if (is_array($usergroup)){
            $groupid=$usergroup['groupid'];
            unset($usergroup['groupid']);
            $powerlist=unserialize($usergroup['powerlist']);
            $powerlist[$categoryid]=1;
            session::set('roles', $powerlist);
            $powerlist=serialize($powerlist);
            usergroup::getInstance()->rec_update(array("powerlist"=>$powerlist),"groupid=".$groupid);
        }

    }

    function save_before()
    {
        parent::save_before();

        //自定义字段允许HTML
        if (is_array(front::$post) && !empty(front::$post)) {
            foreach (front::$post as $k => $v) {
                if (preg_match('/^my_/is', $k)) {
                    front::$post[$k] = htmlspecialchars_decode(front::$post[$k]);
                }
            }
        }

        if (front::$post['htmlrule1'] != '') {
            front::$post['htmlrule'] = front::$post['htmlrule1'];
        }
        if (front::$post['listhtmlrule1'] != '') {
            front::$post['listhtmlrule'] = front::$post['listhtmlrule1'];
        }
        if (front::$post['showhtmlrule1'] != '') {
            front::$post['showhtmlrule'] = front::$post['showhtmlrule1'];
        }
        front::$post['categorycontent'] = stripcslashes(htmlspecialchars_decode(front::$post['categorycontent']));
        front::$post['module'] = 'article';
        front::$post['listorder'] = intval(front::$post['listorder']);
        //var_dump(front::$post['categorycontent']);exit;
    }

    function delete_before($id = '')
    {
        $tbname = config::getdatabase('database', 'prefix') . 'archive';
        $categoryid = front::$get['id'];
        $where = "catid = '$categoryid'";
        $arc = new archive();
        $arcdata=$arc->getrows($where,0);
        if(count($arcdata)>0){
            $arc->query("DELETE FROM $tbname WHERE $where");
        }

    }

    function edit_before(){
        //修改模板触发清空可视化缓存
        if (front::post('template') && front::get('id')) {
            $category = new category();
            $category_data = $category->getrow(array("catid"=>front::get('id')));
            if($category_data['template']!=front::post('template')){
                front::remove(ROOT.'/cache/template_admin');
            }
        }
    }
}