// Codeware 1.3.0

public abstract native class Codeware {
    public static native func Require(version: String) -> Bool
    public static native func Version() -> String
}

public native class ResourceDepot {
    public native func ArchiveExists(name: String) -> Bool
    public native func ResourceExists(path: ResRef) -> Bool
}

@addMethod(GameInstance)
public static native func GetResourceDepot() -> ref<ResourceDepot>

public native struct ResourceRef {
    public static native func LoadPath(self: script_ref<ResourceRef>, path: ResRef)
    public static native func GetPath(self: script_ref<ResourceRef>) -> ResRef
    public static native func GetHash(self: script_ref<ResourceRef>) -> Uint64
    public static native func IsEmpty(self: script_ref<ResourceRef>) -> Bool
    public static native func IsLoaded(self: script_ref<ResourceRef>) -> Bool
    public static native func IsFailed(self: script_ref<ResourceRef>) -> Bool
}

public native struct ResourceAsyncRef {
    public static native func SetPath(self: script_ref<ResourceAsyncRef>, path: ResRef)
    public static native func GetPath(self: script_ref<ResourceAsyncRef>) -> ResRef
    public static native func GetHash(self: script_ref<ResourceAsyncRef>) -> Uint64
    public static native func IsEmpty(self: script_ref<ResourceAsyncRef>) -> Bool
}

public static func OperatorAssignMultiply(out res: ResourceRef, path: ResRef) {
    ResourceRef.LoadPath(res, path);
}

public static func OperatorAssignMultiply(out res: ResourceAsyncRef, path: ResRef) {
    ResourceAsyncRef.SetPath(res, path);
}

@addMethod(ResRef)
public static native func GetHash(self: ResRef) -> Uint64

public static func OperatorEqual(lhs: ResRef, rhs: ResRef) -> Bool {
    return Equals(lhs, rhs);
}

public static func OperatorNotEqual(lhs: ResRef, rhs: ResRef) -> Bool {
    return NotEquals(lhs, rhs);
}

@addMethod(Entity)
public native func GetTemplatePath() -> ResRef

@addMethod(Entity)
public native func GetComponents() -> array<ref<IComponent>>

@addMethod(Entity)
public native func AddComponent(component: ref<IComponent>)

@addMethod(GameObject)
public native func AddTag(tag: CName)

public native struct TagList {
    native let tags: array<CName>;

    public static native func IsEmpty(self: script_ref<TagList>) -> Bool
    public static native func Clear(self: script_ref<TagList>)

    public static native func HasTag(self: script_ref<TagList>, tag: CName) -> Bool
    public static native func AddTag(self: script_ref<TagList>, tag: CName)
    public static native func RemoveTag(self: script_ref<TagList>, tag: CName)

    public static native func HasTags(self: script_ref<TagList>, tags: array<CName>) -> Bool
    public static native func AddTags(self: script_ref<TagList>, tags: array<CName>)
    public static native func RemoveTags(self: script_ref<TagList>, tags: array<CName>)
}

public native class AcousticPortalComponent extends IPlacedComponent {
  native let radius: Uint8;
  native let nominalRadius: Uint8;
  native let initialyOpen: Bool;
}

public native class AdvertisementWidgetComponent extends IWorldWidgetComponent {
  native let format: AdvertisementFormat;
  native let adGroupTDBID: TweakDBID;
  native let enableOverride: Bool;
  native let adOverrideTDBID: TweakDBID;
  native let adVersion: Uint32;
  native let useOnlyAttachedLights: Bool;
}

public importonly native class BakedDestructionComponent extends PhysicalMeshComponent {
  native let meshFractured: ResourceAsyncRef;
  native let meshFracturedAppearance: CName;
  native let numFrames: Float;
  native let frameRate: Float;
  native let playOnlyOnce: Bool;
  native let restartOnTrigger: Bool;
  native let disableCollidersOnTrigger: Bool;
  native let damageThreshold: Float;
  native let damageEndurance: Float;
  native let impulseToDamage: Float;
  native let contactToDamage: Float;
  native let accumulateDamage: Bool;
  native let destructionEffect: ResourceAsyncRef;
  native let audioMetadata: CName;
}

public native class BraindanceDissolveComponent extends IComponent {
  native let dissolveRadius: Float;
}

public native class CorpseComponent extends ISkinableComponent {
  native let material: CName;
}

public native class cpConveyorComponent extends IVisualComponent {}

public native class cpGameplayLightComponent extends LightComponent {
  native let reactToTime: Bool;
  native let begin: GameTime;
  native let end: GameTime;
  native let probability: Float;
  native let delayRange: GameTime;
}

public importonly native class DeviceCameraControlComponent extends GameComponent {}

public native class EditorMeshComponent extends MeshComponent {}

public native class entAmbientSoundEmitterComponent extends IPlacedComponent {
  native let usePhysicsObstruction: Bool;
  native let occlusionEnabled: Bool;
  native let repositionEnabled: Bool;
  native let obstructionChangeTime: Float;
}

public native class entAnimationSetupExtensionComponent extends IComponent {
  native let animations: animAnimSetup;
}

public native class entAnimGraphResourceContainer extends IComponent {
  native let animGraphLookupTable: array<AnimGraphResourceContainerEntry>;
}

public native class entAppearanceProxyMeshComponent extends PhysicalMeshComponent {}

@addField(entCameraComponent)
native let fov: Float;

@addField(entCameraComponent)
native let zoom: Float;

@addField(entCameraComponent)
native let nearPlaneOverride: Float;

@addField(entCameraComponent)
native let farPlaneOverride: Float;

@addField(entCameraComponent)
native let motionBlurScale: Float;

public native class entCharacterCustomizationSkinnedMeshComponent extends entSkinnedMeshComponent {
  native let tags: TagList;
}

public importonly native class entClothComponent extends IVisualComponent {
  native let mesh: ResourceRef;
  native let isEnabled: Bool;
}

public native class entDecalComponent extends IVisualComponent {
  native let material: ResourceRef;
  native let verticalFlip: Bool;
  native let horizontalFlip: Bool;
  native let aspectRatio: Float;
  native let scale: Float;
  native let visualScale: Vector3;
  native let alpha: Float;
  native let normalThreshold: Float;
  native let roughnessScale: Float;
  native let orderNo: Uint16;
  native let surfaceType: ERenderObjectType;
  native let decalRenderMode: EDecalRenderMode;
  native let isStretchingEnabled: Bool;
  native let normalsBlendingMode: RenderDecalNormalsBlendingMode;
  native let shouldCollectWithRayTracing: Bool;
  native let isEnabled: Bool;
}

public native class entDynamicActorRepellingComponent extends IPlacedComponent {
  native let type: entRepellingType;
  native let shape: entRepellingShape;
  native let magnitude: Float;
  native let bendIntensity: Float;
  native let anchorPointVert: rendWindShapeAnchorPointVert;
  native let anchorPointHorz: rendWindShapeAnchorPointHorz;
  native let anchorPointDepth: rendWindShapeAnchorPointDepth;
  native let radius: Float;
  native let capsuleRadius: Float;
  native let capsuleHeight: Float;
}

public native class entEffectAttachmentComponent extends IComponent {}

public importonly native class entEffectSpawnerComponent extends IVisualComponent {
}

public native class entExternalComponent extends IComponent {
  native let externalComponentName: CName;
}

public native class entFacialCustomizationComponent extends IComponent {
  native let debugIgnoreComponent: Bool;
  native let customizationSet: ResourceAsyncRef;
  native let eyes: Uint32;
  native let nose: Uint32;
  native let mouth: Uint32;
  native let jaw: Uint32;
  native let ears: Uint32;
}

public native class entFogVolumeComponent extends IVisualComponent {
  native let densityFalloff: Float;
  native let blendFalloff: Float;
  native let densityFactor: Float;
  native let color: Color;
  native let absorption: Float;
  native let size: Vector3;
  native let isEnabled: Bool;
}

public native class entGarmentSkinnedMeshComponent extends entSkinnedMeshComponent {}

@addField(IComponent)
native let name: CName;

@addField(IComponent)
native let isReplicable: Bool;

@addField(IComponent)
native let id: CRUID;

public abstract importonly native class entIMoverComponent extends IComponent {}

public native class entInstancedAnimationComponent extends ISkinableComponent {
  native let animations: ResourceRef;
  native let animToSample: CName;
  native let variantAnimToSample: CName;
  native let variantTriggerTag: CName;
}

@addField(IPlacedComponent)
native let localTransform: WorldTransform;

public abstract native class entISkinTargetComponent extends IVisualComponent {
  native let useSkinningLOD: Bool;
}

public importonly native class EntitySpawnerComponent extends GameComponent {
  native let slotDataArray: array<EntitySpawnerSlotData>;
}

@addField(IVisualComponent)
native let autoHideDistance: Float;


@addField(IVisualComponent)
native let forceLODLevel: Int8;

public native class entLightBlockingComponent extends IVisualComponent {
  native let radius: Float;
  native let lightBlockerComponentVersion: Uint8;
}

public native class entMarketingAnimationComponent extends IPlacedComponent {
  native let freezeAnimations: Bool;
  native let animations: array<entMarketingAnimationEntry>;
  native let enableLookAt: Bool;
  native let lookAtSettings: ref<animLookAtPreset_FullControl>;
  native let lookAtOrbitDistance: Float;
  native let lookAtTargetPitch: Float;
  native let lookAtTargetYaw: Float;
}

@addField(MeshComponent)
native let mesh: ResourceAsyncRef;

@addField(MeshComponent)
native let meshAppearance: CName;

@addField(MeshComponent)
native let castShadows: shadowsShadowCastingMode;

@addField(MeshComponent)
native let castLocalShadows: shadowsShadowCastingMode;

@addField(MeshComponent)
native let castRayTracedGlobalShadows: shadowsShadowCastingMode;

@addField(MeshComponent)
native let castRayTracedLocalShadows: shadowsShadowCastingMode;

@addField(MeshComponent)
native let motionBlurScale: Float;

@addField(MeshComponent)
native let visualScale: Vector3;

@addField(MeshComponent)
native let renderingPlane: ERenderingPlane;

@addField(MeshComponent)
native let objectTypeID: ERenderObjectType;

@addField(MeshComponent)
native let numInstances: Uint32;

@addField(MeshComponent)
native let chunkMask: Uint64;

@addField(MeshComponent)
native let order: Uint8;

@addField(MeshComponent)
native let isEnabled: Bool;

@addField(MeshComponent)
native let LODMode: entMeshComponentLODMode;

@addField(MeshComponent)
native let forcedLodDistance: entForcedLodDistance;

@addField(MeshComponent)
native let overrideMeshNavigationImpact: Bool;

@addField(MeshComponent)
native let navigationImpact: NavGenNavigationSetting;

public native class entMorphTargetManagerComponent extends entExternalComponent {}

public native class entMorphTargetSkinnedMeshComponent extends entISkinTargetComponent {
  native let morphResource: ResourceAsyncRef;
  native let meshAppearance: CName;
  native let castShadows: shadowsShadowCastingMode;
  native let castLocalShadows: shadowsShadowCastingMode;
  native let acceptDismemberment: Bool;
  native let chunkMask: Uint64;
  native let renderingPlaneAnimationParam: CName;
  native let visibilityAnimationParam: CName;
  native let isEnabled: Bool;
  native let tags: TagList;
}

public native class entParticlesComponent extends IVisualComponent {
  native let emissionRate: Float;
  native let particleSystem: ResourceRef;
  native let autoHideRange: Float;
  native let isEnabled: Bool;
}

public importonly native class entPhysicalImpulseAreaComponent extends PhysicalTriggerComponent {
  native let impulse: Vector3;
  native let impulseRadius: Float;
}

public native class entPlaceholderComponent extends IPlacedComponent {}

public native class entRenderToTextureCameraComponent extends entCameraComponent {
  native let isEnabled: Bool;
  native let virtualCameraName: CName;
  native let dynamicTextureRes: ResourceAsyncRef;
  native let depthDynamicTextureRes: ResourceRef;
  native let albedoDynamicTextureRes: ResourceRef;
  native let normalsDynamicTextureRes: ResourceRef;
  native let particlesDynamicTextureRes: ResourceRef;
  native let resolutionWidth: Uint32;
  native let resolutionHeight: Uint32;
  native let aspectRatio: Float;
  native let env: ResourceRef;
  native let params: WorldRenderAreaSettings;
  native let renderingMode: entRenderToTextureMode;
  native let depthCutDistance: Float;
  native let backgroundColor: Color;
  native let overrideBackgroundColor: Bool;
  native let renderSceneLayer: RenderSceneLayer;
  native let features: entRenderToTextureFeatures;
  native let streamingDistance: Float;
}

public importonly native class entSkinnedClothComponent extends entISkinTargetComponent {
  native let graphicsMesh: ResourceAsyncRef;
  native let physicalMesh: ResourceAsyncRef;
  native let isEnabled: Bool;
  native let LODMode: entMeshComponentLODMode;
  native let meshAppearance: CName;
  native let chunkMask: Uint64;
  native let compiledTopologyData: meshCookedClothMeshTopologyData;
}

public native class entSkinnedMeshComponent extends entISkinTargetComponent {
  native let mesh: ResourceAsyncRef;
  native let meshAppearance: CName;
  native let castShadows: shadowsShadowCastingMode;
  native let castLocalShadows: shadowsShadowCastingMode;
  native let acceptDismemberment: Bool;
  native let chunkMask: Uint64;
  native let renderingPlaneAnimationParam: CName;
  native let visibilityAnimationParam: CName;
  native let order: Uint8;
  native let isEnabled: Bool;
  native let LODMode: entMeshComponentLODMode;
  native let useProxyMeshAsShadowMesh: Bool;
  native let forcedLodDistance: entForcedLodDistance;
  native let overrideMeshNavigationImpact: Bool;
  native let navigationImpact: NavGenNavigationSetting;
}

public native class entSoundListenerComponent extends IPlacedComponent {}

public native class entStaticOccluderMeshComponent extends IPlacedComponent {
  native let mesh: ResourceRef;
  native let scale: Vector3;
  native let color: Color;
  native let occluderType: visWorldOccluderType;
  native let occluderAutohideDistanceScale: Uint8;
}

public native class entTransformComponent extends IPlacedComponent {}

public native class entTriggerActivatorComponent extends IPlacedComponent {
  native let radius: Float;
  native let height: Float;
  native let maxContinousDistance: Float;
  native let enableCCD: Bool;
  native let isEnabled: Bool;
}

public importonly native class entTriggerComponent extends PhysicalTriggerComponent {}

public native class entVectorFieldComponent extends IVisualComponent {
  native let direction: Vector3;
  native let isEnabled: Bool;
}

public native class entVertexAnimationComponent extends IComponent {
  native let vertexAnimationMapper: entVertexAnimationMapper;
}

public native class entVisualControllerComponent extends IComponent {
  native let meshProxy: ResourceRef;
  native let appearanceDependency: array<entVisualControllerDependency>;
  native let cookedAppearanceData: ResourceAsyncRef;
  native let forcedLodDistance: entForcedLodDistance;
}

public native class entVisualOffsetTransformComponent extends entTransformComponent {}

public native class EnvProbeComponent extends IVisualComponent {
  native let isEnabled: Bool;
  native let size: Vector3;
  native let edgeScale: Vector3;
  native let emissiveScale: Float;
  native let globalProbe: Bool;
  native let boxProjection: Bool;
  native let allInShadow: Bool;
  native let streamingDistance: Float;
  native let streamingHeight: Float;
  native let blendRange: Uint8;
  native let neighborMode: envUtilsNeighborMode;
  native let hideSkyColor: Bool;
  native let ambientMode: envUtilsReflectionProbeAmbientContributionMode;
  native let brightnessEVClamp: Uint8;
  native let probeDataRef: ResourceAsyncRef;
  native let priority: Uint8;
}

public native class FootstepComponent extends IComponent {
  native let tweakDBID: TweakDBID;
  native let leftFootSlot: CName;
  native let rightFootSlot: CName;
}

public native class FreeCameraComponent extends CameraComponent {}

public native class gameAIDirectorTensionAnalyzeComponent extends IComponent {}

public native class gameAttachmentSlots extends IComponent {
  native let animParams: array<gameAnimParamSlotsOption>;
}

public native class gameAudioEmitterComponent extends IPlacedComponent {
  native let EmitterName: CName;
  native let EmitterType: audioEntityEmitterContextType;
  native let OnAttach: gameAudioSyncs;
  native let OnDetach: gameAudioSyncs;
  native let updateDistance: Float;
  native let emitterMetadataName: CName;
  native let Tags: array<CName>;
  native let TagList: TagList;
}

public native class gameaudioMusicSyncComponent extends IComponent {
  native let notifyBeats: Bool;
  native let notifyBars: Bool;
  native let notifyGrid: Bool;
  native let notifyBarProgression: Bool;
  native let notifyBeatProgression: Bool;
  native let syncTrack: CName;
}

public native class gameBodyTriggerDestructionComponent extends gameITriggerDestructionComponent {
  native let colliderComponentName: CName;
  native let impulseForce: Float;
  native let impulseRadius: Float;
}

@addField(CameraComponent)
native let animParamFovOverrideWeight: CName;

@addField(CameraComponent)
native let animParamFovOverrideValue: CName;

@addField(CameraComponent)
native let animParamZoomOverrideWeight: CName;

@addField(CameraComponent)
native let animParamZoomOverrideValue: CName;

@addField(CameraComponent)
native let animParamZoomWeaponOverrideWeight: CName;

@addField(CameraComponent)
native let animParamZoomWeaponOverrideValue: CName;

@addField(CameraComponent)
native let animParamdofIntensity: CName;

@addField(CameraComponent)
native let animParamdofNearBlur: CName;

@addField(CameraComponent)
native let animParamdofNearFocus: CName;

@addField(CameraComponent)
native let animParamdofFarBlur: CName;

@addField(CameraComponent)
native let animParamdofFarFocus: CName;

@addField(CameraComponent)
native let animParamWeaponNearPlaneCM: CName;

@addField(CameraComponent)
native let animParamWeaponFarPlaneCM: CName;

@addField(CameraComponent)
native let animParamWeaponEdgesSharpness: CName;

@addField(CameraComponent)
native let animParamWeaponVignetteIntensity: CName;

@addField(CameraComponent)
native let animParamWeaponVignetteRadius: CName;

@addField(CameraComponent)
native let animParamWeaponVignetteCircular: CName;

@addField(CameraComponent)
native let animParamWeaponBlurIntensity: CName;

@addField(CameraComponent)
native let weaponPlane: SWeaponPlaneParams;

public native class gameComponentsStateSaveComponent extends IComponent {}

public native class gameEntityStubComponent extends GameComponent {}

public native class gameEntityStubComponentPlacedProxy extends IPlacedComponent {}

public native class gameHumanoidBody extends IComponent {
  native let basePersonalSpace: Float;
  native let baseHeight: Float;
  native let baseEyesHeightRatio: Float;
  native let stanceAnimFeatureName: CName;
  native let aimAnimFeatureName: CName;
}

public native class gameImpostorComponent extends IComponent {
  native let isCharacterReplica: Bool;
  native let addHead: Bool;
  native let ignorePlayerHeadSlot: Bool;
  native let slotIDsToOmit: array<TweakDBID>;
}

public abstract native class gameITriggerDestructionComponent extends IComponent {
  native let startActive: Bool;
}

public native class gameLadderComponent extends IComponent {
  native let heightOfBottomPart: Float;
  native let exitStepTop: Float;
  native let verticalStepTop: Float;
  native let exitStepBottom: Float;
  native let verticalStepBottom: Float;
  native let exitStepJump: Float;
  native let verticalStepJump: Float;
  native let enterOffset: Float;
}

public native class gameMovingPlatformMountableComponent extends MountableComponent {}

public native class gameObjectMountableComponent extends MountableComponent {}

public native class gameOccupantSlotComponent extends SlotComponent {
  native let slotData: array<gameOccupantSlotData>;
}

public native class gamePhantomEntityComponent extends IComponent {
  native let params: gamePhantomEntityParameters;
}

public native class gamePhotoModeBackgroundCameraComponent extends entCameraComponent {
  native let isEnabled: Bool;
  native let virtualCameraName: CName;
  native let dynamicTextureRes: ResourceAsyncRef;
  native let env: ResourceRef;
  native let params: WorldRenderAreaSettings;
  native let depthCutDistance: Float;
  native let backgroundColor: Color;
  native let overrideBackgroundColor: Bool;
  native let renderSceneLayer: RenderSceneLayer;
  native let streamingDistance: Float;
}

public native class gamePhysicalDestructionListenerComponent extends IComponent {
  native let physicalDestructionComponentName: CName;
  native let thresholdLevels: array<Float>;
}

public native class gamePlayerCommandConsumerComponent extends IComponent {}

public native class gamePlayerTierComponent extends IComponent {}

public native class gamePuppetTriggerDestructionComponent extends gameITriggerDestructionComponent {
  native let projectionDist: Float;
}

public native class gameRootTransformAnimatorComponent extends entIMoverComponent {
  native let animations: array<gameTransformAnimationDefinition>;
}

public native class gameScreenshot360CameraComponent extends CameraComponent {}

public native class gameSimpleOccupantSlotSpawner extends IComponent {}

public native class gameTargetingActivatorComponent extends IComponent {}

public native class gameTargetingLocalizedEffectComponent extends IComponent {
  native let streamingDistance: Float;
  native let visibleTargetRange: Float;
}

public native class gameTPPRepresentationComponent extends IComponent {
  native let detachedObjectInfo: array<gameFppRepDetachedObjectInfo>;
  native let attachedObjectInfo: array<gameTppRepAttachedObjectInfo>;
  native let affectedAppearanceSlots: array<TweakDBID>;
}

public native class gameTransformAnimatorComponent extends IPlacedComponent {
  native let animations: array<gameTransformAnimationDefinition>;
}

public native class gameuiCharacterCustomizationBodyController extends gameuiICharacterCustomizationBodyController {}

public abstract native class gameuiCharacterCustomizationBodyPartsController extends gameuiICharacterCustomizationBodyPartsController {
  native let isHiddenInFpp: Bool;
}

public native class gameuiCharacterCustomizationBrokenNoseController extends gameuiICharacterCustomizationComponent {
  native let stage1App: gameuiCharacterCustomizationBrokenNoseControllerBrokenNoseAppearance;
  native let stage2App: gameuiCharacterCustomizationBrokenNoseControllerBrokenNoseAppearance;
}

public native class gameuiCharacterCustomizationFeetController extends gameuiCharacterCustomizationBodyPartsController {
  native let liftedFeetGroupName: CName;
  native let flatFeetGroupName: CName;
}

public native class gameuiCharacterCustomizationGenitalsController extends gameuiCharacterCustomizationBodyPartsController {
  native let upperBodyGroupName: CName;
  native let bottomBodyGroupName: CName;
  native let forceHideGenitals: Bool;
}

public native class gameuiCharacterCustomizationHairstyleController extends gameuiCharacterCustomizationHeadPartsController {
}

public abstract native class gameuiCharacterCustomizationHeadPartsController extends gameuiCharacterCustomizationBodyPartsController {
  native let groupName: CName;
}

public native class gameuiCharacterCustomizationPersonalLinkController extends gameuiICharacterCustomizationComponent {
  native let simpleLinkGroup: CName;
}

public native class gameuiHolocallCameraComponent extends entRenderToTextureCameraComponent {}

public abstract native class gameuiICharacterCustomizationBodyController extends gameuiICharacterCustomizationComponent {}

public abstract native class gameuiICharacterCustomizationBodyPartsController extends gameuiICharacterCustomizationComponent {}

public abstract native class gameuiICharacterCustomizationComponent extends IComponent {}

public native class gameVisionActivatorComponent extends IComponent {}

public native class gameWeaponAudioComponent extends SoundComponentBase {}

public native class gameWorldSpaceBlendCamera extends entCameraComponent {}

public importonly native class GarageComponent extends GameComponent {}

public native class HeatAgentComponent extends IPlacedComponent {}

public native class HitRepresentationComponent extends SlotComponent {
  native let representations: array<HitShapeContainer>;
  native let physicsMaterial: CName;
  native let bvhRoot: gameHitShapeBVH;
  native let useResourceData: Bool;
  native let resource: ResourceAsyncRef;
}

public native class HudMeshComponent extends MeshComponent {}

public native class LightChannelComponent extends IVisualComponent {
  native let isEnabled: Bool;
}

public importonly native class MappinComponent extends IPlacedComponent {
  native let data: MappinData;
}

public native class moveComponent extends entIMoverComponent {}

public native class moveDroneMotionPlannerComponent extends moveMotionPlannerComponent {}

public abstract native class moveIMotionPlannerComponent extends IComponent {}

public native class moveMotionPlannerComponent extends moveIMotionPlannerComponent {
  native let snapToGround: Bool;
}

public native class mpInteractionActivatorComponent extends IPlacedComponent {}

public native class MultiEcsManagerComponent extends IComponent {}

public native class MuppetBlackboardsComponent extends MuppetComponent {}

public abstract native class MuppetComponent extends IComponent {}

public native class MuppetInputHandlerComponent extends IComponent {}

public native class MuppetInputStates extends MuppetComponent {
  native let replicationTime: netTime;
}

public native class MuppetInventory extends MuppetComponent {}

public native class MuppetLocomotionComponent extends MuppetComponent {}

public native class MuppetPhysicsComponent extends MuppetComponent {}

public native class MuppetRawInput extends MuppetComponent {}

public native class MuppetStats extends MuppetComponent {}

public native class MuppetUpperBodyRequestsComponent extends MuppetComponent {}

public importonly native class NarrationPlateComponent extends IComponent {
  native let narrationCaption: CName;
  native let narrationText: CName;
  native let isEnabled: Bool;
}

public importonly native class NetrunnerPrototypeComponent extends IComponent {
  native let structs: array<gameNetrunnerPrototypeStruct>;
}

public native class ObjectCarrierComponent extends IComponent {
  native let objectToSpawn: TweakDBID;
}

public native class PhotoModeBackgroundViewComponent extends IComponent {
  native let backgroundPrefabRef: NodeRef;
  native let targetPointRef: NodeRef;
}

public importonly native class PhysicalSkinnedMeshComponent extends entSkinnedMeshComponent {
  native let simulationType: physicsSimulationType;
  native let useResourceSimulationType: Bool;
  native let startInactive: Bool;
  native let filterDataSource: physicsFilterDataSource;
}

public abstract importonly native class PhysicalTriggerComponent extends IPlacedComponent {
  native let simulationType: physicsSimulationType;
  native let shape: physicsTriggerShape;
  native let isEnabled: Bool;
}

public native class PingComponent extends IPlacedComponent {
  native let associatedPingType: gamedataPingType;
}

public native class PlayerMappinComponent extends IComponent {}

public native class RagdollComponent extends IComponent {
  native let isEnabled: Bool;
}

public importonly native class ReactionComponent extends IComponent {
  native let reactions: array<ReactionData>;
  native let triggerAutomatically: Bool;
}

public importonly native class ScanningActivatorComponent extends IComponent {}

public native class StreetSignWidgetComponent extends IWorldWidgetComponent {
  native let streetSignTDBID: TweakDBID;
  native let isAStreetName: Bool;
  native let streetNameSignTDBID: TweakDBID;
  native let signSelector: ref<TweakDBIDSelector>;
  native let signVersion: Uint32;
}

public native class TargetPointComponent extends IPlacedComponent {}

public native class TPPCameraComponent extends CameraComponent {}

public native class vehicleAudioComponent extends SoundComponentBase {}

public native class vehicleLightComponent extends gameLightComponent {
  native let allowSeparateEmissiveColor: Bool;
  native let emissiveColor: Color;
  native let lightType: vehicleELightType;
  native let highBeamPitchAngle: Float;
  native let highBeamRadiusMultiplier: Float;
  native let highBeamConeMultiplier: Float;
}

public native class vehiclePersistentData extends GameComponent {}

public native class vehicleVehicleMountableComponent extends MountableComponent {
}

public native class vehicleVehicleProxyBlendCamera extends CameraComponent {}

public native class WetnessComponent extends IComponent {}

public native class WidgetMenuComponent extends WidgetMenuComponentInterface {}

public native class WidgetMenuComponentInterface extends WidgetBaseComponent {
  native let widgetResource: ResourceRef;
  native let cursorResource: ResourceRef;
  native let externalMaterial: ResourceRef;
}

@addField(worlduiWidgetComponent)
native let cursorResource: ResourceRef;

@addField(worlduiWidgetComponent)
native let widgetResource: ResourceAsyncRef;

@addField(worlduiWidgetComponent)
native let itemNameToSpawn: CName;

@addField(worlduiWidgetComponent)
native let staticTextureResource: ResourceAsyncRef;

@addField(worlduiWidgetComponent)
native let sceneWidgetProperties: worlduiSceneWidgetProperties;

@addField(worlduiWidgetComponent)
native let spawnDistanceOverride: Float;

@addField(worlduiWidgetComponent)
native let limitedSpawnDistanceFromVehicle: Bool;

enum AdvertisementFormat {
  Format_0_7x1 = 0,
  Format_1x1 = 1,
  Format_1x0_7 = 2,
  Format_1x1_5 = 3,
  Format_1x2 = 4,
  Format_1x3_3 = 5,
  Format_1_5x1 = 6,
  Format_2x1 = 7,
  Format_3_3x1 = 8,
  Format_3x4 = 9,
  Format_4x3 = 10,
  Format_9x16 = 11,
  Format_9x21 = 12,
  Format_16x9 = 13,
  Format_21x9 = 14,
  Format_a = 15,
  Format_b = 16,
  Format_c = 17,
  Format_d = 18,
  Format_e = 19,
  Format_f = 20,
  Format_i = 21,
  Format_o = 22,
  Format_k = 23,
}

public native struct animAnimSetup {
  native let cinematics: array<animAnimSetupEntry>;
  native let gameplay: array<animAnimSetupEntry>;
  native let hash: Uint64;
}

public native struct animAnimSetupEntry {
  native let priority: Uint8;
  native let animSet: ResourceAsyncRef;
  native let variableNames: array<CName>;
}

public native struct AnimGraphResourceContainerEntry {
  native let graphName: CName;
  native let animGraphResource: ResourceRef;
}

public native class animLookAtPreset_FullControl extends animLookAtPreset {
  native let limits: LookAtLimits;
  native let eyesSuppress: Float;
  native let eyesMode: Int32;
  native let headSuppress: Float;
  native let headMode: Int32;
  native let headSquareScale: Float;
  native let chestSuppress: Float;
  native let chestMode: Int32;
  native let chestSquareScale: Float;
}

public abstract native class animLookAtPreset extends IScriptable {}

public native struct audioAudEventStruct {
  native let event: CName;
}

public native struct audioAudParameter {
  native let name: CName;
  native let value: Float;
  native let enterCurveType: audioESoundCurveType;
  native let enterCurveTime: Float;
  native let exitCurveType: audioESoundCurveType;
  native let exitCurveTime: Float;
}

public native struct audioAudSwitch {
  native let name: CName;
  native let value: CName;
}

enum audioEntityEmitterContextType {
  Entity_Emitter = 0,
  Radio_Emitter = 2,
}

enum audioESoundCurveType {
  Log3 = 0,
  Sine = 1,
  InversedSCurve = 3,
  Linear = 4,
  SCurve = 5,
  Exp1 = 6,
  ReciprocalOfSineCurve = 7,
  Exp3 = 8,
}

enum EDecalRenderMode {
  DRM_AllStatic = 0,
  DRM_ObjectType = 1,
  DRM_AllDynamic = 2,
}

enum entAnimParamSlotFunction {
  RenderingPlane = 0,
  Visibility = 1,
}

enum entForcedLodDistance {
  Default = 0,
  Background = 1,
  Regular = 2,
  Cinematic = 3,
  Vehicle = 4,
  CinematicVehicle = 5,
  VehicleInterior = 6,
  LargeVehicleInterior = 7,
  ConsoleLOD = 8,
}

public native struct EntitySpawnerSlotData {
  native let slotName: CName;
  native let spawnableObject: TweakDBID;
}

public native struct entMarketingAnimationEntry {
  native let animationName: CName;
  native let time: Float;
  native let frame: Float;
}

enum entMeshComponentLODMode {
  AlwaysVisible = 0,
  Appearance = 1,
  AppearanceProxy = 2,
}

public native struct entRenderToTextureFeatures {
  native let renderDecals: Bool;
  native let renderParticles: Bool;
  native let renderForwardNoTXAA: Bool;
  native let antiAliasing: entRenderToTextureFeaturesPlatform;
  native let contactShadows: Bool;
  native let localShadows: Bool;
}

enum entRenderToTextureFeaturesPlatform {
  RTFP_All = 0,
  RTFP_PC = 1,
  RTFP_PC_PS5_XSX = 2,
  RTFP_Consoles = 3,
  RTFP_None = 4,
}

enum entRenderToTextureMode {
  Shaded = 0,
  GBufferOnly = 1,
}

enum entRepellingShape {
  Sphere = 0,
  Capsule = 1,
}

enum entRepellingType {
  Debris = 0,
  BigObjects = 1,
  WindImpulse = 2,
  WaterImpulse = 3,
}

public native struct entVertexAnimationMapper {
  native let entries: array<entVertexAnimationMapperEntry>;
}

public native struct entVertexAnimationMapperDestination {
  native let vertexCustomSlotIndex: Uint32;
}

public native struct entVertexAnimationMapperEntry {
  native let destination: entVertexAnimationMapperDestination;
}

public native struct entVisualControllerDependency {
  native let mesh: ResourceAsyncRef;
  native let appearanceName: CName;
  native let componentName: CName;
}

enum envUtilsNeighborMode {
  eCLOSEST = 0,
  eONLY_GLOBAL = 1,
  eONLY_SELF = 2,
  eFILL_SURROUNDING = 3,
}

enum envUtilsReflectionProbeAmbientContributionMode {
  eNO_AMBIENT_CONTRIBUTION = 0,
  eALLOW_AMBIENT_CONTRIBUTION = 1,
  eOVERRIDE_GI_AMBIENT = 2,
}

enum ERenderObjectType {
  ROT_Static = 0,
  ROT_Terrain = 1,
  ROT_Road = 2,
  ROT_Skinned = 20,
  ROT_Character = 21,
  ROT_Foliage = 22,
  ROT_Grass = 23,
  ROT_Vehicle = 24,
  ROT_Weapon = 25,
  ROT_Particle = 26,
  ROT_Enemy = 27,
  ROT_CustomCharacter1 = 12,
  ROT_CustomCharacter2 = 13,
  ROT_CustomCharacter3 = 14,
  ROT_MainPlayer = 15,
  ROT_NoAO = 16,
  ROT_NoLighting = 17,
  ROT_NoTXAA = 18,
}

public native struct gameAnimParamSlotsOption {
  native let slotID: TweakDBID;
  native let paramName: CName;
  native let function: entAnimParamSlotFunction;
}

public native struct gameAudioSyncs {
  native let switchEvents: array<audioAudSwitch>;
  native let playEvents: array<audioAudEventStruct>;
  native let stopEvents: array<audioAudEventStruct>;
  native let parameterEvents: array<audioAudParameter>;
}

public native struct gameFppRepDetachedObjectInfo {
  native let slotID: TweakDBID;
  native let itemTDBID: TweakDBID;
}

public native struct gameHitShapeBVH {
  native let nodeName: CName;
  native let childrenNodes: array<gameHitShapeBVH>;
  native let childrenShapeNames: array<CName>;
}

public native struct gameNetrunnerPrototypeStruct {
  native let key: CName;
  native let entityTemplate: ResourceAsyncRef;
}

public importonly native struct gameOccupantSlotData {
  native let slotName: CName;
  native let syncAnimationTag: CName;
  native let workSpotResource: ResourceRef;
  native let exitOffsetFromSlot: Vector4;
  native let role: gameMountingSlotRole;
}

public native struct gamePhantomEntityParameters {
  native let teleportStartEffect: CName;
  native let teleportEndEffect: CName;
  native let spawnEffect: CName;
  native let glitchEffect: CName;
  native let blendableAppearanceMatches: array<gamePhantomEntityParametersBlendableAppearanceMatch>;
}

public native struct gamePhantomEntityParametersBlendableAppearanceMatch {
  native let blendable: CName;
  native let notBlendable: CName;
}

public native struct gameTppRepAttachedObjectInfo {
  native let slotID: TweakDBID;
  native let itemID: TweakDBID;
}

public native struct gameTransformAnimationDefinition {
  native let name: CName;
  native let autoStart: Bool;
  native let autoStartDelay: Float;
  native let timesToPlay: Uint32;
  native let looping: Bool;
  native let timeScale: Float;
  native let reverse: Bool;
  native let timeline: gameTransformAnimationTimeline;
}

public native struct gameTransformAnimationTimeline {
}

public native struct gameuiCharacterCustomizationBrokenNoseControllerBrokenNoseAppearance {
  native let resource: ResourceAsyncRef;
  native let definition: CName;
}

public importonly native struct HitShapeContainer {
  native let name: CName;
  native let slotName: CName;
  native let color: Color;
  native let userData: ref<HitShapeUserData>;
  native let physicsMaterial: physicsMaterialReference;
}

public native struct meshCookedClothMeshTopologyData {
  native let gfxIndexToTriangles: array<Uint32>;
  native let phxIndexToTriangles: array<Uint32>;
  native let gfxBarycentrics: array<Uint32>;
  native let phxBarycentrics: array<Uint32>;
  native let phxLodSwitchData: array<Uint32>;
  native let phxSimulated: array<Uint32>;
  native let gfxNumIndicesToTriangles: Uint32;
  native let phxNumIndicesToTriangles: Uint32;
  native let gfxNumBarycentrics: Uint32;
  native let phxNumBarycentrics: Uint32;
  native let phxNumLodSwitchData: Uint32;
  native let phxNumSimulated: Uint32;
}

public native struct NavGenNavigationSetting {
  native let navmeshImpact: NavGenNavmeshImpact;
}

enum NavGenNavmeshImpact {
  Ignored = 1,
  Walkable = 0,
  Blocking = 2,
  Road = 3,
  CrowdWalkable = 4,
  Stairs = 5,
  Drones = 6,
}

public native struct netTime {
  native let milliSecs: Uint64;
}

enum physicsFilterDataSource {
  Parent = 0,
  Collider = 1,
  Component = 0,
  Body = 1,
}

public native struct physicsMaterialReference {
  native let name: CName;
}

enum physicsShapeType {
  Box = 0,
  Sphere = 1,
  Capsule = 2,
  ConvexMesh = 3,
  TriangleMesh = 4,
  Invalid = 6,
}

enum physicsSimulationType {
  Static = 0,
  Dynamic = 1,
  Kinematic = 2,
  Invalid = 3,
}

public native struct physicsTriggerShape {
  native let shapeType: physicsShapeType;
  native let shapeSize: Vector3;
  native let shapeLocalPose: Transform;
}

enum RenderDecalNormalsBlendingMode {
  AlphaBlending = 0,
  Reorient = 1,
}

enum RenderSceneLayer {
  Default = 0,
  Cyberspace = 1,
  WorldMap = 2,
}

enum rendWindShapeAnchorPointDepth {
  AP_CENTER = 0,
  AP_FRONT = 1,
  AP_BACK = 2,
}

enum rendWindShapeAnchorPointHorz {
  AP_CENTER = 0,
  AP_RIGHT = 1,
  AP_LEFT = 2,
}

enum rendWindShapeAnchorPointVert {
  AP_CENTER = 0,
  AP_TOP = 1,
  AP_BOTTOM = 2,
}

enum shadowsShadowCastingMode {
  Default = 0,
  Always = 1,
  Never = 2,
}

public native struct SWeaponPlaneParams
{
    native let weaponNearPlaneCM: Float;
    native let blurIntensity: Float;
}

enum visWorldOccluderType {
  Default = 0,
  None = 1,
  Detail = 2,
  MinorInterior = 3,
  MajorInterior = 4,
  Exterior = 5,
}

public native struct WorldRenderAreaSettings {
}

public native struct worlduiSceneWidgetProperties {
  native let projectionPlaneSize: Vector2;
  native let renderingPlane: ERenderingPlane;
  native let isAlwaysVisible: Bool;
  native let isInteractable: Bool;
  native let isInteractableFromBehind: Bool;
  native let maxInteractionDistance: Float;
  native let useCustomFaceVector: Bool;
  native let faceVector: Vector3;
}

@addMethod(WardrobeSystem)
public native func ForgetItemID(itemID: ItemID) -> Bool

enum ERTTIType
{
    Name = 0,
    Fundamental = 1,
    Class = 2,
    Array = 3,
    Simple = 4,
    Enum = 5,
    StaticArray = 6,
    NativeArray = 7,
    Pointer = 8,
    Handle = 9,
    WeakHandle = 10,
    ResourceReference = 11,
    ResourceAsyncReference = 12,
    BitField = 13,
    LegacySingleChannelCurve = 14,
    ScriptReference = 15,
    FixedArray = 16
}

public native struct Reflection {
    public static native func GetTypeOf(value: Variant) -> ref<ReflectionType>
    public static native func GetClassOf(object: Variant, opt actual: Bool) -> ref<ReflectionClass>
    public static native func GetType(name: CName) -> ref<ReflectionType>
    public static native func GetClass(name: CName) -> ref<ReflectionClass>
    public static native func GetEnum(name: CName) -> ref<ReflectionEnum>
    public static native func GetGlobalFunction(name: CName) -> ref<ReflectionStaticFunc>
    public static native func GetTypes() -> array<ref<ReflectionType>>
    public static native func GetClasses() -> array<ref<ReflectionClass>>
    public static native func GetDerivedClasses(base: CName) -> array<ref<ReflectionClass>>
    public static native func GetEnums() -> array<ref<ReflectionEnum>>
    public static native func GetGlobalFunctions() -> array<ref<ReflectionStaticFunc>>
}

public native class ReflectionClass extends ReflectionType {
    public native func GetAlias() -> CName
    public native func GetParent() -> ref<ReflectionClass>
    public native func GetProperty(name: CName) -> ref<ReflectionProp>
    public native func GetFunction(name: CName) -> ref<ReflectionMemberFunc>
    public native func GetStaticFunction(name: CName) -> ref<ReflectionStaticFunc>
    public native func GetProperties() -> array<ref<ReflectionProp>>
    public native func GetFunctions() -> array<ref<ReflectionMemberFunc>>
    public native func GetStaticFunctions() -> array<ref<ReflectionStaticFunc>>
    public native func IsNative() -> Bool
    public native func IsAbstract() -> Bool
}

public native class ReflectionEnum extends ReflectionType {
    public native func GetConstants() -> array<ref<ReflectionConst>>
    public native func IsNative() -> Bool
}

public native class ReflectionConst {
    public native func GetName() -> CName
    public native func GetValue() -> Int64
}

public native class ReflectionFunc {
    public native func GetName() -> CName
    public native func GetFullName() -> CName
    public native func GetParameters() -> array<ref<ReflectionProp>>
    public native func GetReturnType() -> ref<ReflectionType>
    public native func IsNative() -> Bool
    public native func IsStatic() -> Bool
}

public native class ReflectionMemberFunc extends ReflectionFunc {
    public native func Call(self: ref<IScriptable>, opt args: array<Variant>, opt status: script_ref<Bool>) -> Variant
}

public native class ReflectionStaticFunc extends ReflectionFunc {
    public native func Call(opt args: array<Variant>, opt status: script_ref<Bool>) -> Variant
}

public native class ReflectionProp {
    public native func GetName() -> CName
    public native func GetType() -> ref<ReflectionType>
    public native func IsNative() -> Bool
    public native func GetValue(owner: Variant) -> Variant
    public native func SetValue(owner: Variant, value: Variant)
}

public native class ReflectionType {
    public native func GetName() -> CName
    public native func GetMetaType() -> ERTTIType
    public native func GetInnerType() -> ref<ReflectionType>

    public func IsArray() -> Bool {
        return Equals(this.GetMetaType(), ERTTIType.Array);
    }

    public func IsClass() -> Bool {
        return Equals(this.GetMetaType(), ERTTIType.Class);
    }

    public func IsEnum() -> Bool {
        return Equals(this.GetMetaType(), ERTTIType.Enum);
    }

    public func AsClass() -> ref<ReflectionClass> {
        return Reflection.GetClass(this.GetName());
    }

    public func AsEnum() -> ref<ReflectionEnum> {
        return Reflection.GetEnum(this.GetName());
    }
}

public class ControllerDelayCallback extends DelayCallback {
    public let controller: wref<IScriptable>;
    public let event: ref<Event>;

    public func Call() {
        if IsDefined(this.controller) {
            if this.controller.IsA(n"gameuiWidgetGameController") {
                (this.controller as inkGameController).QueueEvent(this.event);
                return;
            }

            if this.controller.IsA(n"inkWidgetLogicController") {
                (this.controller as inkLogicController).QueueEvent(this.event);
                return;
            }
        }
    }
}

@addMethod(DelaySystem)
public func DelayEvent(controller: wref<inkGameController>, eventToDelay: ref<Event>, timeToDelay: Float, opt isAffectedByTimeDilation: Bool) -> DelayID {
    let callback = new ControllerDelayCallback();
    callback.controller = controller;
    callback.event = eventToDelay;

    return this.DelayCallback(callback, timeToDelay, isAffectedByTimeDilation);
}

@addMethod(DelaySystem)
public func DelayEventNextFrame(controller: wref<inkGameController>, eventToDelay: ref<Event>) {
    let callback = new ControllerDelayCallback();
    callback.controller = controller;
    callback.event = eventToDelay;

    this.DelayCallbackNextFrame(callback);
}

@addMethod(DelaySystem)
public func DelayEvent(controller: wref<inkLogicController>, eventToDelay: ref<Event>, timeToDelay: Float, opt isAffectedByTimeDilation: Bool) -> DelayID {
    let callback = new ControllerDelayCallback();
    callback.controller = controller;
    callback.event = eventToDelay;

    return this.DelayCallback(callback, timeToDelay, isAffectedByTimeDilation);
}

@addMethod(DelaySystem)
public func DelayEventNextFrame(controller: wref<inkLogicController>, eventToDelay: ref<Event>) {
    let callback = new ControllerDelayCallback();
    callback.controller = controller;
    callback.event = eventToDelay;

    this.DelayCallbackNextFrame(callback);
}

public native class AxisInputEvent extends KeyInputEvent {
    public native func GetValue() -> Float
    public native func GetMouseX() -> Uint32
    public native func GetMouseY() -> Uint32
}

public native class CallbackSystem extends IGameSystem {
    public native func RegisterCallback(event: CName, target: ref<IScriptable>, function: CName, opt sticky: Bool)
    public native func UnregisterCallback(event: CName, target: ref<IScriptable>, opt function: CName)
    public native func RegisterStaticCallback(event: CName, target: CName, function: CName, opt sticky: Bool)
    public native func UnregisterStaticCallback(event: CName, target: CName, opt function: CName)
    public native func FireCallbacks(event: ref<NamedEvent>)
}

@addMethod(GameInstance)
public static native func GetCallbackSystem() -> ref<CallbackSystem>

public native class EntityLifecycleEvent extends NamedEvent {
    public native func GetEntity() -> wref<Entity>
}

public native class GameSessionEvent extends NamedEvent {
    public native func IsRestored() -> Bool
    public native func IsPreGame() -> Bool
}

public native class KeyInputEvent extends NamedEvent {
    public native func GetAction() -> EInputAction
    public native func GetKey() -> EInputKey
    public native func IsShiftDown() -> Bool
    public native func IsControlDown() -> Bool
    public native func IsAltDown() -> Bool
}

public abstract native class NamedEvent {
    protected native func InitEvent(name: CName)
    public native func GetEventName() -> CName
}

public abstract native class ScriptableEnv {

    public static native func Get(name: CName) -> ref<ScriptableEnv>
}

public native struct StackTraceEntry {
    public native let class: CName;
    public native let function: CName;
    public native let object: wref<IScriptable>;
}

public static native func GetStackTrace(opt depth: Int32, opt current: Bool) -> array<StackTraceEntry>

public native class inkSystem extends IGameSystem {
    private let m_clipboard: String;

    public native func GetLayers() -> array<ref<inkLayerWrapper>>
    public native func GetLayer(layer: CName) -> ref<inkLayerWrapper>

    public func GetClipboard() -> String {
        return this.m_clipboard;
    }

    public func SetClipboard(data: String) {
        this.m_clipboard = data;
    }
}

@addMethod(GameInstance)
public static native func GetInkSystem() -> ref<inkSystem>

@addMethod(GameInstance)
public static func GetSystemRequestsHandler() -> wref<inkISystemRequestsHandler> {
    return new inkMenuScenario().GetSystemRequestsHandler();
}

enum EInputAction
{
    IACT_None = 0,
    IACT_Press = 1,
    IACT_Release = 2,
    IACT_Axis = 3
}

@addMethod(inkCharacterEvent)
public native func GetType() -> inkCharacterEventType

@addMethod(inkCharacterEvent)
public native func GetAction() -> EInputAction

enum inkCharacterEventType
{
    CharInput = 0,
    MoveCaretForward = 1,
    MoveCaretBackward = 2,
    Delete = 3,
    Backspace = 4
}

@addField(inkCircle)
native let segmentsNumber: Uint32;

@addMethod(inkCircle)
public func GetSegmentsNumber() -> Uint32 {
    return this.segmentsNumber;
}

@addMethod(inkCircle)
public func SetSegmentsNumber(segmentsNumber: Uint32) {
    this.segmentsNumber = segmentsNumber;
}

public abstract native class inkComponent extends inkLogicController {
    public native func IsAttached() -> Bool

    public func Reparent(newParent: wref<inkCompoundWidget>) {
        this.Reparent(newParent, -1);
    }

    public func Reparent(newParent: wref<inkCompoundWidget>, index: Int32) {
        this.GetRootWidget().Reparent(newParent, index);
    }
}

enum inkEEndCapStyle {
    BUTT = 0,
    SQUARE = 1,
    ROUND = 2,
    JOINED = 3,
}

enum inkEJointStyle {
    MITER = 0,
    BEVEL = 1,
    ROUND = 2,
}

enum inkEShapeVariant {
    Fill = 0,
    Border = 1,
    FillAndBorder = 2,
}

enum inkFitToContentDirection
{
    None = 0,
    Horizontal = 2,
    Vertical = 1
}

public native class inkGrid extends inkCompoundWidget {
    public native let orientation: inkEOrientation;
    public native let childPadding: inkMargin;
    public native let childSizeStep: Vector2;

    public func GetOrientation() -> inkEOrientation {
        return this.orientation;
    }

    public func SetOrientation(value: inkEOrientation) {
        this.orientation = value;
    }

    public func GetChildPadding() -> inkMargin {
        return this.childPadding;
    }

    public func SetChildPadding(value: inkMargin) {
        this.childPadding = value;
    }

    public func GetChildSizeStep() -> Vector2 {
        return this.childSizeStep;
    }

    public func SetChildSizeStep(value: Vector2) {
        this.childSizeStep = value;
    }
}

@addField(inkGridController)
native let height: Uint32;

@addField(inkGridController)
native let width: Uint32;

@addField(inkGridController)
native let items: array<inkGridItem>;

@addField(inkGridController)
native let slotSize: Vector2;

@addField(inkGridController)
native let itemTemplates: array<inkGridItemTemplate>;

public native struct inkGridItem
{
	public native let rootIdx: Uint32;
}

public native struct inkGridItemTemplate
{
	public native let sizeX: Uint32;
	public native let sizeY: Uint32;
	public native let widget: inkWidgetLibraryReference;
}

@addField(inkImage)
native let useNineSliceScale: Bool;

@addField(inkImage)
native let nineSliceScale: inkMargin;

@addField(inkImage)
native let tileHAlign: inkEHorizontalAlign;

@addField(inkImage)
native let tileVAlign: inkEVerticalAlign;

@addMethod(inkImage)
public func UsesNineSliceScale() -> Bool {
    return this.useNineSliceScale;
}

@addMethod(inkImage)
public func SetNineSliceScale(enable: Bool) {
    this.useNineSliceScale = enable;
}

@addMethod(inkImage)
public func GetNineSliceGrid() -> inkMargin {
    return this.nineSliceScale;
}

@addMethod(inkImage)
public func SetNineSliceGrid(grid: inkMargin) {
    this.nineSliceScale = grid;
}

@addMethod(inkImage)
public func GetTileHAlign() -> inkEHorizontalAlign {
    return this.tileHAlign;
}

@addMethod(inkImage)
public func SetTileHAlign(tileHAlign: inkEHorizontalAlign) {
    this.tileHAlign = tileHAlign;
}

@addMethod(inkImage)
public func GetTileVAlign() -> inkEVerticalAlign {
    return this.tileVAlign;
}

@addMethod(inkImage)
public func SetTileVAlign(tileVAlign: inkEVerticalAlign) {
    this.tileVAlign = tileVAlign;
}

@addField(inkInputDisplayController)
native let iconRef: inkWidgetRef;

@addField(inkInputDisplayController)
native let nameRef: inkWidgetRef;

@addField(inkInputDisplayController)
native let canvasRef: inkWidgetRef;

@addField(inkInputDisplayController)
native let holdIndicatorContainerRef: inkCompoundRef;

@addField(inkInputDisplayController)
native let gamepadHoldIndicatorLibraryRef: inkWidgetLibraryReference;

@addField(inkInputDisplayController)
native let keyboardHoldIndicatorLibraryRef: inkWidgetLibraryReference;

@addField(inkInputDisplayController)
native let holdIndicationType: inkInputHintHoldIndicationType;

@addField(inkInputDisplayController)
native let inputActionName: CName;

@addField(inkInputDisplayController)
native let fixedIconHeight: Float;

public native class inkKeyInputEvent extends inkInputEvent {
    public native func GetKey() -> EInputKey
    public native func GetAction() -> EInputAction
    public native func GetCharacter() -> String
    public native func IsCharacter() -> Bool
}

public native class inkLayerWrapper {
    public native func GetLayerName() -> CName
    public native func GetVirtualWindow() -> wref<inkVirtualWindow>
    public native func GetGameController() -> wref<inkIGameController>
    public native func GetGameControllers() -> array<wref<inkIGameController>>
}

@addField(inkMask)
native let textureAtlas: ResourceAsyncRef;

@addField(inkMask)
native let texturePart: CName;

@addField(inkMask)
native let dynamicTextureMask: CName;

@addField(inkMask)
native let dataSource: inkMaskDataSource;

@addField(inkMask)
native let invertMask: Bool;

@addField(inkMask)
native let maskTransparency: Float;

@addMethod(inkMask)
public func GetTextureAtlas() -> ResRef {
    return ResourceAsyncRef.GetPath(this.textureAtlas);
}

@addMethod(inkMask)
public func SetTextureAtlas(path: ResRef) {
    ResourceAsyncRef.SetPath(this.textureAtlas, path);
}

@addMethod(inkMask)
public func GetDynamicTexture() -> CName {
    return this.dynamicTextureMask;
}

@addMethod(inkMask)
public func SetDynamicTexture(value: CName) {
    this.dynamicTextureMask = value;
}

@addMethod(inkMask)
public func GetDataSource() -> inkMaskDataSource {
    return this.dataSource;
}

@addMethod(inkMask)
public func SetDataSource(value: inkMaskDataSource) {
    this.dataSource = value;
}

@addMethod(inkMask)
public func IsInverted() -> Bool {
    return this.invertMask;
}

@addMethod(inkMask)
public func SetInverted(value: Bool) {
    this.invertMask = value;
}

@addMethod(inkMask)
public func GetTransparency() -> Float {
    return this.maskTransparency;
}

@addMethod(inkMask)
public func SetTransparency(value: Float) {
    this.maskTransparency = value;
}

enum inkMaskDataSource
{
	TextureAtlas = 0,
	DynamicTexture = 1
}

@addField(inkScrollArea)
native let constrainContentPosition: Bool;

@addField(inkScrollArea)
native let fitToContentDirection: inkFitToContentDirection;

@addMethod(inkScrollArea)
public func GetConstrainContentPosition() -> Bool {
    return this.constrainContentPosition;
}

@addMethod(inkScrollArea)
public func SetConstrainContentPosition(enabled: Bool) {
    this.constrainContentPosition = enabled;
}

@addMethod(inkScrollArea)
public func GetFitToContentDirection() -> inkFitToContentDirection {
    return this.fitToContentDirection;
}

@addMethod(inkScrollArea)
public func SetFitToContentDirection(value: inkFitToContentDirection) {
    this.fitToContentDirection = value;
}

@addField(inkScrollController)
native let ScrollArea: inkScrollAreaRef;

@addField(inkScrollController)
native let VerticalScrollBarRef: inkWidgetRef;

@addField(inkScrollController)
native let navigableCompoundWidget: inkWidgetRef;

@addField(inkScrollController)
native let CompoundWidgetRef: inkCompoundRef;

@addField(inkScrollController)
native let autoHideVertical: Bool;

@addField(inkScrollController)
native let scrollSpeedGamepad: Float;

@addField(inkScrollController)
native let scrollSpeedMouse: Float;

@addField(inkScrollController)
native let direction: inkEScrollDirection;

@addField(inkScrollController)
native let useGlobalInput: Bool;

@addField(inkScrollController)
native let desiredSetupPosition: Float;

@addField(inkScrollController)
native let contentSmallerThanViewport: Bool;

@addField(inkScrollController)
native let position: Float;

@addField(inkScrollController)
native let contentSize: Vector2;

@addField(inkScrollController)
native let viewportSize: Vector2;

@addField(inkScrollController)
native let scrollDelta: Float;

@addMethod(inkScrollController)
public func GetScrollPosition() -> Float {
    return this.position;
}

@addMethod(inkScrollController)
public func GetContentSize() -> Vector2 {
    return this.contentSize;
}

@addMethod(inkScrollController)
public func GetViewportSize() -> Vector2 {
    return this.viewportSize;
}

@addMethod(inkScrollController)
public func SetViewportSize(size: Vector2) {
    this.viewportSize = size;
}

@addMethod(inkScrollController)
public func SetViewportWidth(width: Float) {
    this.viewportSize = new Vector2(width, this.viewportSize.Y);
}

@addMethod(inkScrollController)
public func SetViewportHeight(height: Float) {
    this.viewportSize = new Vector2(this.viewportSize.X, height);
}

@addMethod(inkScrollController)
public func IsEnabled() -> Bool {
    return this.scrollDelta > 0.0;
}

@addMethod(inkScrollController)
public func SetEnabled(enabled: Bool) {
    if enabled {
        if Equals(this.direction, inkEScrollDirection.Horizontal) {
            this.scrollDelta = this.contentSize.X - this.viewportSize.X;
        } else {
            this.scrollDelta = this.contentSize.Y - this.viewportSize.Y;
        }
    } else {
        this.scrollDelta = 0.0;
    }
}

@addField(inkShape)
native let shapeResource: ResourceRef;

@addField(inkShape)
native let shapeName:  CName;

@addField(inkShape)
native let shapeVariant:inkEShapeVariant;

@addField(inkShape)
native let keepInBounds: Bool;

@addField(inkShape)
native let nineSliceScale: inkMargin;

@addField(inkShape)
native let useNineSlice: Bool;

@addField(inkShape)
native let contentHAlign: inkEHorizontalAlign;

@addField(inkShape)
native let contentVAlign: inkEVerticalAlign;

@addField(inkShape)
native let borderColor: HDRColor;

@addField(inkShape)
native let borderOpacity: Float;

@addField(inkShape)
native let fillOpacity: Float;

@addField(inkShape)
native let lineThickness: Float;

@addField(inkShape)
native let endCapStyle: inkEEndCapStyle;

@addField(inkShape)
native let jointStyle: inkEJointStyle;

@addField(inkShape)
native let vertexList: array<Vector2>;

@addMethod(inkShape)
public func GetResource() -> ResRef {
    return ResourceRef.GetPath(this.shapeResource);
}

@addMethod(inkShape)
public func SetResource(path: ResRef) {
    ResourceRef.LoadPath(this.shapeResource, path);
}

@addMethod(inkShape)
public func GetShape() -> CName {
    return this.shapeName;
}

@addMethod(inkShape)
public func SetShape(shape: CName) {
    this.ChangeShape(shape);
}

@addMethod(inkShape)
public func GetVariant() -> inkEShapeVariant {
    return this.shapeVariant;
}

@addMethod(inkShape)
public func SetVariant(variant: inkEShapeVariant) {
    this.shapeVariant = variant;
}

@addMethod(inkShape)
public func UsesNineSliceScale() -> Bool {
    return this.useNineSlice;
}

@addMethod(inkShape)
public func SetNineSliceScale(enable: Bool) {
    this.useNineSlice = enable;
}

@addMethod(inkShape)
public func GetNineSliceGrid() -> inkMargin {
    return this.nineSliceScale;
}

@addMethod(inkShape)
public func SetNineSliceGrid(grid: inkMargin) {
    this.nineSliceScale = grid;
}


@addMethod(inkShape)
public func GetKeepInBounds() -> Bool {
    return this.keepInBounds;
}

@addMethod(inkShape)
public func GetContentHAlign() -> inkEHorizontalAlign {
    return this.contentHAlign;
}

@addMethod(inkShape)
public func GetContentVAlign() -> inkEVerticalAlign {
    return this.contentVAlign;
}

@addMethod(inkShape)
public func GetBorderColor() -> HDRColor {
    return this.borderColor;
}

@addMethod(inkShape)
public func GetBorderOpacity() -> Float {
    return this.borderOpacity;
}

@addMethod(inkShape)
public func GetFillOpacity() -> Float {
    return this.fillOpacity;
}

@addMethod(inkShape)
public func GetLineThickness() -> Float {
    return this.lineThickness;
}

@addMethod(inkShape)
public func GetEndCapStyle() -> inkEEndCapStyle {
    return this.endCapStyle;
}

@addMethod(inkShape)
public func GetJointStyle() -> inkEJointStyle {
    return this.jointStyle;
}

@addMethod(inkShape)
public func GetVertexList() -> array<Vector2> {
    return this.vertexList;
}

@addMethod(inkShape)
public func SetKeepInBounds(keepInBounds: Bool) {
    this.keepInBounds = keepInBounds;
}

@addMethod(inkShape)
public func SetContentHAlign(contentHAlign: inkEHorizontalAlign) {
    this.contentHAlign = contentHAlign;
}

@addMethod(inkShape)
public func SetContentVAlign(contentVAlign: inkEVerticalAlign) {
    this.contentVAlign = contentVAlign;
}

@addMethod(inkShape)
public func SetBorderColor(borderColor: HDRColor) {
    this.borderColor = borderColor;
}

@addMethod(inkShape)
public func SetBorderOpacity(borderOpacity: Float) {
    this.borderOpacity = borderOpacity;
}

@addMethod(inkShape)
public func SetFillOpacity(fillOpacity: Float) {
    this.fillOpacity = fillOpacity;
}

@addMethod(inkShape)
public func SetLineThickness(lineThickness: Float) {
    this.lineThickness = lineThickness;
}

@addMethod(inkShape)
public func SetEndCapStyle(endCapStyle: inkEEndCapStyle) {
    this.endCapStyle = endCapStyle;
}

@addMethod(inkShape)
public func SetJointStyle(jointStyle: inkEJointStyle) {
    this.jointStyle = jointStyle;
}

@addMethod(inkShape)
public func SetVertexList(vertexList: array<Vector2>) {
    this.vertexList = vertexList;
}

@addField(inkText)
native let contentHAlign: inkEHorizontalAlign;

@addField(inkText)
native let contentVAlign: inkEVerticalAlign;

@addField(inkText)
native let justification: textJustificationType;

@addField(inkText)
native let textOverflowPolicy: textOverflowPolicy;

@addField(inkText)
native let wrappingInfo: textWrappingInfo;

@addField(inkText)
native let lineHeightPercentage: Float;

@addField(inkText)
native let lockFontInGame: Bool;

@addMethod(inkText)
public func GetContentHAlign() -> inkEHorizontalAlign {
    return this.contentHAlign;
}

@addMethod(inkText)
public func SetContentHAlign(contentHAlign: inkEHorizontalAlign) {
    this.contentHAlign = contentHAlign;
}

@addMethod(inkText)
public func GetContentVAlign() -> inkEVerticalAlign {
    return this.contentVAlign;
}

@addMethod(inkText)
public func SetContentVAlign(contentVAlign: inkEVerticalAlign) {
    this.contentVAlign = contentVAlign;
}

@addMethod(inkText)
public func GetJustificationType() -> textJustificationType {
    return this.justification;
}

@addMethod(inkText)
public func SetJustificationType(justificationType: textJustificationType) {
    this.justification = justificationType;
}

@addMethod(inkText)
public func GetOverflowPolicy() -> textOverflowPolicy {
    return this.textOverflowPolicy;
}

@addMethod(inkText)
public func SetOverflowPolicy(overflowPolicy: textOverflowPolicy) {
    this.textOverflowPolicy = overflowPolicy;
}

@addMethod(inkText)
public func SetWrapping(enabled: Bool, opt width: Float, opt policy: textWrappingPolicy) {
    this.wrappingInfo.autoWrappingEnabled = enabled;
    this.wrappingInfo.wrappingAtPosition = width;
    this.wrappingInfo.wrappingPolicy = policy;
}

@addMethod(inkText)
public func GetWrapping() -> textWrappingInfo {
    return this.wrappingInfo;
}

@addMethod(inkText)
public func GetLineHeight() -> Float {
    return this.lineHeightPercentage;
}

@addMethod(inkText)
public func SetLineHeight(lineHeight: Float) {
    this.lineHeightPercentage = lineHeight;
}

@addMethod(inkText)
public func GetLockFontInGame() -> Bool {
    return this.lockFontInGame;
}

@addMethod(inkText)
public func SetLockFontInGame(lockFont: Bool) {
    this.lockFontInGame = lockFont;
}

@addField(inkVirtualListController)
native let itemTemplates: array<inkWidgetLibraryReference>;

@addField(inkVirtualListController)
native let cycleNavigation: Bool;

@addField(inkVirtualUniformListController)
native let itemTemplate: inkWidgetLibraryReference;

@addField(inkWidget)
native let parentWidget: wref<inkWidget>;

@addField(inkWidget)
native let logicController: ref<inkLogicController>;

@addField(inkWidget)
native let secondaryControllers: array<ref<inkLogicController>>;

@addField(inkWidget)
native let userData: array<ref<inkUserData>>;

@addField(inkWidget)
native let canSupportFocus: Bool;

@addMethod(inkWidget)
public func GetParentWidget() -> wref<inkWidget> {
    return this.parentWidget;
}

@addMethod(inkWidget)
public func SetUserData(userData: ref<inkUserData>) {
    ArrayPush(this.userData, userData);
}

@addMethod(inkWidget)
public func CanSupportFocus() -> Bool {
    return this.canSupportFocus;
}

@addMethod(inkWidget)
public func SetSupportFocus(enabled: Bool) {
    this.canSupportFocus = enabled;
}

@addMethod(inkWidget)
public native func AttachController(controller: ref<inkLogicController>, opt secondary: Bool);

@addMethod(inkWidgetLibraryReference)
public static func Create(path: ResRef, item: CName) -> inkWidgetLibraryReference {
    return new inkWidgetLibraryReference(inkWidgetLibraryResource.Create(path), item);
}

@addMethod(inkWidgetLibraryResource)
public static native func SetPath(self: script_ref<inkWidgetLibraryResource>, path: ResRef);

@addMethod(inkWidgetLibraryResource)
public static func Create(path: ResRef) -> inkWidgetLibraryResource {
    let ref = new inkWidgetLibraryResource();
    inkWidgetLibraryResource.SetPath(ref, path);
    return ref;
}

@addMethod(inkWidgetRef)
public static native func Set(self: script_ref<inkWidgetRef>, widget: ref<inkWidget>);

@addMethod(inkWidgetRef)
public static func Create(widget: ref<inkWidget>) -> inkWidgetRef {
    let ref = new inkWidgetRef();
    inkWidgetRef.Set(ref, widget);
    return ref;
}

@addMethod(inkBorderRef)
public static func Create(widget: ref<inkBorder>) -> inkBorderRef {
    let ref = new inkBorderRef();
    inkWidgetRef.Set(ref, widget);
    return ref;
}

@addMethod(inkCacheRef)
public static func Create(widget: ref<inkCacheWidget>) -> inkCacheRef {
    let ref = new inkCacheRef();
    inkWidgetRef.Set(ref, widget);
    return ref;
}

@addMethod(inkCanvasRef)
public static func Create(widget: ref<inkCanvas>) -> inkCanvasRef {
    let ref = new inkCanvasRef();
    inkWidgetRef.Set(ref, widget);
    return ref;
}

@addMethod(inkCircleRef)
public static func Create(widget: ref<inkCircle>) -> inkCircleRef {
    let ref = new inkCircleRef();
    inkWidgetRef.Set(ref, widget);
    return ref;
}

@addMethod(inkFlexRef)
public static func Create(widget: ref<inkFlex>) -> inkFlexRef {
    let ref = new inkFlexRef();
    inkWidgetRef.Set(ref, widget);
    return ref;
}

@addMethod(inkGridRef)
public static func Create(widget: ref<inkGrid>) -> inkGridRef {
    let ref = new inkGridRef();
    inkWidgetRef.Set(ref, widget);
    return ref;
}

@addMethod(inkHorizontalPanelRef)
public static func Create(widget: ref<inkHorizontalPanel>) -> inkHorizontalPanelRef {
    let ref = new inkHorizontalPanelRef();
    inkWidgetRef.Set(ref, widget);
    return ref;
}

@addMethod(inkImageRef)
public static func Create(widget: ref<inkImage>) -> inkImageRef {
    let ref = new inkImageRef();
    inkWidgetRef.Set(ref, widget);
    return ref;
}

@addMethod(inkMaskRef)
public static func Create(widget: ref<inkMask>) -> inkMaskRef {
    let ref = new inkMaskRef();
    inkWidgetRef.Set(ref, widget);
    return ref;
}

@addMethod(inkRectangleRef)
public static func Create(widget: ref<inkRectangle>) -> inkRectangleRef {
    let ref = new inkRectangleRef();
    inkWidgetRef.Set(ref, widget);
    return ref;
}

@addMethod(inkScrollAreaRef)
public static func Create(widget: ref<inkScrollArea>) -> inkScrollAreaRef {
    let ref = new inkScrollAreaRef();
    inkWidgetRef.Set(ref, widget);
    return ref;
}

@addMethod(inkShapeRef)
public static func Create(widget: ref<inkShape>) -> inkShapeRef {
    let ref = new inkShapeRef();
    inkWidgetRef.Set(ref, widget);
    return ref;
}

@addMethod(inkTextRef)
public static func Create(widget: ref<inkText>) -> inkTextRef {
    let ref = new inkTextRef();
    inkWidgetRef.Set(ref, widget);
    return ref;
}

@addMethod(inkUniformGridRef)
public static func Create(widget: ref<inkUniformGrid>) -> inkUniformGridRef {
    let ref = new inkUniformGridRef();
    inkWidgetRef.Set(ref, widget);
    return ref;
}

@addMethod(inkVerticalPanelRef)
public static func Create(widget: ref<inkVerticalPanel>) -> inkVerticalPanelRef {
    let ref = new inkVerticalPanelRef();
    inkWidgetRef.Set(ref, widget);
    return ref;
}

@addMethod(inkVideoRef)
public static func Create(widget: ref<inkVideo>) -> inkVideoRef {
    let ref = new inkVideoRef();
    inkWidgetRef.Set(ref, widget);
    return ref;
}

@addMethod(inkVirtualCompoundRef)
public static func Create(widget: ref<inkVirtualCompoundWidget>) -> inkVirtualCompoundRef {
    let ref = new inkVirtualCompoundRef();
    inkWidgetRef.Set(ref, widget);
    return ref;
}

public native class inkWindow extends inkCanvas {}

public native class inkVirtualWindow extends inkWindow {}

enum textJustificationType
{
    Left = 0,
    Center = 1,
    Right = 2
}

enum textOverflowPolicy
{
    None = 0,
    DotsEnd = 1,
    DotsEndLastLine = 2,
    AutoScroll = 3,
    PingPongScroll = 4,
    AdjustToSize = 5
}

public native struct textWrappingInfo {
    public native let autoWrappingEnabled: Bool;
    public native let wrappingAtPosition: Float;
    public native let wrappingPolicy: textWrappingPolicy;
}

enum textWrappingPolicy
{
    Default = 0,
    PerCharacter = 1
}

public native struct gameuiPuppetPreviewCameraController {
    public native let cameraSetup: array<gameuiPuppetPreviewCameraSetup>;
    public native let activeSetup: Uint32;
    public native let transitionDelay: Float;
}

public native struct gameuiPuppetPreviewCameraSetup {
    public native let slotName: CName;
    public native let cameraZoom: Float;
    public native let interpolationTime: Float;
}

@addField(inkPuppetPreviewGameController)
public native let cameraController: gameuiPuppetPreviewCameraController;

public static native func BitTest8(value: Uint8, n: Int32) -> Bool
public static native func BitSet8(value: Uint8, n: Int32, state: Bool) -> Uint8
public static native func BitShiftL8(value: Uint8, n: Int32) -> Uint8
public static native func BitShiftR8(value: Uint8, n: Int32) -> Uint8

public static native func BitTest16(value: Uint16, n: Int32) -> Bool
public static native func BitSet16(value: Uint16, n: Int32, state: Bool) -> Uint16
public static native func BitShiftL16(value: Uint16, n: Int32) -> Uint16
public static native func BitShiftR16(value: Uint16, n: Int32) -> Uint16

public static native func BitTest32(value: Uint32, n: Int32) -> Bool
public static native func BitSet32(value: Uint32, n: Int32, state: Bool) -> Uint32
public static native func BitShiftL32(value: Uint32, n: Int32) -> Uint32
public static native func BitShiftR32(value: Uint32, n: Int32) -> Uint32

public static native func BitTest64(value: Uint64, n: Int32) -> Bool
public static native func BitSet64(value: Uint64, n: Int32, state: Bool) -> Uint64
public static native func BitShiftL64(value: Uint64, n: Int32) -> Uint64
public static native func BitShiftR64(value: Uint64, n: Int32) -> Uint64

public static native func NameToHash(name: CName) -> Uint64

public static native func CreateCRUID(value: Uint64) -> CRUID
public static native func CRUIDToHash(value: CRUID) -> Uint64

public static native func FNV1a64(data: script_ref<String>, opt seed: Uint64) -> Uint64
public static native func FNV1a32(data: script_ref<String>, opt seed: Uint32) -> Uint32
public static native func Murmur3(data: script_ref<String>, opt seed: Uint32) -> Uint32

public static native func CreateNodeRef(ref: script_ref<String>) -> NodeRef
public static native func NodeRefToHash(ref: NodeRef) -> Uint64

public static native func UTF8StrLen(str: script_ref<String>) -> Int32

public static native func UTF8StrLeft(str: script_ref<String>, length: Int32) -> String
public static native func UTF8StrRight(str: script_ref<String>, length: Int32) -> String
public static native func UTF8StrMid(str: script_ref<String>, offset: Int32, length: Int32) -> String

public static native func UTF8StrLower(str: script_ref<String>) -> String
public static native func UTF8StrUpper(str: script_ref<String>) -> String

enum DynamicEntityEventType
{
    Created = 0,
    Deleted = 1,
    Spawned = 2,
    Despawned = 3,
    Dead = 4,
}

public native class DynamicEntityEvent {
    public native func GetEventType() -> DynamicEntityEventType
    public native func GetEntityID() -> EntityID
    public native func GetEntityTag() -> CName
}

public native class DynamicEntitySpec {
    public native let recordID: TweakDBID;
    public native let templatePath: ResRef;

    public native let appearanceName: CName;

    public native let position: Vector4;
    public native let orientation: Quaternion;

    public native let persistState: Bool;

    public native let persistSpawn: Bool;

    public native let alwaysSpawned: Bool;

    public native let spawnInView: Bool;

    public native let active: Bool;

    public native let tags: array<CName>;

    public native func IsValid() -> Bool
}

public native class DynamicEntitySystem extends IGameSystem {
    public native func IsReady() -> Bool
    public native func IsRestored() -> Bool

    public native func CreateEntity(spec: ref<DynamicEntitySpec>) -> EntityID
    public native func DeleteEntity(id: EntityID) -> Bool
    public native func EnableEntity(id: EntityID) -> Bool
    public native func DisableEntity(id: EntityID) -> Bool

    public native func IsManaged(id: EntityID) -> Bool
    public native func IsTagged(id: EntityID, tag: CName) -> Bool
    public native func IsSpawned(id: EntityID) -> Bool
    public native func IsSpawning(id: EntityID) -> Bool
    public native func GetEntity(id: EntityID) -> ref<Entity>
    public native func GetTags(id: EntityID) -> array<CName>
    public native func AssignTag(id: EntityID, tag: CName)
    public native func UnassignTag(id: EntityID, tag: CName)

    public native func IsPopulated(tag: CName) -> Bool
    public native func GetTagged(tag: CName) -> array<ref<Entity>>
    public native func GetTaggedID(tag: CName) -> EntityID
    public native func GetTaggedIDs(tag: CName) -> array<EntityID>
    public native func DeleteTagged(tag: CName)
    public native func EnableTagged(tag: CName)
    public native func DisableTagged(tag: CName)

    public native func RegisterListener(tag: CName, target: ref<IScriptable>, function: CName)
    public native func UnregisterListener(tag: CName, target: ref<IScriptable>, function: CName)
    public native func UnregisterListeners(tag: CName)
}

@addMethod(GameInstance)
public static native func GetDynamicEntitySystem() -> ref<DynamicEntitySystem>

@addMethod(VehicleSystem)
public native func ToggleGarageVehicle(garageID: GarageVehicleID, enable: Bool) -> Bool

@addMethod(VehicleSystem)
public func EnablePlayerVehicleID(vehicleID: TweakDBID, enable: Bool, opt despawnIfDisabling: Bool) -> Bool {
    let playerVehicles = TweakDBInterface.GetForeignKeyArray(t"Vehicle.vehicle_list.list");

    if !ArrayContains(playerVehicles, vehicleID) {
        return false;
    }

    let garageID: GarageVehicleID;
    garageID.recordID = vehicleID;

    let success = this.ToggleGarageVehicle(garageID, enable);

    if success && !enable && despawnIfDisabling {
        this.DespawnPlayerVehicle(garageID);
    }

    return success;
}
