
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/coffgirl.zip" ),
		Asset( "ANIM", "anim/coffgirl_hungry.zip" ),
		Asset( "ANIM", "anim/coffgirl_starving.zip" ),
}
local prefabs = {}

--fire
local function sanityfn(inst)
	local x,y,z = inst.Transform:GetWorldPosition()	
	local delta = 0
	local max_rad = 10
	local ents = TheSim:FindEntities(x,y,z, max_rad, {"fire"})
    for k,v in pairs(ents) do 
    	if v.components.burnable and v.components.burnable.burning then
    		local sz = -TUNING.SANITYAURA_TINY
    		local rad = v.components.burnable:GetLargestLightRadius() or 1
    		sz = sz * ( math.min(max_rad, rad) / max_rad )
			local distsq = inst:GetDistanceSqToInst(v)
			delta = delta + sz/math.max(1, distsq)
    	end
    end
    
    return delta
end

--rain
local function doraincheck(inst, dt)

    if GetSeasonManager() and GetSeasonManager():IsRaining() then
		inst.components.sanity.dapperness = TUNING.DAPPERNESS_MED*2* GetSeasonManager():GetPrecipitationRate()
    else 
		inst.components.sanity.dapperness = 0
	end
	
end
	

local fn = function(inst)
	
	-- choose which sounds this character will play
	inst.soundsname = "willow"

	-- a minimap icon must be specified
	-- inst.MiniMapEntity:SetIcon( "woodie.png" )
	inst.entity:AddMiniMapEntity()
    inst.MiniMapEntity:SetIcon("coffcon.tex")

	-- todo: Add an example special power here.
	inst.components.health:SetMaxHealth(150)
	inst.components.hunger:SetMax(300)
 	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 2)
	inst.components.sanity.custom_rate_fn = sanityfn
	inst:DoPeriodicTask(1/10, function() doraincheck(inst, 1/10) end)
	inst:DoPeriodicTask(1/10, function()     
        if inst.components.hunger.current > 100 then
            inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.5)
            inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.5)
			inst.AnimState:SetBuild("coffgirl")
        elseif inst.components.hunger.current > 30 then
            inst.components.locomotor.walkspeed = 4.5
            inst.components.locomotor.runspeed = 5.5
			inst.AnimState:SetBuild("coffgirl_hungry")
	else
	    inst.components.locomotor.walkspeed = 3
            inst.components.locomotor.runspeed = 4
			inst.components.eater.ignoresspoilage = true
			inst.components.eater.strongstomach = true
			inst.AnimState:SetBuild("coffgirl_starving")
		end
	end)
end



-- strings! Any "WOD" below would have to be replaced by the prefab name of your character.

-- First up, the character select screen lines 
-- note: these are lower-case character name
STRINGS.CHARACTER_TITLES.coffgirl = "The Hungry Hibiscus"
STRINGS.CHARACTER_NAMES.coffgirl = "Coffgirl"
STRINGS.CHARACTER_DESCRIPTIONS.coffgirl = "* She's looking for coffee."
STRINGS.CHARACTER_QUOTES.coffgirl = "\"COFFEE!!.\""

-- You can also add any kind of custom dialogue that you would like. Don't forget to make
-- categores that don't exist yet using = {}
-- note: these are UPPER-CASE charcacter name
STRINGS.CHARACTERS.COFFGIRL = {}
STRINGS.CHARACTERS.COFFGIRL.DESCRIBE = {}
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_ADVENTUREFAIL = "Dammit...."
STRINGS.CHARACTERS.COFFGIRL.DESCRIBE.EVERGREEN = "Why you no coffee?!"
STRINGS.CHARACTERS.COFFGIRL.ACTIONFAIL_GENERIC = "Nope"
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_ADVENTUREFAIL = "Oh well, No Coffee in there."
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_BOOMERANG = "HURT!!"
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_CHARLIE = "WHO?!"
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_CHARLIE_ATTACK = "NO!! NOT MY COFFEE!!"
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_COLD = "I need warm coffee."
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_CRAFTING_FAIL = "I don't have enough stuffs."
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_DUSK = "No, not again..."
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_EAT =
	{
		GENERIC = "This is goooood!",
		PAINFUL = "THIS IS NOT FOOD!",
		SPOILED = "It's ROTTEN!",
		STALE = "It tastes strange.",
	}
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_ENTER_DARK = "I can't see any Coffee!"
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_ENTER_LIGHT = "My eyes are blind, ...NOT!!!"
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_HOUNDS = "I heard something fluffy."
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_DEERCLOPS = "WHAT WAS THAT NOISE?!"
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_HUNGRY = "FOOD FOOD FOOD!!"
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_HUNT_BEAST_NEARBY = "There you are!"
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_HUNT_LOST_TRAIL = "Yes!"
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_INV_FULL = "It's full!"
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_PECKED = "OUCH!"
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_TORCH_OUT = "My Fire!"
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_HOLE = "I hate that, seriously."
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_NODANGERSLEEP = "It's not a good idea to sleep."
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_NODAYSLEEP = "Seriously?"
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_NODAYSLEEP_CAVE = "No no no, Why?"
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_NOHUNGERSLEEP = "No way! I'm starving, you see?"
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_FREEDOM = "FREDOM!!!"
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_MOSQUITOS = "I hate YOU!"
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_KNOCKEDOUT = "Marisa....!!"
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_NO_TRAP = "Hehehehehehe..."
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_QUAKE = "Uh-oh..."
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_THORNS = "Yike!?"
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_TRAP_WENT_OFF = "Meh"
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_UNIMPLEMENTED = "URGH!! NO NO!"
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_ACCOMPLISHMENT = "..."
STRINGS.CHARACTERS.COFFGIRL.ANNOUNCE_ACCOMPLISHMENT_DONE = "..."
STRINGS.CHARACTERS.COFFGIRL.BATTLECRY =
	{
		GENERIC = "DIE!",
		PIG = "I'm hungry, go die!",
		PREY = "Die for me!",
		SPIDER = "Die! I know you're cute but go die!",
		SPIDER_WARRIOR = "Stop Jumping!",
	}

STRINGS.CHARACTERS.COFFGIRL.COMBAT_QUIT =
	{
		GENERIC = "RUN!",
		PIG = "Sorry, I didn't meant to..",
		PREY = "I lost my food.",
		SPIDER = "Do NOT follow me now Fluffy.",
		SPIDER_WARRIOR = "Don't hurt me!",
	}
STRINGS.CHARACTERS.COFFGIRL.DESCRIBE =
	{
		WORMLIGHT = "Looks fat.",
		WORM =
		{
		    PLANT = "Whoa, what are you?",
		    DIRT = "It's moving!",
		    WORM = "SO CUTE!",
		},
		EEL = "Looks yummy.",
		EEL_COOKED = "I wanna eat it right now!",
		UNAGI = "Awesome meal!",
		EYETURRET = "Uh... It's staring on me.",
		EYETURRET_ITEM = "Eye!",
		MINOTAURHORN = "Ohhhh",
		MINOTAURCHEST = "Woww!! This must be something awesome inside!",
		THULECITE_PIECES = "Need to combind.",
		POND_ALGAE = "Wow food source!",
		GREENSTAFF = "I love green.",
		POTTEDFERN = "Hello little friend.",
		THULECITE = "What a nice stone.",
		ARMORRUINS = "This is odd.",
		RUINS_BAT = "Hit in the head!",
		RUINSHAT = "looks expensive.",
		NIGHTMARE_TIMEPIECE =
		{
		CALM = "Phew, everything is ok now.",
		WARN = "Something is gonna happen!",
		WAXING = "Uh-oh...!!",
		STEADY = "So long...",
		WANING = "Is it gone?!",
		DAWN = "No more...",
		NOMAGIC = "Seems fine here.",
		},
		BISHOP_NIGHTMARE = "Go away!",
		ROOK_NIGHTMARE = "Don't come here!",
		KNIGHT_NIGHTMARE = "YOU HORSE!",
		MINOTAUR = "Whoa...what?",
		SPIDER_DROPPER = "White Fluffy thing",
		NIGHTMARELIGHT = "What is this light?",
		GREENGEM = "Green gem! I love it.",
		RELIC = "Looks old.",
		RUINS_RUBBLE = "I have to fix it.",
		MULTITOOL_AXE_PICKAXE = "THIS IS AWESOME!",
		ORANGESTAFF = "Ohhh no more walking... YES!",
		YELLOWAMULET = "So warm...",
		GREENAMULET = "Hehehehe I love this one.",
		SLURPERPELT = "Fluffy thing from Slurper",
		SLURPER = "YOU'RE SO CUTE!",
		ARMORSLURPER = "Something cute to wear.",
		ORANGEAMULET = "Nom Nom Nom",
		YELLOWSTAFF = "Light every where!",
		YELLOWGEM = "Cool, Yellow gem.",
		ORANGEGEM = "Tasty color",
		TELEBASE = 
		{
			VALID = "Ready",
			GEMS = "Need some more gems",
		},
		GEMSOCKET = 
		{
			VALID = "Good",
			GEMS = "Needs gem in there.",
		},
		STAFFLIGHT = "Oh it's quite hot.",
		RESEARCHLAB4 = "This is something...",
	ANCIENT_ALTAR = "Beautiful structure",

        ANCIENT_ALTAR_BROKEN = "It's broken.",

        ANCIENT_STATUE = "I wonder, who built it.",
		LICHEN = "Some kind of friend...",
		CUTLICHEN = "Can I eat it?",
		COMPASS =
		{
			GENERIC="Hmmm...",
			N = "North",
			S = "South",
			E = "East",
			W = "West",
			NE = "Northeast",
			SE = "Southeast",
			NW = "Northwest",
			SW = "Southwest",
		},

		CAVE_BANANA = "Banana!",
		CAVE_BANANA_COOKED = "Yummy",
		CAVE_BANANA_TREE = "I love this tree.",
		ROCKY = "It's not fluffy.",
		MONKEY = "No, don't steal my stuffs!",
		MONKEYBARREL = "Wow, barrel monkey...",
		BLUEAMULET = "I feel calm looking at it.",
		PURPLEAMULET = "This is scary.",
		HOUNDSTOOTH="I don't wanna get near to that.",
		ARMORSNURTLESHELL="Nice protection!",
		BAT="Why are you flying around me?",
		BATBAT = "My winged friend's death was not in vain.",
		BATWING="I'm so sorry battie.",
		BATWING_COOKED="Look weird.. delicious weird.",
		BEDROLL_FURRY="FLUFFY!",
		BUNNYMAN="How cute!",
		FLOWER_CAVE="Hello, friend.",
		FLOWER_CAVE_DOUBLE="Hello, friend.",
		FLOWER_CAVE_TRIPLE="Hello, friend.",
		GUANO="Uh...",
		LANTERN="Light plz!",
		LIGHTBULB="Can I eat this?",
		MANRABBIT_TAIL="So fluffy",
		MUSHTREE_TALL  ="BIG MUSHROOM!",
		MUSHTREE_MEDIUM="Beautiful",
		MUSHTREE_SMALL ="Mushroom!",
		RABBITHOUSE="Say, I wanna eat this house.",
		SLURTLE="Looks not so tasty.",
		SLURTLE_SHELLPIECES="Then?",
		SLURTLEHAT="This is heavy.",
		SLURTLEHOLE="How scary.",
		SLURTLESLIME="Looks like it can go boom.",
		SNURTLE="So slow",
		SPIDER_HIDER="Stop hiding!",
		SPIDER_SPITTER="Stop Spitting!",
		SPIDERHOLE="Stinky",
		STALAGMITE="Rock just rock",
		STALAGMITE_FULL="Let's break it?",
		STALAGMITE_LOW="Break already!",
		STALAGMITE_MED="BREAK!",
		STALAGMITE_TALL="Rock just rock",
		STALAGMITE_TALL_FULL="Let's break it?",
		STALAGMITE_TALL_LOW="Break already!",
		STALAGMITE_TALL_MED="BREAK!",
		TURF_CARPETFLOOR = "Yet another ground type.",
		TURF_CHECKERFLOOR = "Yet another ground type.",
		TURF_DIRT = "Oh yeah..",
		TURF_FOREST = "Oh yeah..",
		TURF_GRASS = "Oh yeah..",
		TURF_MARSH = "Oh yeah..",
		TURF_ROAD = "Oh yeah..",
		TURF_ROCKY = "Oh yeah..",
		TURF_SAVANNA = "Oh yeah..",
		TURF_WOODFLOOR = "Oh yeah..",
		TURF_CAVE="Oh yeah..",
		TURF_FUNGUS="Oh yeah..",
		TURF_MUD="Oh yeah..",
		TURF_SINKHOLE="Oh yeah..",
		TURF_UNDERROCK="Oh yeah..",
		POWCAKE = "Ew...",		
		CAVE_ENTRANCE = 
		{
			GENERIC="This is suspicious.",
			OPEN = "Shall I go?",
		},
		CAVE_EXIT = "Ahh fresh air",
		BOOMERANG = "Boomerang yeah!",
		MAXWELLPHONOGRAPH = "Ah well...",
		ABIGAIL = "WHAT?!",
		PIGGUARD = "You look not so friendly.",
		ADVENTURE_PORTAL = "I wonder if I can find coffee in there.",
		AMULET = "Looks useless but not.",
		ANIMAL_TRACK = "I smell food...",
		ARMORGRASS = "Better than nothing.",
		ARMORMARBLE = "Too heavy but good.",
		ARMORWOOD = "Light and strong!",
		ARMOR_SANITY = "I'm going crazy while wearing it.",
		ASH =
		{
			GENERIC = "Just some ash...",
			REMAINS_EYE_BONE = "awww...",
			REMAINS_THINGIE = "aww....",
		},
		AXE = "Chop Chop!",
		BACONEGGS = "Smell nice.",
		BABYBEEFALO = "It will grow big soon.",
		BACKPACK = "Put stuffs in, YAY!",
		BANDAGE = "Looks sweet.",
		BACONEGGS = "I wanna eat it.",
		BASALT = "Yeah",
		BEARDHAIR = "Something hairy but not fluffy.",
		BEDROLL_STRAW = "This is handy enough.",
		BEE =
		{
			GENERIC = "What a nice honey you have there.",
			HELD = "GIMME SOME!",
		},
		BEEBOX =
		{
			GENERIC = "Yes! make me food!",
			READY = "I think it's ready.",
		},
		BEEFALO =
		{
			FOLLOWER = "Oh they're following me.",
			GENERIC = "Nice big and tasty beefalo.",
			NAKED = "I'm sorry.",
			SLEEPING = "I should shave its hair.",
		},
		BEEFALOHAT = "This is a nice hat in winter.",
		BEEFALOWOOL = "A bit stinky, oh well.",
		BEEHIVE = "What a nice honey you have there.",
		BERRIES = "Sweet",
		BERRIES_COOKED = "This is good too.",
		BERRYBUSH =
		{
			BARREN = "It needs something.",
			GENERIC = "That's really beautiful.",
			PICKED = "Come on! more food!",
		},
		BIRDCAGE =
		{
			GENERIC = "I need to add something in.",
			OCCUPIED = "Yeah my pet.",
			SLEEPING = "You look comfort that it looks.",
		},
		BIRDTRAP = "Hahaha... for flying food.",
		BIRD_EGG = "I love eggs.",
		BIRD_EGG_COOKED = "Cooked eggs are good.",
		BISHOP = "I hate that thing.",
		BLOWDART_FIRE = "Light enemy on fire!",
		BLUEGEM = "Blue gem",
		BLUEPRINT = "Nice blueprint",
		BLUE_CAP = "Cute blue mushroom",
		BLUE_CAP_COOKED = "Now cooked",
		BLUE_MUSHROOM =
		{
			GENERIC = "I wanna pick that.",
			INGROUND = "Aw... get up!",
			PICKED = "Come back soon.",
		},
		BOARDS = "It must be a really good fuel.",
		BONESTEW = "This can fill my big stomuch!",
		BUGNET = "Let's catch bugs!",
		BUSHHAT = "I'm not nature enough?",
		BUTTER = "This smell nice!",
		BUTTERFLY =
		{
			GENERIC = "I know something that I can eat you.",
			HELD = "Eat or plant",
		},
		BUTTERFLYMUFFIN = "Yes let's eat butterfly thing.",
		BUTTERFLYWINGS = "This is weird but dilicious.",
		CAMPFIRE =
		{
			EMBERS = "Yes, this is called FIRE.",
			GENERIC = "Light and hot",
			HIGH = "So warm..so warm.",
			LOW = "This is bad.",
			NORMAL = "Nice light",
			OUT = "Aww...",
		},
		CANE = "Run faster yes!",
		CARROT = "I would like to eat bunny with carrot.",
		CARROT_COOKED = "Smell good",
		CARROT_PLANTED = "That's carrot.",
		CAVE_FERN = "Yeah more plant in cave!",
		CHARCOAL = "FOR FUEL!",
	CHESSJUNK1 = "Broken pieces",
        CHESSJUNK2 = "Broken pieces...",
        CHESSJUNK3 = "Broken pieces......",
		CHESTER = "CUTE LITTLE THING!",
		CHESTER_EYEBONE =
		{
			GENERIC = "Is this your eye, Chester?",
			WAITING = "Poor thing...",
		},
		COOKEDMANDRAKE = "Grilled little mandrake",
		COOKEDMEAT = "Steak time",
		COOKEDMONSTERMEAT = "Seriously...This can not be eaten.",
		COOKEDSMALLMEAT = "This is not enough.",
		COOKPOT =
		{
			COOKING_LONG = "GAH!! QUICKLY!!!",
			COOKING_SHORT = "Waiting waiting",
			DONE = "DONE!",
			EMPTY = "I need to cook something.",
		},
		CROW =
		{
			GENERIC = "Aya, is that you?",
			HELD = "Shall I eat you?",
		},
		CORN = "Corn for life!",
		CORN_COOKED = "Popcorn!",
		CORN_SEEDS = "Corn seed",
		CUTGRASS = "You should be coffee.",
		CUTREEDS = "Why you're not coffee.",
		CUTSTONE = "Hm, nice shape",
		DEERCLOPS = "WHOA! HUGE MEAT!!",
		DEERCLOPS_EYEBALL = "Can I eat this thing anyway?",
		DEVTOOL = "....",
		DIRTPILE = "I follow this for food.",
		DIVININGROD =
		{
			COLD = "Nope",
			GENERIC = "Oh, I knew it!",
			HOT = "This way!",
			WARM = "Almost!",
			WARMER = "IT'S NEAR!",
		},
		DIVININGRODBASE =
		{
			GENERIC = "What should I do now?",
			READY = "I have an idea.",
			UNLOCKED = "Cool!",
		},
		DIVININGRODSTART = "I have to take that with me.",
		EARMUFFHAT = "Warm little rabbits for my ears",
		DRAGONFRUIT = "This is really dilicious.",
		DRAGONFRUIT_COOKED = "Awesome!",
		DRAGONPIE = "For my belly for my hunger",
		DRUMSTICK = "YES LEG!",
		DRUMSTICK_COOKED = "Yummy but not enough",
		DURIAN = "Ah...smelly but yummy",
		DURIAN_COOKED = "Yeahhh...that smell",
		DURIAN_SEEDS = "Durian seed",
		DUG_BERRYBUSH = "I'll take you to new home.",
		DUG_GRASS = "I'll take you to new home.",
		DUG_MARSH_BUSH = "I'll take you to new home.",
		DUG_SAPLING = "I'll take you to new home.",	
		EGGPLANT = "This is my favorite.",
		EGGPLANT_COOKED = "Cooked one is more awesome.",
		EGGPLANT_SEEDS = "Eggplant seed",
		EVERGREEN =
		{
			BURNING = "Sorry, my friend...I have to...",
			BURNT = "Ow...that must be hurt.",
			CHOPPED = "Atleast, that's not me. *glup*",
			GENERIC = "Why you no coffee?!",
		},
		EVERGREEN_SPARSE =
		{
			BURNING = "Sorry, my friend...I have to...",
			BURNT = "Ow...that must be hurt.",
			CHOPPED = "Atleast, that's not me. *glup*",
			GENERIC = "Why you no coffee?!",
		},
		EYEPLANT = "Oh oh...scary",
		FARMPLOT =
		{
			GENERIC = "Nice little home for plant",
			GROWING = "Grow now grow",
			NEEDSFERTILIZER = "It wants some poo poo",
		},
		FEATHERHAT = "This looks funny.",
		FEM_PUPPET = "What?",
		FIREFLIES =
		{
			GENERIC = "How pretty",
			HELD = "Yes.. light in my hand.",
		},
		FIREHOUND = "No...no no no no!",
		FIREPIT =
		{
			EMBERS = "Yes, this is called FIRE.",
			GENERIC = "Light and hot",
			HIGH = "So warm..so warm.",
			LOW = "This is bad.",
			NORMAL = "Nice light",
			OUT = "Next time, then",
		},
		FIRESTAFF = "I can burn thing up with this!",
		FISH = "This looks funny.",
		FISHINGROD = "Time for fishing!",
		FISHSTICKS = "Mmm...",
		FISHTACOS = "hmmmm...",
		FISH_COOKED = "This is not enough...",
		FLINT = "It's a rock thing not coffee.",
		FLOWER = "Yes...a flower like me.",
		FLOWERHAT = "My head doesn't has enough?",
		FLOWER_EVIL = "I feel like an enemy..",
		FOLIAGE = "....",
		FOOTBALLHAT = "Nice protection for head!",
		FROG =
		{
			DEAD = "Shut your mouth",
			GENERIC = "No, don't come near me.",
			SLEEPING = "Its eyes are open wide...",
		},
		FROGGLEBUNWICH = "For my health!",
		FROGLEGS = "Cook it cook it!",
		FROGLEGS_COOKED = "Nice dilicious frog leg.",
		FRUITMEDLEY = "I need ice-cream some how.",
		GEARS = "meatal thing!",
		GHOST = "Yike!",
		GOLDENAXE = "Where's silver axe?",
		GOLDENPICKAXE = "seriously?",
		GOLDENPITCHFORK = "golden...what?",
		GOLDENSHOVEL = "Ok...my mind...",
		GOLDNUGGET = "Gold!!! but this is not food.",
		GRASS =
		{
			BARREN = "Poop time",
			BURNING = "No!!!",
			GENERIC = "I wish that's coffee.",
			PICKED = "It will grow back.",
		},
		GREEN_CAP = "I love green.",
		GREEN_CAP_COOKED = "This is good for me.",
		GREEN_MUSHROOM =
		{
			GENERIC = "I wanna pick that.",
			INGROUND = "Aw... get up!",
			PICKED = "Come back soon.",
		},
		GUNPOWDER = "BOOM!",
		HAMBAT = "I feel like wanna eat my weapon...",
		HAMMER = "Let's smash something.",
		HEALINGSALVE = "This can make me feel better.",
		HEATROCK =
		{
			COLD = "Must be nice in Summer",
			GENERIC = "Duh...",
			HOT = "Hot...",
			WARM = "So warm, I wanna sleep.",
		},
		HOME = "Anyone there?",
		HOMESIGN = "For what?",
		HONEY = "yum!",
		HONEYCOMB = "Time to build new home.",
		HONEYHAM = "Meant and Honey = WIN",
		HONEYNUGGETS = "AHHHH HEAVEN!",
		HORN = "Nice horn",
		HOUND = "That fluffy dogie",
		HOUNDBONE = "This is scary...",
		HOUNDMOUND = "BONES!",
		ICEBOX = "Yes, this will keep food with me longer.",
		ICEHOUND = "Can't you just be my pet?",
		INSANITYROCK =
		{
			ACTIVE = "What the...",
			INACTIVE = "Oh well",
		},
		JAMMYPRESERVES = "uh...",
		KABOBS = "nom nom nom",
		KILLERBEE =
		{
			GENERIC = "I HATE YOU!",
			HELD = "Got ya..",
		},
		KNIGHT = "That's not a pony.",
		KOALEFANT_SUMMER = "I want to eat you.",
		KOALEFANT_WINTER = "I want to eat you.",
		KRAMPUS = "Whoa! my stuff!",
		KRAMPUS_SACK = "This is awesome bag!",
		LEIF = "....",
		LEIF_SPARSE = "....",
		LIGHTNING_ROD =
		{
			CHARGED = "Good Job",
			GENERIC = "No more burning",
		},
		LITTLE_WALRUS = "Even you're a baby I still want to eat you.",
		LIVINGLOG = "It's screaming...",
		LOCKEDWES = "I must help him.",
		LOG = 
		{
			BURNING = "NOOOOOOOOO!!!",
			GENERIC = "I feel bad chop them down but... whatever.",
		},
		LUREPLANT = "Eat much, eh?",
		LUREPLANTBULB = "This is the same kind as me.",
		MALE_PUPPET = "What?",
		MANDRAKE =
		{
			DEAD = "Poor thing...",
			GENERIC = "So cute!",
			PICKED = "Oops...",
		},
		MANDRAKESOUP = "Eat and scream",
		MANDRAKE_COOKED = "Eat and scream",
		MARBLE = "It's so smooth.",
		MARBLEPILLAR = "Looks expensive.",
		MARBLETREE = "A tree... what?!",
		MARSH_BUSH =
		{
			BURNING = "hahahahaha",
			GENERIC = "I don't trust that.",
			PICKED = "OUCH!",
		},
		MARSH_PLANT = "Nothing to do.",
		MARSH_TREE =
		{
			BURNING = "yes..Yes..YES!!",
			BURNT = "Suit yourself",
			CHOPPED = "Die!",
			GENERIC = "I hate this kind of tree.",
		},
		MAXWELL = "He's not that friendly.",
		MAXWELLHEAD = "Uh...",
		MAXWELLLIGHT = "Wow... magic!",
		MAXWELLLOCK = "Hmm should I unlock this?",
		MAXWELLTHRONE = "Ohhh... You look tired...",
		MEAT = "MEAT!",
		MEATBALLS = "Fill my belly!",
		MEATRACK =
		{
			DONE = "It's ready to eat.",
			DRYING = "SLOW!!!",
			GENERIC = "Time to dry some meat.",
		},
		MEAT_DRIED = "Food with longer life",
		MERM = "What are you?",
		MERMHEAD = "Gross..",
		MERMHOUSE = "That house looks old.",
		MINERHAT = "I can travel at night with this!",
		MONSTERLASAGNA = "I don't trust this.",
		MONSTERMEAT = "I shouldn't eat that.",
		MONSTERMEAT_DRIED = "I keep this for pig...",
		MOSQUITO =
		{
			GENERIC = "Go away!",
			HELD = "It's useless.",
		},
		MOUND =
		{
			DUG = "Okay..",
			GENERIC = "Is something inside?",
		},
		NIGHTLIGHT = "I feel weird..",
		NIGHTMAREFUEL = "Something nightmare..",
		NIGHTSWORD = "Darkness!",
		NITRE = "This can be used in some way.",
		ONEMANBAND = "I love music! but I prefer piano.",
		PANFLUTE = "I wish I play piano.",
		PAPYRUS = "Time to make some papers.",
		PENGUIN = "Noisy!",
		PERD = "Stop stealing my food you jerk!",
		PEROGIES = "I wanna eat it.",
		PETALS = "I feel bad picking these.",
		PETALS_EVIL = "Evil!",
		PICKAXE = "Now I can break some rock.",
		PIGGYBACK = "Too heavy but carry.",
		PIGHEAD = "I feel bad for this pig.",
		PIGHOUSE =
		{
			FULL = "What a nice house you have there...",
			GENERIC = "What a nice house you have there...",
			LIGHTSOUT = "Uh.. Oh well..",
		},
		PIGKING = "The King!",
		PIGMAN =
		{
			DEAD = "Good bye food",
			FOLLOWER = "Food are following me...",
			GENERIC = "Oh you're a pig.",
			GUARD = "This is not good.",
			WEREPIG = "WAH! DIE!",
		},
		PIGSKIN = "Why can't I eat this?",
		PIGTORCH = "The torch of doom..",
		PINECONE = 
		{
		    GENERIC = "I can feel life in here.",
		    PLANTED = "keep growing",
		},
		PITCHFORK = "Fork the ground..",
		PLANTMEAT = "What the... this is meat or plant?",
		PLANTMEAT_COOKED = "It's food anyway.",
		PLANT_NORMAL =
		{
			GENERIC = "First Step of life",
			GROWING = "Come on, grow faster.",
			READY = "Time to eat",
		},
		POMEGRANATE = "Food",
		POMEGRANATE_COOKED = "Food",
		POND = "I smell food in there.",
		POOP = "Yes, Plant need this but not for me...",
		PUMPKIN = "Huge thing",
		PUMPKINCOOKIE = "Yum! Cookies!",
		PUMPKIN_COOKED = "It's just huge food.",
		PUMPKIN_LANTERN = "Nice feeling...",
		PUMPKIN_SEEDS = "Pumpkin seed",
		PURPLEGEM = "This gem looks powerful.",
		RABBIT =
		{
			GENERIC = "You cute little thing.",
			HELD = "I won't let you go.",
		},
		RABBITHOLE = "I wonder how is it inside.",
		RAINOMETER = "Then prepare an umbrella.",
		RATATOUILLE = "Not much fill my belly.",
		RAZOR = "I wanna shape something.",
		REDGEM = "Red gem",
		RED_CAP = "Poisoned...",
		RED_CAP_COOKED = "This can make me crazy.",
		RED_MUSHROOM =
		{
			GENERIC = "I wanna pick that.",
			INGROUND = "Aw... get up!",
			PICKED = "Come back soon.",
		},
		REEDS =
		{
			BURNING = "Noo! what a waste.",
			GENERIC = "Why you're not coffee.",
			PICKED = "It'll grow back.",
		},
		RESEARCHLAB = "Time to create something.",
		RESEARCHLAB2 = "I got a headache now.",
		RESEARCHLAB3 = "Uhhhhhhh....my head",
		RESEARCHLAB4 = "This is something...",
		RESURRECTIONSTATUE = "This is weird.",
		RESURRECTIONSTONE = "This is weird.",
		ROBIN =
		{
			GENERIC = "You looks like an apple.",
			HELD = "Apple treat! haha!",
		},
		ROBOT_PUPPET = "What are you?",
		ROCK = "I could break that.",
		ROOK = "So strong!",
		ROCKS = "Rocks every where.",
		ROPE = "I hope this rope is not too old.",
		ROTTENEGG = "Eww...",
		SANITYROCK =
		{
			ACTIVE = "What the...",
			INACTIVE = "Oh well...",
		},
		SAPLING =
		{
			BURNING = "NOOO!!",
			GENERIC = "Why you no coffee??",
			PICKED = "I'm sorry I need to.",
		},
		SEEDS = "I feel life and food in the same time.",
		SEWING_KIT = "I'm bad at this but whatever.",
		SHOVEL = "Dig Dig Dig!",
		SILK = "This looks strong.",
		SKELETON = "Oh...I feel bad for you.",
		SKULLCHEST = "that...is...weird..",
		SMALLBIRD =
		{
			GENERIC = "Awww cute little bird!",
			HUNGRY = "You need some food?",
			STARVING = "Uh...Okay.. I'm also hungry anyway.",
		},
		SMALLMEAT = "Too small to eat",
		SMALLMEAT_DRIED = "small but good taste",
		SPEAR = "Time to kill something!",
		SPIDER =
		{
			DEAD = "Seriously, you should be my pet.",
			GENERIC = "What a cute fluffy little spider.",
			SLEEPING = "Aw...look at how cute you are.",
		},
		SPIDERDEN = "I shouldn't let it grow too big.",
		SPIDEREGGSACK = "Now I can have a pet spider? no.",
		SPIDERGLAND = "How can this thing fit there body?",
		SPIDERHAT = "I can really have spiders as a pet this TIME!",
		SPIDERQUEEN = "WHOA! You absolutely are UGLY!",
		SPIDER_WARRIOR =
		{
			DEAD = "Yes! go die, you jumping monster.",
			GENERIC = "This thing is not friendly enough.",
			SLEEPING = "Grr...Why you're so cute sleeping.",
		},
		SPOILED_FOOD = "I won't eat that.",
		STATUEHARP = "Too bad can't play.",
		STATUEMAXWELL = "Who's this guy?",
		STUFFEDEGGPLANT = "Mmm... This must be really tasty.",
		STINGER = "From bee's butt!",
		STRAWHAT = "I don't like wearing this much...",
		TAFFY = "Sweet but not enough.",
		SUNKBOAT = "What happen to it..",
		TALLBIRD = "YIKE! YOU EYE MONSTER!",
		TALLBIRDEGG = "That egg looks dilicious!",
		TALLBIRDEGG_COOKED = "Yesss YESSSS YESSSSS!!",
		TALLBIRDEGG_CRACKED =
		{
			COLD = "It needs warm.",
			GENERIC = "Ohhh hatching!",
			HOT = "I better keep it away from fire..",
			LONG = "Come on, I'm waiting.",
			SHORT = "Yay, almost now!",
		},
		TEENBIRD =
		{
			GENERIC = "How come you turn ugly...",
			HUNGRY = "Seriously, you're lowing my food.",
			STARVING = "Ok Ok!! I'll give some to you.",
		},
		TELEPORTATO_BASE =
		{
			ACTIVE = "I hope I can find some coffee..",
			GENERIC = "Time to travel",
			LOCKED = "One last thing",
			PARTIAL = "Hm...there must be something to fit.",
		},
		TELEPORTATO_BOX = "Something box..",
		TELEPORTATO_CRANK = "What's this for?",
		TELEPORTATO_POTATO = "I can't eat this even it's called potato.",
		TELEPORTATO_RING = "Hoola hoop? not really.",
		TELESTAFF = "Should I use this?",
		TENT = "I can have a good sleep with this.",
		TENTACLE = "No no no! get away from me.",
		TENTACLESPOTS = "I shouldn't go near that.",
		TENTACLESPIKE = "MORE DAMAGE!",
        	TENTACLE_PILLAR = "This is not good...",
        	TENTACLE_PILLAR_ARM = "Whoa, too many!",
        	TENTACLE_GARDEN = "Uh...",
		TOPHAT = "Hahaha This sounds like magic some how.",
		TORCH = "Little light for life.",
		TRAP = "hehehe...fooooood",
		TRAP_TEETH = "This must be very effective for little puppy.",
		TRAP_TEETH_MAXWELL = "I shouldn't step one that...",
		TREASURECHEST = "Any Coffee!?",
		TRINKET_1 = "Hmm...",
		TRINKET_10 = "Hmm...",
		TRINKET_11 = "Hmm...",
		TRINKET_12 = "Hmm...",
		TRINKET_2 = "Hmm...",
		TRINKET_3 = "Hmm...",
		TRINKET_4 = "Hmm...",
		TRINKET_5 = "Hmm...",
		TRINKET_6 = "Hmm...",
		TRINKET_7 = "Hmm...",
		TRINKET_8 = "Hmm...",
		TRINKET_9 = "Hmm...",
		TRUNKVEST_SUMMER = "I knew it, I should eat the trunk.",
		TRUNKVEST_WINTER = "It's warm but I seriously should eat the trunk..",
		TRUNK_COOKED = "YES... THE BESET STEAK EVER!",
		TRUNK_SUMMER = "Quickly cook this now!",
		TRUNK_WINTER = "Quickly cook this now!",
		TWIGS = "Arms of plant...",
		UMBRELLA = "I don't need this. I love rain!",
		WAFFLES = "I wanna eat this.",
		WALL_HAY = "For burning?",
		WALL_HAY_ITEM = "This can get burned easily.",
		WALL_STONE = "House protection!",
		WALL_STONE_ITEM = "Nice wall",
		WALL_RUINS = "This wall looks strong.",
		WALL_RUINS_ITEM = "Cool wall",
		WALL_WOOD = "For burning?",
		WALL_WOOD_ITEM = "Warning... easy to get burned..",
		WALRUS = "Hello kid",
		WALRUSHAT = "Nice hat",
		WALRUS_CAMP =
		{
			EMPTY = "Oh.. no one home?",
			GENERIC = "I shouldn't go near it.",
		},
		WALRUS_TUSK = "Why are you following me?",
		WASPHIVE = "I hate killer bees.",
		WETGOOP = "I wanna eat....NOT!",
		WINTERHAT = "This is quite warm.",
		WINTEROMETER = "Now I can prepare before winter.",
		WORMHOLE =
		{
			GENERIC = "Oh, what is that?",
			OPEN = "Looks like a gate but...not so safe.",
		},
		WORMHOLE_LIMITED = "I'm sorry...",
		ACCOMPLISHMENT_SHRINE = "Ok, I have to use this?",        
		LIVINGTREE = "Hello... friend...?",
		ICESTAFF = "This is NICE woo!",

		DESCRIBE_GENERIC = "Hmm.. what?",
		DESCRIBE_TOODARK = "I can't see a thing.",
		EAT_FOOD =
		{
		TALLBIRDEGG_CRACKED = "Mmmm... nice",
		},

	}



return MakePlayerCharacter("coffgirl", prefabs, assets, fn)
