=begin
Copyright 2013, Chris Fullmer
All Rights Reserved

Disclaimer
THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

License
This software is distributed under the Smustard End User License Agreement
http://www.smustard.com/eula

Information
Author - Chris Fullmer with Stepped colorization by ICEPAM.
Organization - www.ChrisFullmer.com and distributed on the SketchUp Extension Warehouse and smustard.com
Name - Components Onto Faces
SU Version - 2013, 8, 7

Description
This script takes a component and copies it onto all selected faces.  It orients it with the face orientation.

Usage
Select a single component and a series of ungrouped faces.  Then run this script.  It will copy that 
component onto all the faces.  It will ignore any edges, groups, images, etc that are in the selection set.  
If more than one component is selected, it will use the first one it encounters.  Its probably pretty buggy.  
I think it is trying to center the component by using the components axis.


History
0.1:: 2009-03-07
   * First release
0.2:: 2009-03-09
   * Added a few Promtps if the script is used incorrectly.
   * Organizer.rb support. If you place this script into an organizer directory, it will appear in the correct submenu.  If its just in the plugins folder, it will appear in "Chris Fullmer Tools" submenu of the Plugins Menu."
1.0:: 2009-03-15
   * Added a new tool - "Components on Face Collections".  Works better with triangluated squares where the inner line has been smoothed.
1.1:: 2009-03-15
   * Added triangle detection.  If there are faces that are just triangles, the script now correctly places the component in the middle of the triangle.
1.2.0 - 2013-05-20
  * EW Compliance
=end

module CLF_Extensions_NS

  module CLF_Components_Onto_Faces

    require 'sketchup.rb'
    require 'extensions.rb'
    
    NAME = "clf_components_onto_faces"
    UNAME = "CLF 组件到面"
    MENU_NAME = "组件到面"
    version = "1.2.0"           
    desc = "这个插件将把一个选定的组件放在所有选定面的中心。"
    copy_year = "2013"
    author = "Chris Fullmer"
    
#------edit above--------------------------------------------------------------- 

    
    extension = SketchupExtension.new UNAME, NAME+"/"+NAME+"_menus.rb"

    #The name= method sets the name which appears for an extension inside the Extensions Manager dialog.
    extension.name = UNAME

    # The description= method sets the long description which appears beneath an extension inside the Extensions Manager dialog.
    extension.description = desc + "  Access it via Plugins > Chris Fullmer Tools > "+MENU_NAME

    # The version method sets the version which appears beneath an extension inside the Extensions Manager dialog.
    extension.version = version

    # Create an entry in the Extension list that loads a script called
    # stairTools.rb.
    extension.copyright = copy_year
     
    # The creator= method sets the creator string which appears beneath an extension inside the Extensions Manager dialog.
    extension.creator = author

    # The register_extension method is used to register an extension with SketchUp's extension manager (in SketchUp preferences).
    Sketchup.register_extension( extension, true )
    
  end
end  