# See the loader file for license and author info

require 'sketchup.rb'
module CLF_Extensions_NS

  module CLF_Components_Onto_Faces

    #This method was given to me by Whaat.  A Huge thanks to him for helping me figure this one out!
    #Determine all connected faces to the face (i.e. if bording edge is soft or hidden)
    #note: the recursive version seems to bugsplat on big number of faces. So I use an iterative version
    def self.face_neighbours( face )
      hsh_faces = {}
      lface = [face]
      while true
        break if lface.length == 0
        f = lface[0]
        if hsh_faces[f.entityID]
          lface[0..0] = []
        next
        end   
        lface[0..0] = []
        hsh_faces[f.entityID] = f
        f.edges.each do |e|
          if e.hidden? || e.soft?
            e.faces.each do |ff| 
              lface.push ff unless ff == f || hsh_faces[ff.entityID]
            end   
          end   
        end
       end   
       hsh_faces.values
    end
    
    def self.face_collections
      model = Sketchup.active_model
      a = Sketchup.active_model.selection
      ents = model.active_entities
      face_groups = []
      faces = []
      edges = []
      comp = []
      cp = []
      a.each do |e|
        if e.is_a? Sketchup::Face
          faces.push e
        end
        if e.is_a? Sketchup::ComponentInstance
          comp.push e
        end
      end
      compdef = comp[0].definition
      if comp.length == 0
        UI.messagebox "您必须至少选择一个组件。"
      else
        if faces.length == 0
          UI.messagebox "您需要至少选择一个未成组的面。"
        else
          version = Sketchup.version
          versionnum = version[0,1].to_i
          if versionnum > 6
            model.start_operation("组件到面", true)
          else
            model.start_operation("组件到面")
          end
          while a.length > 0
            if a[0].is_a? Sketchup::Face
              b = face_neighbours a[0]
              if b.length == 1
                single_face = b[0]
                vector = single_face.normal
                edges = single_face.edges
                if edges.length == 3
                  p1s = edges[0].start.position
                  p1e = edges[0].end.position
                  p2s = edges[1].start.position
                  p2e = edges[1].end.position
                  p3s = edges[2].start.position
                  p3e = edges[2].end.position
                  cp[0] = (p1s.x + p1e.x + p2s.x + p2e.x + p3s.x + p3e.x) / 6
                  cp[1] = (p1s.y + p1e.y + p2s.y + p2e.y + p3s.y + p3e.y) / 6
                  cp[2] = (p1s.z + p1e.z + p2s.z + p2e.z + p3s.z + p3e.z) / 6
                else
                  cp = single_face.bounds.center
                end
              else
                bb = []
                bb1 = []
                bbox = Geom::BoundingBox.new
                b.each do |face|
                  bb1 = face.bounds
                  bbox.add ( bb1 )
                end
                cp = bbox.center
                veca = 0
                vecb = 0
                vecc = 0
                b.each do |e| # Gets the xyz values for the normals and adds them up.
                  veca = e.normal.x + veca
                  vecb = e.normal.y + vecb
                  vecc = e.normal.z + vecc
                end		
                vecx = veca / b.length # Takes the sum and divivdes by the number of faces, providing the average values
                vecy = vecb / b.length
                vecz = vecc / b.length
                vector = [vecx,vecy,vecz] # This is the new normal vector that will be used to make the end point for our line.
              end
              vector.normalize!
              if vector[0]==0 && vector[1]==0 && vector[2]==0
                vector = comp[0].transformation.zaxis
              end            
              t = Geom::Transformation.new(cp, vector)
              ents.add_instance compdef, t
              a.remove ( b )
            else
              a.remove ( a[0] )
            end
          end
          compdef = comp[0].definition
        end
        model.commit_operation
      end
    end
    

    # This method copies a component onto each face.
    def self.each_face
      model = Sketchup.active_model
      entities = model.selection
      faces = []
      comp = []
      cp = []
      entities.each do |e|
        if e.typename == 'Face'
          faces.push e
        end
        if e.typename == 'ComponentInstance'
          comp.push e
        end
      end
      if comp.length == 0
        UI.messagebox "您必须至少选择一个组件。"
      else
        ents = model.active_entities
        compdef = comp[0].definition
        if faces.length == 0
          UI.messagebox "您需要至少选择一个未成组的面。"
        else
          a = Sketchup.version
          b = a[0,1].to_i
          if b > 6
            model.start_operation("组件到面", true)
          else
            model.start_operation("组件到面")
          end 
          faces.each do |e|
            edges = e.edges
            if edges.length == 3
              p1s = edges[0].start.position
              p1e = edges[0].end.position
              p2s = edges[1].start.position
              p2e = edges[1].end.position
              p3s = edges[2].start.position
              p3e = edges[2].end.position
              cp[0] = (p1s.x + p1e.x + p2s.x + p2e.x + p3s.x + p3e.x) / 6
              cp[1] = (p1s.y + p1e.y + p2s.y + p2e.y + p3s.y + p3e.y) / 6
              cp[2] = (p1s.z + p1e.z + p2s.z + p2e.z + p3s.z + p3e.z) / 6
            else
              cp = e.bounds.center
            end
            t = Geom::Transformation.new(cp, e.normal)
            ents.add_instance compdef, t
          end
        model.commit_operation
        end
      end
    end
  end
end
