import bpy


class WS_OT_copy_world_space_clear(bpy.types.Operator):
    bl_idname = "copy_world_space.clear"
    bl_label = "Clear"
    bl_options = {'REGISTER', 'UNDO'}
    bl_description = "Clear Stored Data"

    def execute(self, context):

        # clear data
        bpy.context.window_manager['bone_rel_clipboard_data'] = {}
        bpy.context.window_manager['obj_rel_clipboard_data'] = {}
        bpy.context.window_manager['ws_clipboard_data'] = {}

        bpy.context.window_manager['relative_obj'] = None
        bpy.context.window_manager['source_relative_matrix'] = None
        bpy.context.window_manager['relative_bone'] = None
        bpy.context.window_manager['armature'] = None

        # set all state managers to to false
        bpy.types.WindowManager.obj_ws_clipboard_data = False
        bpy.types.WindowManager.obj_rel_clipboard_data = False
        bpy.types.WindowManager.bone_ws_clipboard_data = False
        bpy.types.WindowManager.bone_rel_clipboard_data = False
        bpy.types.WindowManager.single_clipboard_data = False

        return {'FINISHED'}
