import bpy

from mathutils import Matrix


def translateScale(scale):  # scale to matrix
    scale_matrix = Matrix()
    scale_matrix[0][0] = scale[0]
    scale_matrix[1][1] = scale[1]
    scale_matrix[2][2] = scale[2]

    return scale_matrix


def quick_sort(selected):  # quick and dirty parenting sort

    quick_order = []

    while len(quick_order) < len(selected):

        for item in selected:
            con_sort = False

            if item in quick_order:
                continue

            if len(item.constraints) > 0:
                for con in item.constraints:
                    if con.type == 'CHILD_OF' and con.influence > 0 and not con.mute:
                        for target in selected:
                            if target.name == con.subtarget or target.name == con.target.name:
                                if target not in quick_order:
                                    con_sort = True
                                    break

            if con_sort:
                continue

            if item.parent is None:
                quick_order.append(item)
                continue

            if item.parent not in selected:
                quick_order.append(item)
                continue

            if item.parent not in quick_order:
                continue

            else:
                quick_order.append(item)

    return quick_order
