import bpy


def prefs():
    return bpy.context.preferences.addons[__package__].preferences


class WS_PT_copy_paste_space(bpy.types.Panel):
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_label = "Copy World Space"
    bl_category = 'Item'
    bl_options = {'HEADER_LAYOUT_EXPAND'}

    @classmethod
    def poll(cls, context):
        return context.object is not None and context.mode in ('POSE', 'OBJECT') and prefs().show_panel

    def draw_header(self, context):
        layout = self.layout
        row = layout.row()
        row.label(text="")
        row.operator("copy_world_space.clear", emboss=False, text="", icon='DOT')

    def draw(self, context):
        layout = self.layout
        row = layout.row(align=True)
        row.operator("world_matrix.copy", emboss=True, text="Copy World")
        if bpy.types.WindowManager.obj_ws_clipboard_data is True and context.active_object.mode == 'OBJECT':
            row.operator("object_world_matrix.paste", emboss=True, text="Paste World", icon='OBJECT_DATA')
        elif bpy.types.WindowManager.bone_ws_clipboard_data is True:
            row.operator("bone_world_matrix.paste", emboss=True, text="Paste World", icon='BONE_DATA')
        else:
            row.operator("world_matrix.paste", emboss=True, text="Paste World", icon='DOT')
        row = layout.row(align=True)
        if context.mode == 'OBJECT':
            row.operator("object_relative.copy", emboss=True, text="Copy Relative")
            row.operator("object_relative.paste", emboss=True, text="Paste Relative")
        if context.mode == 'POSE':
            row.operator("bone_relative.copy", emboss=True, text="Copy Relative")
            row.operator("bone_relative.paste", emboss=True, text="Paste Relative")


class WS_MT_pie_menu(bpy.types.Menu):
    bl_label = "Copy World Space Pie"
    bl_idname = "WS_MT_pie_menu"

    def draw(self, context):
        layout = self.layout

        pie = layout.menu_pie()
        pie.operator("world_matrix.copy", text='Copy World', icon='COPYDOWN')

        if bpy.types.WindowManager.obj_ws_clipboard_data is True and context.active_object.mode == 'OBJECT':
            pie.operator("object_world_matrix.paste", emboss=True, text="Paste World", icon='OBJECT_DATA')
        elif bpy.types.WindowManager.bone_ws_clipboard_data is True:
            pie.operator("bone_world_matrix.paste", emboss=True, text="Paste World", icon='BONE_DATA')
        else:
            pie.operator("world_matrix.paste", emboss=True, text="Paste World", icon='DOT')

        if context.mode == 'OBJECT':
            pie.operator("object_relative.paste", emboss=True, text="Paste Relative", icon='PASTEDOWN')
            pie.operator("object_relative.copy", emboss=True, text="Copy Relative", icon='COPYDOWN')

        if context.mode == 'POSE':
            pie.operator("bone_relative.paste", emboss=True, text="Paste Relative", icon='PASTEDOWN')
            pie.operator("bone_relative.copy", emboss=True, text="Copy Relative", icon='COPYDOWN')

        pie.separator()
        pie.separator()
        pie.operator("copy_world_space.clear", text='', icon='TRASH')
