# Two main variables are taken from repository:
# https://github.com/sublimehq/Packages/blob/master/CSS/
# which has the following license:
#############
# If not otherwise specified (see below), files in this repository fall under the following license:
#
#     Permission to copy, use, modify, sell and distribute this
#     software is granted. This software is provided "as is" without
#     express or implied warranty, and with no claim as to its
#     suitability for any purpose.
#
# An exception is made for files in readable text which contain their own license information, or files where an accompanying file exists (in the same directory) with a “-license” suffix added to the base-name name of the original file, and an extension of txt, html, or similar. For example “tidy” is accompanied by “tidy-license.txt”.
#############

common_values = {
        "animation-direction": ["alternate", "alternate-reverse", "normal", "reverse"],
        "absolute-size": [
            "xx-small",
            "x-small",
            "small",
            "medium",
            "large",
            "x-large",
            "xx-large",
        ],
        "absolute-weight": [
            "100",
            "200",
            "300",
            "400",
            "500",
            "600",
            "700",
            "800",
            "900",
            "normal",
            "bold",
        ],
        "basic-shape": [
            ["circle()", "circle($1)"],
            ["ellipse()", "ellipse($1)"],
            ["inset()", "inset($1)"],
            ["polygon()", "polygon($1)"],
        ],
        "blend-mode": [
            "normal",
            "multiply",
            "screen",
            "overlay",
            "darken",
            "lighten",
            "color-dodge",
            "color-burn",
            "hard-light",
            "soft-light",
            "difference",
            "exclusion",
            "hue",
            "saturation",
            "color",
            "luminosity",
        ],
        "border-style": [
            "none",
            "hidden",
            "dotted",
            "dashed",
            "solid",
            "double",
            "groove",
            "ridge",
            "inset",
            "outset",
        ],
        "border-width": ["thin", "medium", "thick"],
        "break-before-after": [
            "always",
            "left",
            "right",
            "recto",
            "verso",
            "page",
            "column",
            "region",
        ],
        "break-inside": ["auto", "avoid", "avoid-page", "avoid-column", "avoid-region"],
        "calc": [
            ["calc()", "calc($1)"],
            ["clamp()", "clamp(${1:0}, ${2:0}, ${3:0})"],
            ["max()", "max(${1:0}, ${2:0})"],
            ["min()", "min(${1:0}, ${2:0})"],
        ],
        "color": [
            "currentColor",
            "transparent",
            ["rgb()", "rgb(${1:0}, ${2:0}, ${3:0})"],
            ["rgba()", "rgba(${1:0}, ${2:0}, ${3:0}, ${4:1.0})"],
            ["hsl()", "hsl(${1:0}, ${2:100%}, ${3:50%})"],
            ["hsla()", "hsla(${1:0}, ${2:100%}, ${3:50%}, ${4:1.0})"],
            # Named colors
            "aliceblue",
            "antiquewhite",
            "aqua",
            "aquamarine",
            "azure",
            "beige",
            "bisque",
            "black",
            "blanchedalmond",
            "blue",
            "blueviolet",
            "brown",
            "burlywood",
            "cadetblue",
            "chartreuse",
            "chocolate",
            "coral",
            "cornflowerblue",
            "cornsilk",
            "crimson",
            "cyan",
            "darkblue",
            "darkcyan",
            "darkgoldenrod",
            "darkgray",
            "darkgrey",
            "darkgreen",
            "darkkhaki",
            "darkmagenta",
            "darkolivegreen",
            "darkorange",
            "darkorchid",
            "darkred",
            "darksalmon",
            "darkseagreen",
            "darkslateblue",
            "darkslategray",
            "darkslategrey",
            "darkturquoise",
            "darkviolet",
            "deeppink",
            "deepskyblue",
            "dimgray",
            "dimgrey",
            "dodgerblue",
            "firebrick",
            "floralwhite",
            "forestgreen",
            "fuchsia",
            "gainsboro",
            "ghostwhite",
            "gold",
            "goldenrod",
            "gray",
            "grey",
            "green",
            "greenyellow",
            "honeydew",
            "hotpink",
            "indianred",
            "indigo",
            "ivory",
            "khaki",
            "lavender",
            "lavenderblush",
            "lawngreen",
            "lemonchiffon",
            "lightblue",
            "lightcoral",
            "lightcyan",
            "lightgoldenrodyellow",
            "lightgray",
            "lightgrey",
            "lightgreen",
            "lightpink",
            "lightsalmon",
            "lightseagreen",
            "lightskyblue",
            "lightslategray",
            "lightslategrey",
            "lightsteelblue",
            "lightyellow",
            "lime",
            "limegreen",
            "linen",
            "magenta",
            "maroon",
            "mediumaquamarine",
            "mediumblue",
            "mediumorchid",
            "mediumpurple",
            "mediumseagreen",
            "mediumslateblue",
            "mediumspringgreen",
            "mediumturquoise",
            "mediumvioletred",
            "midnightblue",
            "mintcream",
            "mistyrose",
            "moccasin",
            "navajowhite",
            "navy",
            "oldlace",
            "olive",
            "olivedrab",
            "orange",
            "orangered",
            "orchid",
            "palegoldenrod",
            "palegreen",
            "paleturquoise",
            "palevioletred",
            "papayawhip",
            "peachpuff",
            "peru",
            "pink",
            "plum",
            "powderblue",
            "purple",
            "rebeccapurple",
            "red",
            "rosybrown",
            "royalblue",
            "saddlebrown",
            "salmon",
            "sandybrown",
            "seagreen",
            "seashell",
            "sienna",
            "silver",
            "skyblue",
            "slateblue",
            "slategray",
            "slategrey",
            "snow",
            "springgreen",
            "steelblue",
            "tan",
            "teal",
            "thistle",
            "tomato",
            "turquoise",
            "violet",
            "wheat",
            "white",
            "whitesmoke",
            "yellow",
            "yellowgreen",
        ],
        "counter-style": [["symbols()", "symbols($1)"]],
        "counter-symbols": [
            "cyclic",
            "numeric",
            "alphabetic",
            "symbolic",
            "additive",
            "fixed",
        ],
        "ending-shape": ["circle", "ellipse"],
        "fill-rule": ["nonzero", "evenodd"],
        "filter-function": [
            ["blur()", "blur($1)"],
            ["brightness()", "brightness($1)"],
            ["contrast()", "contrast($1)"],
            ["drop-shadow()", "drop-shadow($1)"],
            ["grayscale()", "grayscale($1)"],
            ["hue-rotate()", "hue-rotate($1)"],
            ["invert()", "invert($1)"],
            ["opacity()", "opacity($1)"],
            ["saturate()", "saturate($1)"],
            ["sepia()", "sepia($1)"],
        ],
        "font-variant-alternates": [
            "normal",
            "historical-forms",
            ["stylistic()", "stylistic($1)"],
            ["styleset()", "styleset($1)"],
            ["character-variant()", "character-variant($1)"],
            ["swash()", "swash($1)"],
            ["ornaments()", "ornaments($1)"],
            ["annotation()", "annotation($1)"],
        ],
        "generic-font-name": [
            "serif",
            "sans-serif",
            "cursive",
            "fantasy",
            "monospace",
        ],
        "gradient": [
            ["conic-gradient()", "conic-gradient($1)"],
            ["linear-gradient()", "linear-gradient($1)"],
            ["radial-gradient()", "radial-gradient($1)"],
            ["repeating-conic-gradient()", "repeating-conic-gradient($1)"],
            ["repeating-linear-gradient()", "repeating-linear-gradient($1)"],
            ["repeating-radial-gradient()", "repeating-radial-gradient($1)"],
        ],
        "grid": [
            ["repeat()", "repeat(${1:2}, ${2:1fr})"],
            ["minmax()", "minmax(${1:100px}, ${2:1fr})"],
        ],
        "image": [
            "<url>",
            ["image()", "image($1)"],
            ["image-set()", "image-set($1)"],
            ["element()", "element($1)"],
            ["paint()", "paint($1)"],
            ["cross-fade()", "cross-fade($1)"],
            ["linear-gradient()", "linear-gradient($1)"],
            ["repeating-linear-gradient()", "repeating-linear-gradient($1)"],
            ["radial-gradient()", "radial-gradient($1)"],
            ["repeating-radial-gradient()", "repeating-radial-gradient($1)"],
            ["conic-gradient()", "conic-gradient($1)"],
        ],
        "image-tags": ["ltr", "rtl"],
        "line-style": [
            "none",
            "hidden",
            "dotted",
            "dashed",
            "solid",
            "double",
            "groove",
            "ridge",
            "inset",
            "outset",
        ],
        "leader-type": ["dotted", "solid", "space"],
        "list-style-type": [
            "none",
            "inline",
            "disc",
            "circle",
            "square",
            "decimal",
            "decimal-leading-zero",
            "arabic-indic",
            "binary",
            "bengali",
            "cambodian",
            "khmer",
            "devanagari",
            "gujarati",
            "gurmukhi",
            "kannada",
            "lower-hexadecimal",
            "lao",
            "malayalam",
            "mongolian",
            "myanmar",
            "octal",
            "oriya",
            "persian",
            "urdu",
            "telugu",
            "tibetan",
            "thai",
            "upper-hexadecimal",
            "lower-roman",
            "upper-roman",
            "lower-greek",
            "lower-alpha",
            "lower-latin",
            "upper-alpha",
            "upper-latin",
            "afar",
            "ethiopic-halehame-aa-et",
            "ethiopic-halehame-aa-er",
            "amharic",
            "ethiopic-halehame-am-et",
            "amharic-abegede",
            "ethiopic-abegede-am-et",
            "cjk-earthly-branch",
            "cjk-heavenly-stem",
            "ethiopic",
            "ethiopic-halehame-gez",
            "ethiopic-abegede",
            "ethiopic-abegede-gez",
            "hangul-consonant",
            "hangul",
            "lower-norwegian",
            "oromo",
            "ethiopic-halehame-om-et",
            "sidama",
            "ethiopic-halehame-sid-et",
            "somali",
            "ethiopic-halehame-so-et",
            "tigre",
            "ethiopic-halehame-tig",
            "tigrinya-er",
            "ethiopic-halehame-ti-er",
            "tigrinya-er-abegede",
            "ethiopic-abegede-ti-er",
            "tigrinya-et",
            "ethiopic-halehame-ti-et",
            "tigrinya-et-abegede",
            "ethiopic-abegede-ti-et",
            "upper-greek",
            "upper-norwegian",
            "asterisks",
            "footnotes",
            "hebrew",
            "armenian",
            "lower-armenian",
            "upper-armenian",
            "georgian",
            "cjk-ideographic",
            "hiragana",
            "katakana",
            "hiragana-iroha",
            "katakana-iroha",
        ],
        "position": ["<side-or-corner>", "center"],
        "relative-size": ["larger", "smaller"],
        "relative-weight": ["bolder", "lighter"],
        "repeat-style": [
            "repeat",
            "repeat-x",
            "repeat-y",
            "space",
            "round",
            "no-repeat",
        ],
        "self-position": [
            "center",
            "start",
            "end",
            "self-start",
            "self-end",
            "flex-start",
            "flex-end",
        ],
        "shape-radius": ["closest-side", "farthest-side"],
        "side-or-corner": ["left", "right", "top", "bottom"],
        "timing-function": [
            "linear",
            "ease",
            "ease-in",
            "ease-out",
            "ease-in-out",
            "step-start",
            "step-end",
            ["cubic-bezier()", "cubic-bezier(${1:0.0}, ${2:0.0}, ${3:1.0}, ${4:1.0})"],
            ["steps()", "steps(${1:2}, ${2:start})"],
        ],
        "type-or-unit": [
            "string",
            "color",
            "url",
            "integer",
            "number",
            "length",
            "angle",
            "time",
            "frequency",
            "cap",
            "ch",
            "em",
            "ex",
            "ic",
            "lh",
            "rlh",
            "rem",
            "vb",
            "vi",
            "vw",
            "vh",
            "vmin",
            "vmax",
            "mm",
            "Q",
            "cm",
            "in",
            "pt",
            "pc",
            "px",
            "deg",
            "grad",
            "rad",
            "turn",
            "ms",
            "s",
            "Hz",
            "kHz",
            "%",
        ],
        "url": [["url()", "url($1)"]],
    }


props = {
        "additive-symbols": [],
        "align-content": [
            "center",
            "flex-end",
            "flex-start",
            "space-around",
            "space-between",
            "stretch",
        ],
        "align-items": ["baseline", "center", "flex-end", "flex-start", "stretch"],
        "align-self": [
            "auto",
            "baseline",
            "center",
            "flex-end",
            "flex-start",
            "stretch",
        ],
        "align-tracks": ["normal"],
        "all": [],
        "alt": [],
        "animation": [
            "<animation-direction>",
            "<calc>",
            "<timing>",
            "none",
            "infinite",
            "forwards",
            "backwards",
            "both",
            "running",
            "paused",
        ],
        "animation-delay": ["<calc>"],
        "animation-direction": ["<animation-direction>"],
        "animation-duration": ["<calc>"],
        "animation-fill-mode": ["none", "forwards", "backwards", "both"],
        "animation-iteration-count": [
            "<calc>",
            "infinite",
        ],
        "animation-name": [
            "none",
        ],
        "animation-play-state": ["running", "paused"],
        "animation-timing-function": ["<calc>", "<timing>"],
        "appearance": ["auto", "menulist-button", "none", "textfield"],
        "aspect-ratio": ["auto"],
        "azimuth": [
            "<calc>",
            "behind",
            "center",
            "center-left",
            "center-right",
            "far-left",
            "far-right",
            "left",
            "left-side",
            "leftwards",
            "right",
            "right-side",
            "rightwards",
        ],
        "backdrop-filter": ["none"],
        "backface-visibility": ["visible", "hidden"],
        "background": [
            "<calc>",
            "<color>",
            "<gradient>",
            "<position>",
            "<repeat-style>",
            "<uri>",
            "fixed",
            "scroll",
        ],
        "background-attachment": ["fixed", "local", "scroll"],
        "background-blend-mode": ["<blend-mode>"],
        "background-clip": [
            "border-box",
            "content-box",
            "padding-box",
        ],
        "background-color": ["<color>"],
        "background-image": ["<uri>", "none"],
        "background-origin": [
            "border-box",
            "content-box",
            "padding-box",
        ],
        "background-position": ["<calc>", "<position>"],
        "background-position-x": [
            "<calc>",
            "center",
            "left",
            "right",
            "x-end",
            "x-start",
        ],
        "background-position-y": [
            "<calc>",
            "bottom",
            "center",
            "top",
            "y-end",
            "y-start",
        ],
        "background-repeat": ["<repeat-style>"],
        "background-size": [
            "<calc>",
            "auto",
            "cover",
            "contain",
        ],
        "behavior": [],
        "bleed": ["auto"],
        "block-size": ["<calc>", "auto"],
        "border": ["<border-width>", "<border-style>", "<calc>", "<color>"],
        "border-block": ["<border-width>", "<border-style>", "<calc>", "<color>"],
        "border-block-color": ["<color>"],
        "border-block-end": ["<border-width>", "<border-style>", "<calc>", "<color>"],
        "border-block-end-color": ["<color>"],
        "border-block-end-style": ["<border-style>"],
        "border-block-end-width": ["<border-width>", "<calc>"],
        "border-block-start": ["<border-width>", "<border-style>", "<calc>", "<color>"],
        "border-block-start-color": ["<color>"],
        "border-block-start-style": ["<border-style>"],
        "border-block-start-width": ["<border-width>", "<calc>"],
        "border-block-style": ["<border-style>"],
        "border-block-width": ["<border-width>", "<calc>"],
        "border-bottom": ["<border-width>", "<border-style>", "<calc>", "<color>"],
        "border-bottom-color": ["<color>"],
        "border-bottom-left-radius": ["<calc>"],
        "border-bottom-right-radius": ["<calc>"],
        "border-bottom-style": ["<border-style>"],
        "border-bottom-width": ["<border-width>", "<calc>"],
        "border-collapse": ["collapse", "separate"],
        "border-color": ["<color>"],
        "border-end-end-radius": ["<calc>"],
        "border-end-start-radius": ["<calc>"],
        "border-image": [
            "<calc>",
            "<uri>",
            "auto",
            "fill",
            "none",
            "repeat",
            "round",
            "space",
            "stretch",
        ],
        "border-image-outset": [],
        "border-image-repeat": ["stretch", "repeat", "round", "space"],
        "border-image-slice": [
            "<calc>",
            "fill",
        ],
        "border-image-source": ["none", "<uri>"],
        "border-image-width": ["<calc>", "auto"],
        "border-inline": ["<border-width>", "<border-style>", "<calc>", "<color>"],
        "border-inline-color": ["<color>"],
        "border-inline-end": ["<border-width>", "<border-style>", "<calc>", "<color>"],
        "border-inline-end-color": ["<color>"],
        "border-inline-end-style": ["<border-style>"],
        "border-inline-end-width": ["<border-width>", "<calc>"],
        "border-inline-start": [
            "<border-width>",
            "<border-style>",
            "<calc>",
            "<color>",
        ],
        "border-inline-start-color": ["<color>"],
        "border-inline-start-style": ["<border-style>"],
        "border-inline-start-width": ["<border-width>", "<calc>"],
        "border-inline-style": ["<border-style>"],
        "border-inline-width": ["<border-width>", "<calc>"],
        "border-left": ["<border-width>", "<border-style>", "<calc>", "<color>"],
        "border-left-color": ["<color>"],
        "border-left-style": ["<border-style>"],
        "border-left-width": ["<border-width>", "<calc>"],
        "border-radius": ["<calc>"],
        "border-right": ["<border-width>", "<border-style>", "<calc>", "<color>"],
        "border-right-color": ["<color>"],
        "border-right-style": ["<border-style>"],
        "border-right-width": ["<border-width>", "<calc>"],
        "border-spacing": [],
        "border-start-end-radius": ["<calc>"],
        "border-start-start-radius": ["<calc>"],
        "border-style": ["<border-style>"],
        "border-top": ["<border-width>", "<border-style>", "<calc>", "<color>"],
        "border-top-color": ["<color>"],
        "border-top-left-radius": ["<calc>"],
        "border-top-right-radius": ["<calc>"],
        "border-top-style": ["<border-style>"],
        "border-top-width": ["<border-width>", "<calc>"],
        "border-width": ["<border-width>", "<calc>"],
        "bottom": ["<calc>", "auto"],
        "box-align": ["baseline", "center", "end", "start", "stretch"],
        "box-decoration-break": ["slice", "clone"],
        "box-direction": ["normal", "reverse"],
        "box-flex": ["<calc>"],
        "box-flex-group": ["<calc>"],
        "box-lines": ["multiple", "single"],
        "box-ordinal-group": ["<calc>"],
        "box-orient": ["block-axis", "horizontal", "inline-axis", "vertical"],
        "box-pack": ["center", "end", "justify", "start"],
        "box-shadow": ["none", "inset", "<calc>", "<color>"],
        "box-sizing": ["content-box", "border-box"],
        "break-after": ["<break-before-after>", "<break-inside>"],
        "break-before": ["<break-before-after>", "<break-inside>"],
        "break-inside": ["<break-inside>"],
        "caption-side": ["top", "bottom"],
        "caret-color": ["auto", "<color>"],
        "clear": ["none", "left", "right", "both"],
        "clip": [["rect()", "rect(${1:0}, ${2:0}, ${3:0}, ${4:0})"], "auto"],
        "clip-path": ["none", "<uri>", "<basic-shape>"],
        "clip-rule": ["nonzero", "evenodd"],
        "color": ["<color>"],
        "color-adjust": ["economy", "exact"],
        "color-interpolation-filters": ["auto", "sRGB", "linearRGB"],
        "column-count": [
            "<calc>",
            "auto",
        ],
        "column-fill": ["auto", "balance"],
        "column-gap": [
            "<calc>",
            "normal",
        ],
        "column-rule": ["<border-width>", "<border-style>", "<calc>", "<color>"],
        "column-rule-color": ["<color>"],
        "column-rule-style": ["<border-style>"],
        "column-rule-width": ["<border-width>", "<calc>"],
        "column-span": ["<calc>", "none"],
        "column-width": [
            "<calc>",
            "auto",
        ],
        "columns": ["<calc>", "auto"],
        "contain": ["content", "layout", "none", "paint", "size", "strict", "style"],
        "content": [
            "none",
            "normal",
            "<string>",
            "<uri>",
            "open-quote",
            "close-quote",
            "no-open-quote",
            "no-close-quote",
            ["attr()", "attr($1)"],
            ["counter()", "counter($1)"],
        ],
        "content-visibility": ["auto", "hidden", "visible"],
        "counter-increment": [
            "<calc>",
            "none",
        ],
        "counter-reset": [
            "none",
        ],
        "counter-set": ["<calc>", "none"],
        "cursor": [
            "<uri>",
            "auto",
            "default",
            "none",
            "context-menu",
            "help",
            "pointer",
            "progress",
            "wait",
            "cell",
            "crosshair",
            "text",
            "vertical-text",
            "alias",
            "copy",
            "move",
            "no-drop",
            "not-allowed",
            "e-resize",
            "n-resize",
            "ne-resize",
            "nw-resize",
            "s-resize",
            "se-resize",
            "sw-resize",
            "w-resize",
            "ew-resize",
            "ns-resize",
            "nesw-resize",
            "nwse-resize",
            "col-resize",
            "row-resize",
            "all-scroll",
            "zoom-in",
            "zoom-out",
        ],
        "direction": ["ltr", "rtl"],
        "display": [
            "none",
            "inline",
            "inline-block",
            "inline-table",
            "inline-flex",
            "inline-grid",
            "block",
            "contents",
            "list-item",
            "table",
            "table-cell",
            "table-column",
            "table-column-group",
            "table-footer-group",
            "table-header-group",
            "table-row",
            "table-row-group",
            "table-caption",
            "flex",
            "flow",
            "flow-root",
            "grid",
            "ruby",
            "ruby-base",
            "ruby-text",
            "ruby-base-container",
            "ruby-text-container",
            "run-in",
        ],
        "empty-cells": ["show", "hide"],
        "enable-background": ["accumulate", "new"],
        "fallback": [],
        "fill": ["<color>"],
        "fill-opacity": [
            "<calc>",
        ],
        "fill-rule": ["nonzero", "evenodd"],
        "filter": [
            "<uri>",
            ["blur()", "blur(${1:5px})"],
            ["brightness()", "brightness(${1:1.0})"],
            ["contrast()", "contrast(${1:100%})"],
            ["drop-shadow()", "drop-shadow(${1:1px} ${2:1px})"],
            ["grayscale()", "grayscale(${1:50%})"],
            ["hue-rotate()", "hue-rotate(${1:90deg})"],
            ["invert()", "invert(${1:50%})"],
            ["opacity()", "opacity(${1:100%})"],
            ["saturate()", "saturate(${1:50%})"],
            ["sepia()", "sepia(${1:50%})"],
        ],
        "flex": [
            "<calc>",
            "none" "auto",
        ],
        "flex-basis": [
            "<calc>",
            "auto",
        ],
        "flex-direction": ["row", "row-reverse", "column", "column-reverse"],
        "flex-flow": [
            "row",
            "row-reverse",
            "column",
            "column-reverse",
            "nowrap",
            "wrap",
            "wrap-reverse",
        ],
        "flex-grow": [
            "<calc>",
        ],
        "flex-shrink": [
            "<calc>",
        ],
        "flex-wrap": ["nowrap", "wrap", "wrap-reverse"],
        "float": [
            "left",
            "right",
            "none",
            "inline-start",
            "inline-end",
        ],
        "flood-color": ["<color>"],
        "flood-opacity": [
            "<calc>",
        ],
        "font": [
            "<absolute-weight>",
            "<calc>",
            "<generic-font-name>",
            "<relative-weight>",
            "caption",
            "icon",
            "italic",
            "menu",
            "message-box",
            "oblique",
            "small-caps",
            "small-caption",
            "status-bar",
        ],
        "font-display": ["auto", "block", "fallback", "optional", "swap"],
        "font-family": ["<generic-font-name>"],
        "font-feature-settings": ["normal", "<string>"],
        "font-kerning": ["auto", "normal", "none"],
        "font-language-override": ["normal", "<string>"],
        "font-optical-sizing": ["auto", "none"],
        "font-size": [
            "<calc>",
            "<absolute-size>",
            "<relative-size>",
        ],
        "font-size-adjust": [
            "<calc>",
            "none",
        ],
        "font-smooth": ["always", "auto", "never"],
        "font-stretch": [
            "normal",
            "semi-condensed",
            "condensed",
            "extra-condensed",
            "ultra-condensed",
            "semi-expanded",
            "expanded",
            "extra-expanded",
            "ultra-expanded",
        ],
        "font-style": ["normal", "italic", "oblique"],
        "font-synthesis": ["none", "weight", "style"],
        "font-variant": ["normal", "small-caps"],
        "font-variant-alternates": ["<font-variant-alternates>"],
        "font-variant-caps": [
            "normal",
            "small-caps",
            "all-small-caps",
            "petite-caps",
            "all-petite-caps",
            "unicase",
            "titling-case",
        ],
        "font-variant-east-asian": [
            "normal",
            "ruby",
            "jis78",
            "jis83",
            "jis90",
            "jis04",
            "simplified",
            "traditional",
        ],
        "font-variant-ligatures": [
            "normal",
            "none",
            "common-ligatures",
            "no-common-ligatures",
            "discretionary-ligatures",
            "no-discretionary-ligatures",
            "historical-ligatures",
            "no-historical-ligatures",
            "contextual",
            "no-contextual",
        ],
        "font-variant-numeric": [
            "normal",
            "ordinal",
            "slashed-zero",
            "lining-nums",
            "oldstyle-nums",
            "proportional-nums",
            "tabular-nums",
            "diagonal-fractions",
            "stacked-fractions",
        ],
        "font-variant-position": ["normal", "sub", "super"],
        "font-variation-settings": ["normal"],
        "font-weight": ["<absolute-weight>", "<relative-weight>"],
        "forced-color-adjust": ["auto", "none"],
        "gap": [
            "<calc>",
        ],
        "glyph-orientation-horizontal": ["auto"],
        "glyph-orientation-vertical": ["auto"],
        "grid": [
            "<calc>",
            "<grid>",
            "auto",
            "auto-flow",
            "dense",
            "span",
        ],
        "grid-area": [
            "<calc>",
            "<grid>",
            "auto",
            "span",
        ],
        "grid-auto-columns": [
            "<calc>",
            "<grid>",
            "auto",
        ],
        "grid-auto-flow": ["row", "column", "dense"],
        "grid-auto-rows": [
            "<calc>",
            "<grid>",
            "auto",
        ],
        "grid-column": [
            "<calc>",
            "auto",
            "span",
        ],
        "grid-column-end": [
            "<calc>",
            "auto",
            "span",
        ],
        "grid-column-gap": [
            "<calc>",
            "auto",
            "span",
        ],
        "grid-column-start": [
            "<calc>",
            "auto",
            "span",
        ],
        "grid-gap": [
            "<calc>",
        ],
        "grid-row": [
            "<calc>",
            "auto",
            "span",
        ],
        "grid-row-end": [
            "<calc>",
            "auto",
            "span",
        ],
        "grid-row-gap": [
            "<calc>",
        ],
        "grid-row-start": [
            "<calc>",
            "auto",
            "span",
        ],
        "grid-template": [
            "<calc>",
            "<grid>",
            "auto",
            "max-content",
            "min-content",
            "none",
            "subgrid",
        ],
        "grid-template-areas": [
            "auto",
            "<calc>",
            "<grid>",
        ],
        "grid-template-columns": [
            "auto",
            "<calc>",
            "<grid>",
        ],
        "grid-template-rows": [
            "auto",
            "<calc>",
            "<grid>",
        ],
        "hanging-punctuation": ["allow-end", "first", "force-end", "last", "none"],
        "height": ["<calc>", "auto", "fit-content"],
        "hyphens": ["none", "manual", "auto"],
        "image-orientation": ["flip", "from-image"],
        "image-rendering": ["auto", "optimizeSpeed", "optimizeQuality", "pixelated"],
        "image-resolution": ["from-image"],
        "ime-mode": ["auto", "normal", "active", "inactive", "disabled"],
        "inherits": ["false", "true"],
        "initial-letter": ["normal"],
        "initial-letter-align": ["alphabetic", "auto", "hanging", "ideographic"],
        "initial-value": [
            "<calc>",
        ],
        "inline-size": ["<calc>", "auto"],
        "inset": [],
        "inset-block": [],
        "inset-block-end": [],
        "inset-block-start": [],
        "inset-inline": [],
        "inset-inline-end": [],
        "inset-inline-start": [],
        "isolation": ["auto", "isolation"],
        "justify-content": ["<justify>"],
        "justify-items": ["<justify>"],
        "justify-self": [],
        "justify-tracks": ["left", "normal", "right"],
        "kerning": ["<calc>", "auto"],
        "left": ["<calc>", "auto"],
        "letter-spacing": [
            "<calc>",
            "normal",
        ],
        "lighting-color": ["<color>"],
        "line-break": ["anywhere", "auto", "loose", "normal", "strict"],
        "line-clamp": ["<calc>", "none"],
        "line-height": [
            "<calc>",
            "normal",
        ],
        "line-height-step": [
            "<calc>",
        ],
        "list-style": [
            "<list-style-type>",
            "<uri>" "inside",
            "outside",
        ],
        "list-style-image": ["<uri>", "none"],
        "list-style-position": ["inside", "outside"],
        "list-style-type": ["<list-style-type>"],
        "margin": [
            "<calc>",
            "auto",
        ],
        "margin-block": [
            "<calc>",
        ],
        "margin-block-end": ["<calc>", "auto"],
        "margin-block-start": ["<calc>", "auto"],
        "margin-bottom": [
            "<calc>",
            "auto",
        ],
        "margin-inline": [
            "<calc>",
        ],
        "margin-inline-end": ["<calc>", "auto"],
        "margin-inline-start": ["<calc>", "auto"],
        "margin-left": [
            "<calc>",
            "auto",
        ],
        "margin-right": [
            "<calc>",
            "auto",
        ],
        "margin-top": [
            "<calc>",
            "auto",
        ],
        "margin-trim": ["all", "in-flow", "none"],
        "marker": ["<uri>", "none"],
        "marker-end": ["<uri>", "none"],
        "marker-mid": ["<uri>", "none"],
        "marker-start": ["<uri>", "none"],
        "marks": ["crop", "cross", "none"],
        "mask": ["<calc>", "<uri>", "none"],
        "mask-border": [
            "<calc>",
        ],
        "mask-border-mode": ["alpha", "luminance"],
        "mask-border-outset": [],
        "mask-border-repeat": ["repeat", "round", "space", "stretch"],
        "mask-border-slice": [],
        "mask-border-source": ["none"],
        "mask-border-width": ["<calc>", "auto"],
        "mask-clip": ["no-clip"],
        "mask-composite": [],
        "mask-image": ["<uri>", "none"],
        "mask-mode": ["alpha", "auto", "luminance"],
        "mask-origin": [
            "<calc>",
        ],
        "mask-position": [
            "<calc>",
        ],
        "mask-repeat": ["<repeat-style>"],
        "mask-size": ["<calc>", "auto", "contain", "cover"],
        "mask-type": ["luminance", "alpha"],
        "masonry-auto-flow": ["definite-first", "next", "ordered", "pack"],
        "math-style": ["compact", "normal"],
        "max-block-size": ["<calc>", "none"],
        "max-height": ["<calc>", "fit-content", "none"],
        "max-inline-size": ["<calc>", "none"],
        "max-lines": ["<calc>", "none"],
        "max-width": ["<calc>", "fit-content", "none"],
        "max-zoom": ["<calc>", "auto"],
        "min-block-size": [
            "<calc>",
        ],
        "min-height": ["<calc>", "fit-content"],
        "min-inline-size": [
            "<calc>",
        ],
        "min-width": ["<calc>", "fit-content"],
        "min-zoom": ["<calc>", "auto"],
        "mix-blend-mode": ["<blend-mode>"],
        "motion": [["path()", "path($1)"], "auto", "none", "reverse"],
        "motion-offset": [
            "<calc>",
        ],
        "motion-path": [["path()", "path($1)"], "none"],
        "motion-rotation": ["auto", "reverse"],
        "nav-down": ["auto", "current", "root"],
        "nav-index": ["auto"],
        "nav-left": ["auto", "current", "root"],
        "nav-right": ["auto", "current", "root"],
        "nav-up": ["auto", "current", "root"],
        "negative": [],
        "object-fit": ["fill", "contain", "cover", "none", "scale-down"],
        "object-position": ["<calc>", "<position>"],
        "offset": [
            "<calc>",
        ],
        "offset-anchor": ["<calc>", "auto"],
        "offset-block-end": ["<calc>", "auto"],
        "offset-block-start": ["<calc>", "auto"],
        "offset-distance": [
            "<calc>",
        ],
        "offset-inline-end": ["<calc>", "auto"],
        "offset-inline-start": ["<calc>", "auto"],
        "offset-path": ["<calc>", "none"],
        "offset-position": ["<calc>", "auto"],
        "offset-rotate": ["<calc>", "auto", "reverse"],
        "opacity": [
            "<calc>",
        ],
        "order": [],
        "orientation": ["auto", "landscape", "portrait"],
        "orphans": [],
        "outline": [
            "<color>",
            "<border-style>",
            "<border-width>",
            "<calc>",
        ],
        "outline-color": ["<color>", "invert"],
        "outline-offset": ["<calc>"],
        "outline-style": ["<border-style>"],
        "outline-width": [
            "<border-width>",
            "<calc>",
        ],
        "overflow": ["visible", "hidden", "scroll", "auto"],
        "overflow-anchor": ["auto", "none"],
        "overflow-block": ["auto", "clip", "hidden", "scroll", "visible"],
        "overflow-clip-box": ["content-box", "padding-box"],
        "overflow-inline": ["auto", "clip", "hidden", "scroll", "visible"],
        "overflow-wrap": ["normal", "break-word"],
        "overflow-x": ["visible", "hidden", "scroll", "auto"],
        "overflow-y": ["visible", "hidden", "scroll", "auto"],
        "overscroll-behavior": ["auto", "contain", "none"],
        "overscroll-behavior-block": ["auto", "contain", "none"],
        "overscroll-behavior-inline": ["auto", "contain", "none"],
        "overscroll-behavior-x": ["auto", "contain", "none"],
        "overscroll-behavior-y": ["auto", "contain", "none"],
        "pad": [
            "<calc>",
        ],
        "padding": ["<calc>", "auto"],
        "padding-block": [
            "<calc>",
        ],
        "padding-block-end": [
            "<calc>",
        ],
        "padding-block-start": [
            "<calc>",
        ],
        "padding-bottom": ["<calc>", "auto"],
        "padding-inline": [
            "<calc>",
        ],
        "padding-inline-end": [
            "<calc>",
        ],
        "padding-inline-start": [
            "<calc>",
        ],
        "padding-left": ["<calc>", "auto"],
        "padding-right": ["<calc>", "auto"],
        "padding-top": ["<calc>", "auto"],
        "page-break-after": ["auto", "always", "avoid", "left", "right"],
        "page-break-before": ["auto", "always", "avoid", "left", "right"],
        "page-break-inside": ["avoid", "auto"],
        "paint-order": ["normal", "fill", "stroke", "markers"],
        "perspective": ["none"],
        "perspective-origin": ["<calc>", "<position>"],
        "place-content": [],
        "place-items": [],
        "place-self": [],
        "pointer-events": [
            "auto",
            "none",
            "all",
            "visiblePainted",
            "visibleFill",
            "visibleStroke",
            "visible",
            "painted",
            "fill",
            "stroke",
        ],
        "position": ["static", "relative", "absolute", "fixed", "sticky"],
        "prefix": [],
        "print-color-adjust": ["economy", "exact"],
        "quotes": ["none", "<string>"],
        "range": ["auto", "infinite"],
        "resize": ["none", "both", "horizontal", "vertical"],
        "right": ["<calc>", "auto"],
        "rotate": ["<calc>", "none"],
        "row-gap": ["<calc>", "normal"],
        "ruby-align": [
            "auto",
            "center",
            "distribute-letter",
            "distribute-space",
            "left",
            "line-edge",
            "right",
            "space-around",
            "space-between",
            "start",
        ],
        "ruby-merge": ["auto", "collapse", "separate"],
        "ruby-overhang": ["auto", "end", "none", "start"],
        "ruby-position": [
            "after",
            "before",
            "inline",
            "inter-character",
            "over",
            "right",
            "under",
        ],
        "ruby-span": [["attr()", "attr($1)"], "<calc>", "none"],
        "scale": ["<calc>", "none"],
        "scroll-behavior": ["auto", "smooth"],
        "scroll-margin": ["<calc>"],
        "scroll-margin-block": ["<calc>"],
        "scroll-margin-block-end": ["<calc>"],
        "scroll-margin-block-start": ["<calc>"],
        "scroll-margin-bottom": ["<calc>"],
        "scroll-margin-inline": ["<calc>"],
        "scroll-margin-inline-end": ["<calc>"],
        "scroll-margin-inline-start": ["<calc>"],
        "scroll-margin-left": ["<calc>"],
        "scroll-margin-right": ["<calc>"],
        "scroll-margin-top": ["<calc>"],
        "scroll-padding": ["auto", "<calc>"],
        "scroll-padding-block": ["auto", "<calc>"],
        "scroll-padding-block-end": ["auto", "<calc>"],
        "scroll-padding-block-start": ["auto", "<calc>"],
        "scroll-padding-bottom": ["auto", "<calc>"],
        "scroll-padding-inline": ["auto", "<calc>"],
        "scroll-padding-inline-end": ["auto", "<calc>"],
        "scroll-padding-inline-start": ["auto", "<calc>"],
        "scroll-padding-left": ["auto", "<calc>"],
        "scroll-padding-right": ["auto", "<calc>"],
        "scroll-padding-top": ["auto", "<calc>"],
        "scroll-snap-align": ["center", "end", "none", "start"],
        "scroll-snap-coordinate": ["none"],
        "scroll-snap-destination": [],
        "scroll-snap-points-x": [["repeat()", "repeat($1)"], "none"],
        "scroll-snap-points-y": [["repeat()", "repeat($1)"], "none"],
        "scroll-snap-stop": ["always", "normal"],
        "scroll-snap-type": [
            "block",
            "both",
            "inline",
            "mandatory",
            "none",
            "proximity",
        ],
        "scroll-snap-type-x": ["mandatory", "none", "proximity"],
        "scroll-snap-type-y": ["mandatory", "none", "proximity"],
        "scrollbar-3dlight-color": ["<color>"],
        "scrollbar-arrow-color": ["<color>"],
        "scrollbar-base-color": ["<color>"],
        "scrollbar-color": ["auto", "dark", "light", "<color>"],
        "scrollbar-darkshadow-color": ["<color>"],
        "scrollbar-face-color": ["<color>"],
        "scrollbar-gutter": ["always", "auto", "stable"],
        "scrollbar-highlight-color": ["<color>"],
        "scrollbar-shadow-color": ["<color>"],
        "scrollbar-track-color": ["<color>"],
        "scrollbar-width": ["auto", "none", "thin", "<calc>"],
        "shape-image-threshold": [],
        "shape-margin": ["<calc>"],
        "shape-outside": [
            "none",
            "margin-box",
            "content-box",
            "border-box",
            "padding-box",
            "<basic-shape>",
            "<uri>",
        ],
        "shape-rendering": [
            "auto",
            "optimizeSpeed",
            "crispEdges",
            "geometricPrecision",
        ],
        "size": [
            "a3",
            "a4",
            "a5",
            "b4",
            "b5",
            "jis-b4",
            "jis-b5",
            "landscape",
            "ledger",
            "legal",
            "letter",
            "portrait",
        ],
        "speak-as": ["auto", "bullets", "numbers", "spell-out", "words"],
        "src": [["format()", "format($1)"], ["local()", "local($1)"], "<uri>"],
        "stop-color": ["<color>"],
        "stop-opacity": ["<calc>"],
        "stroke": ["<calc>", "<color>"],
        "stroke-dasharray": ["none"],
        "stroke-dashoffset": [],
        "stroke-linecap": ["butt", "round", "square"],
        "stroke-linejoin": ["round", "miter", "bevel"],
        "stroke-miterlimit": ["<calc>"],
        "stroke-opacity": ["<calc>"],
        "stroke-width": ["<calc>"],
        "suffix": [],
        "symbols": [],
        "syntax": [],
        "system": ["<counter-symbols>"],
        "tab-size": ["<calc>"],
        "table-layout": ["auto", "fixed"],
        "text-align": ["left", "right", "center", "justify", "justify-all"],
        "text-align-last": ["start", "end", "left", "right", "center", "justify"],
        "text-anchor": ["start", "middle", "end"],
        "text-combine-upright": ["all", "digits", "none"],
        "text-decoration": ["none", "underline", "overline", "line-through", "blink"],
        "text-decoration-color": ["<color>"],
        "text-decoration-line": ["none", "underline", "overline", "line-through"],
        "text-decoration-skip": [
            "box-decoration",
            "edges",
            "leading-spaces",
            "none",
            "objects",
            "spaces",
            "trailing-spaces",
        ],
        "text-decoration-skip-ink": ["all", "auto", "none"],
        "text-decoration-style": ["solid", "double", "dotted", "dashed", "wavy"],
        "text-decoration-thickness": ["auto", "from-font"],
        "text-emphasis": [
            "<color>",
            "<string>",
            "<text-emphasis-style>",
        ],
        "text-emphasis-color": [
            "<color>",
        ],
        "text-emphasis-position": ["left", "over", "right", "under"],
        "text-emphasis-style": ["<string>", "<text-emphasis-style>"],
        "text-indent": ["<calc>", "hanging", "each-line"],
        "text-justify": [
            "auto",
            "distribute",
            "distribute-all-lines",
            "inter-character",
            "inter-cluster",
            "inter-ideograph",
            "inter-word",
            "kashida",
            "newspaper",
            "none",
        ],
        "text-orientation": ["mixed", "upright", "sideways", "use-glyph-orientation"],
        "text-overflow": ["<string>", "clip", "ellipsis"],
        "text-rendering": [
            "auto",
            "optimizeSpeed",
            "optimizeLegibility",
            "geometricPrecision",
        ],
        "text-shadow": ["<color>", "none"],
        "text-size-adjust": ["<calc>", "auto", "none"],
        "text-transform": [
            "capitalize",
            "full-size-kana",
            "full-width",
            "uppercase",
            "lowercase",
            "none",
        ],
        "text-underline-offset": ["<calc>", "auto"],
        "text-underline-position": ["auto", "under", "left", "right"],
        "top": ["<calc>", "auto"],
        "touch-action": [
            "auto",
            "cross-slide-x",
            "cross-slide-y",
            "double-tap-zoom",
            "manipulation",
            "none",
            "pan-down",
            "pan-left",
            "pan-right",
            "pan-up",
            "pan-x",
            "pan-y",
            "pinch-zoom",
        ],
        "transform": [
            "none",
            ["matrix()", "matrix(${1:1}, ${2:1}, ${3:1}, ${4:1}, ${5:2}, ${6:2})"],
            [
                "matrix3d()",
                "matrix3d(${1:1}, ${2:1}, ${3:0}, ${4:0}, ${5:1}, ${6:1}, ${7:0}, ${8:0}, ${9:0}, ${10:0}, ${11:1}, ${12:0}, ${13:2}, ${14:2}, ${15:0}, ${16:1})",
            ],
            ["perspective()", "perspective(${1:0})"],
            ["rotate()", "rotate(${1:45deg})"],
            ["rotate3d()", "rotate3d(${1:0}, ${2:0}, ${3:1}, ${4:45deg})"],
            ["rotateX()", "rotateX(${1:45deg})"],
            ["rotateY()", "rotateY(${1:45deg})"],
            ["rotateZ()", "rotateZ(${1:45deg})"],
            ["scale()", "scale(${1:1.0})"],
            ["scale3d()", "scale3d(${1:1.0}, ${2:1.0}, ${3:1.0})"],
            ["scaleX()", "scaleX(${1:1.0})"],
            ["scaleY()", "scaleY(${1:1.0})"],
            ["scaleZ()", "scaleZ(${1:1.0})"],
            ["skew()", "skew(${1:10deg})"],
            ["skewX()", "skewX(${1:10deg})"],
            ["skewY()", "skewY(${1:10deg})"],
            ["translate()", "translate(${1:10px})"],
            ["translate3d()", "translate3d(${1:10px}, ${2:0px}, ${3:0px})"],
            ["translateX()", "translateX(${1:10px})"],
            ["translateY()", "translateY(${1:10px})"],
            ["translateZ()", "translateZ(${1:10px})"],
        ],
        "transform-box": [
            "border-box",
            "content-box",
            "fill-box",
            "stroke-box",
            "view-box",
        ],
        "transform-origin": ["<calc>", "<position>"],
        "transform-style": ["preserve-3d", "flat"],
        "transition": [
            "<calc>",
            "<timing>",
            "all",
            "none",
        ],
        "transition-delay": [
            "<calc>",
        ],
        "transition-duration": [
            "<calc>",
        ],
        "transition-property": [
            "all",
            "none",
        ],
        "transition-timing-function": ["<calc>", "<timing>"],
        "translate": ["<calc>", "none"],
        "unicode-bidi": [
            "bidi-override" "embed",
            "isolate",
            "isolate-override",
            "normal",
            "plaintext",
        ],
        "unicode-range": [],
        "user-select": ["all", "auto", "text", "none", "contain"],
        "user-zoom": ["fixed", "zoom"],
        "vertical-align": [
            "<calc>",
            "baseline",
            "sub",
            "super",
            "text-top",
            "text-bottom",
            "middle",
            "top",
            "bottom",
        ],
        "viewport-fit": ["auto", "contain", "cover"],
        "visibility": ["visible", "hidden", "collapse"],
        "white-space": [
            "break-spaces",
            "normal",
            "pre",
            "nowrap",
            "pre-wrap",
            "pre-line",
        ],
        "widows": [
            "<calc>",
        ],
        "width": ["<calc>", "auto", "fit-content"],
        "will-change": [
            "auto",
            "contents",
            "scroll-position",
        ],
        "word-break": ["normal", "break-all", "break-word", "keep-all"],
        "word-spacing": [
            "<calc>",
            "normal",
        ],
        "word-wrap": ["normal", "break-word"],
        "writing-mode": [
            "horizontal-tb",
            "vertical-rl",
            "vertical-lr",
            "sideways-rl",
            "sideways-lr",
        ],
        "z-index": [
            "<calc>",
            "auto",
        ],
        "zoom": ["<calc>", "auto", "normal", "reset"],
    }


for_all = [
    'inherit',
    'initial',
    'revert',
    'revert-layer',
    'unset',
    'var()',
    '!important'
    ]


# pre-process keys which have " | " separators
for k in props.copy(): # copy() is required
    if ' | ' in k:
        val = props[k]
        del props[k]
        for kk in k.split(' | '):
            props[kk] = val


def get_data(name):
    #get list of properties
    if not name:
        return list(props.keys())

    #get list of values for property
    r = []
    values = props.get(name, [])
    for val in values:
        if type(val) is str:
            if val.startswith('<') and val.endswith('>'):
                more = common_values.get(val[1:-1], [])
                for m in more:
                    if type(m) is str:
                        r.append(m)
                    elif type(m) is list:
                        r.append(m[0])
            else:
                r.append(val)
        elif type(val) is list:
            r.append(val[0])
    r += for_all
    return r
