/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.repackage.buildcraft.lib.expression;

import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.ExpressionDebugManager;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.IConstantNode;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.IExpressionNode;
import java.util.function.BiFunction;
import java.util.function.Function;

public class NodeInliningHelper {
    public static <F extends IExpressionNode, T extends IExpressionNode> T tryInline(T node, F subNode, Function<F, T> changer, Function<F, T> inlinedChanger) {
        ExpressionDebugManager.debugStart("Inlining " + node);
        IExpressionNode subInlined = subNode.inline();
        if (subInlined instanceof IConstantNode) {
            IExpressionNode to = (IExpressionNode)inlinedChanger.apply(subInlined);
            ExpressionDebugManager.debugEnd("Fully inlined to " + to);
            return (T)to;
        }
        if (subInlined == subNode) {
            ExpressionDebugManager.debugEnd("Unable to inline at all!");
            return node;
        }
        IExpressionNode to = (IExpressionNode)changer.apply(subInlined);
        ExpressionDebugManager.debugEnd("Partially inlined to " + to);
        return (T)to;
    }

    public static <L extends IExpressionNode, R extends IExpressionNode, T extends IExpressionNode> T tryInline(T node, L subNodeLeft, R subNodeRight, BiFunction<L, R, T> changer, BiFunction<L, R, T> inlinedChanger) {
        ExpressionDebugManager.debugStart("Inlining " + node);
        IExpressionNode leftInlined = subNodeLeft.inline();
        IExpressionNode rightInlined = subNodeRight.inline();
        if (leftInlined instanceof IConstantNode && rightInlined instanceof IConstantNode) {
            IExpressionNode to = (IExpressionNode)inlinedChanger.apply(leftInlined, rightInlined);
            ExpressionDebugManager.debugEnd("Fully inlined to " + to);
            return (T)to;
        }
        if (leftInlined == subNodeLeft && rightInlined == subNodeRight) {
            ExpressionDebugManager.debugEnd("Unable to inline at all!");
            return node;
        }
        IExpressionNode to = (IExpressionNode)changer.apply(leftInlined, rightInlined);
        ExpressionDebugManager.debugEnd("Partially inlined to " + to);
        return (T)to;
    }

    public static <A extends IExpressionNode, B extends IExpressionNode, C extends IExpressionNode, R extends IExpressionNode> R tryInline(R node, A nodeA, B nodeB, C nodeC, TriFunction<A, B, C, R> changer, TriFunction<A, B, C, R> inlinedChanger) {
        ExpressionDebugManager.debugStart("Inlining " + node);
        IExpressionNode inlinedA = nodeA.inline();
        IExpressionNode inlinedB = nodeB.inline();
        IExpressionNode inlinedC = nodeC.inline();
        if (inlinedA instanceof IConstantNode && inlinedB instanceof IConstantNode && inlinedC instanceof IConstantNode) {
            IExpressionNode to = (IExpressionNode)inlinedChanger.apply(inlinedA, inlinedB, inlinedC);
            ExpressionDebugManager.debugEnd("Fully inlined to " + to);
            return (R)to;
        }
        if (inlinedA == nodeA && inlinedB == nodeB && inlinedC == nodeC) {
            ExpressionDebugManager.debugEnd("Unable to inline at all!");
            return node;
        }
        IExpressionNode to = (IExpressionNode)changer.apply(inlinedA, inlinedB, inlinedC);
        ExpressionDebugManager.debugEnd("Partially inlined to " + to);
        return (R)to;
    }

    public static <A extends IExpressionNode, B extends IExpressionNode, C extends IExpressionNode, D extends IExpressionNode, R extends IExpressionNode> R tryInline(R node, A nodeA, B nodeB, C nodeC, D nodeD, QuadFunction<A, B, C, D, R> changer, QuadFunction<A, B, C, D, R> inlinedChanger) {
        ExpressionDebugManager.debugStart("Inlining " + node);
        IExpressionNode inlinedA = nodeA.inline();
        IExpressionNode inlinedB = nodeB.inline();
        IExpressionNode inlinedC = nodeC.inline();
        IExpressionNode inlinedD = nodeD.inline();
        if (inlinedA instanceof IConstantNode && inlinedB instanceof IConstantNode && inlinedC instanceof IConstantNode && inlinedD instanceof IConstantNode) {
            IExpressionNode to = (IExpressionNode)inlinedChanger.apply(inlinedA, inlinedB, inlinedC, inlinedD);
            ExpressionDebugManager.debugEnd("Fully inlined to " + to);
            return (R)to;
        }
        if (inlinedA == nodeA && inlinedB == nodeB && inlinedC == nodeC && inlinedD == nodeD) {
            ExpressionDebugManager.debugEnd("Unable to inline at all!");
            return node;
        }
        IExpressionNode to = (IExpressionNode)changer.apply(inlinedA, inlinedB, inlinedC, inlinedD);
        ExpressionDebugManager.debugEnd("Partially inlined to " + to);
        return (R)to;
    }

    public static <A extends IExpressionNode, B extends IExpressionNode, C extends IExpressionNode, D extends IExpressionNode, E extends IExpressionNode, R extends IExpressionNode> R tryInline(R node, A nodeA, B nodeB, C nodeC, D nodeD, E nodeE, PentaFunction<A, B, C, D, E, R> changer, PentaFunction<A, B, C, D, E, R> inlinedChanger) {
        ExpressionDebugManager.debugStart("Inlining " + node);
        IExpressionNode inlinedA = nodeA.inline();
        IExpressionNode inlinedB = nodeB.inline();
        IExpressionNode inlinedC = nodeC.inline();
        IExpressionNode inlinedD = nodeD.inline();
        IExpressionNode inlinedE = nodeE.inline();
        if (inlinedA instanceof IConstantNode && inlinedB instanceof IConstantNode && inlinedC instanceof IConstantNode && inlinedD instanceof IConstantNode && inlinedE instanceof IConstantNode) {
            IExpressionNode to = (IExpressionNode)inlinedChanger.apply(inlinedA, inlinedB, inlinedC, inlinedD, inlinedE);
            ExpressionDebugManager.debugEnd("Fully inlined to " + to);
            return (R)to;
        }
        if (inlinedA == nodeA && inlinedB == nodeB && inlinedC == nodeC && inlinedD == nodeD && inlinedE == nodeE) {
            ExpressionDebugManager.debugEnd("Unable to inline at all!");
            return node;
        }
        IExpressionNode to = (IExpressionNode)changer.apply(inlinedA, inlinedB, inlinedC, inlinedD, inlinedE);
        ExpressionDebugManager.debugEnd("Partially inlined to " + to);
        return (R)to;
    }

    public static interface PentaFunction<A, B, C, D, E, R> {
        public R apply(A var1, B var2, C var3, D var4, E var5);
    }

    public static interface QuadFunction<A, B, C, D, R> {
        public R apply(A var1, B var2, C var3, D var4);
    }

    public static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3);
    }
}

