/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.condition;

import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.ExpressionDebugManager;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.IConstantNode;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.IExpressionNode;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.value.NodeConstantObject;

public class NodeConditionalObject<T>
implements IExpressionNode.INodeObject<T> {
    private final IExpressionNode.INodeBoolean condition;
    private final IExpressionNode.INodeObject<T> ifTrue;
    private final IExpressionNode.INodeObject<T> ifFalse;

    public NodeConditionalObject(IExpressionNode.INodeBoolean condition, IExpressionNode.INodeObject<T> ifTrue, IExpressionNode.INodeObject<T> ifFalse) {
        this.condition = condition;
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
    }

    @Override
    public Class<T> getType() {
        return this.ifTrue.getType();
    }

    @Override
    public T evaluate() {
        return this.condition.evaluate() ? this.ifTrue.evaluate() : this.ifFalse.evaluate();
    }

    @Override
    public IExpressionNode.INodeObject<T> inline() {
        ExpressionDebugManager.debugStart("Inlining " + this);
        IExpressionNode.INodeBoolean c = this.condition.inline();
        NodeConstantObject<T> t = this.ifTrue.inline();
        IExpressionNode f = this.ifFalse.inline();
        if (c instanceof IConstantNode) {
            boolean cc = c.evaluate();
            IExpressionNode val = cc ? (t instanceof IConstantNode ? new NodeConstantObject<T>(this.getType(), t.evaluate()) : t) : (f instanceof IConstantNode ? new NodeConstantObject<T>(this.getType(), f.evaluate()) : f);
            ExpressionDebugManager.debugEnd("Fully inlined to " + val);
            return val;
        }
        if (c != this.condition || t != this.ifTrue || f != this.ifFalse) {
            NodeConditionalObject<T> val = new NodeConditionalObject<T>(c, t, f);
            ExpressionDebugManager.debugEnd("Partially inlined to " + val);
            return val;
        }
        ExpressionDebugManager.debugEnd("Unable to inline at all!");
        return this;
    }

    public String toString() {
        return "(" + this.condition + ") ? (" + this.ifTrue + ") : (" + this.ifFalse + ")";
    }
}

