//CUTSCENE GRAPHICS NEXT GEN

function saveUserSettingsCutsceneMod(): array<string>
{
	var ICG_userSettings : array<string>;
	
	var ingameConfigWrapper : CInGameConfigWrapper;
	var groupVarsNum : int;
	var i : int;
	var setting : name;
	
	ingameConfigWrapper = theGame.GetInGameConfigWrapper();
	groupVarsNum = ingameConfigWrapper.GetVarsNumByGroupName('Graphics');
	
	ICG_userSettings.Resize(groupVarsNum);
	for (i = 0; i < groupVarsNum; i += 1)
	{
		setting = ingameConfigWrapper.GetVarNameByGroupName('Graphics', i);

		ICG_userSettings[i] = 
			ingameConfigWrapper.GetVarValue('Graphics', setting);
	}
	return ICG_userSettings;
}

		
function applyCustomSettingsCutsceneMod() 
{
	//AA
	var AAMode_mod , FSRQuality_mod , DLSSQuality_mod  : string;
	//RT GRAPHICS
	var EnableRT_mod , RTGIPreset_mod , EnableRtRadiance_mod , RtShadows_mod , RTAOEnabled_mod  : string;
	//Postprocessing
	var AllowMotionBlur_mod , AllowBlur_mod , AllowBloom_mod , AllowDOF_mod , AllowChromaticAberration_mod , 
	AllowVignette_mod , AllowShafts_mod , AllowLensEffects_mod :string;
	
	var ingameConfigWrapper : CInGameConfigWrapper;
	ingameConfigWrapper = theGame.GetInGameConfigWrapper();
	
	if(theGame.GetInGameConfigWrapper().GetVarValue('CutsceneGraphicsNG', 'EnableMod'))
	{		
		//Get values from mod menu xml
		EnableRT_mod 					= theGame.GetInGameConfigWrapper().GetVarValue('CutsceneGraphicsNG', 'EnableRT_mod');
		RTGIPreset_mod 					= theGame.GetInGameConfigWrapper().GetVarValue('CutsceneGraphicsNG', 'RTGIPreset_mod');
		EnableRtRadiance_mod			= theGame.GetInGameConfigWrapper().GetVarValue('CutsceneGraphicsNG', 'EnableRtRadiance_mod');
		RtShadows_mod					= theGame.GetInGameConfigWrapper().GetVarValue('CutsceneGraphicsNG', 'RtShadows_mod');
		RTAOEnabled_mod 				= theGame.GetInGameConfigWrapper().GetVarValue('CutsceneGraphicsNG', 'RTAOEnabled_mod');		
		AAMode_mod 						= theGame.GetInGameConfigWrapper().GetVarValue('CutsceneGraphicsNG', 'AAMode_mod');
		FSRQuality_mod					= theGame.GetInGameConfigWrapper().GetVarValue('CutsceneGraphicsNG', 'FSRQuality_mod');
		DLSSQuality_mod					= theGame.GetInGameConfigWrapper().GetVarValue('CutsceneGraphicsNG', 'DLSSQuality_mod');	
		AllowMotionBlur_mod				= theGame.GetInGameConfigWrapper().GetVarValue('CutsceneGraphicsNG', 'AllowMotionBlur_mod');
		AllowBlur_mod					= theGame.GetInGameConfigWrapper().GetVarValue('CutsceneGraphicsNG', 'AllowBlur_mod');
		AllowBloom_mod					= theGame.GetInGameConfigWrapper().GetVarValue('CutsceneGraphicsNG', 'AllowBloom_mod');
		AllowDOF_mod					= theGame.GetInGameConfigWrapper().GetVarValue('CutsceneGraphicsNG', 'AllowDOF_mod');
		AllowChromaticAberration_mod	= theGame.GetInGameConfigWrapper().GetVarValue('CutsceneGraphicsNG', 'AllowChromaticAberration_mod');
		AllowVignette_mod				= theGame.GetInGameConfigWrapper().GetVarValue('CutsceneGraphicsNG', 'AllowVignette_mod');
		AllowShafts_mod					= theGame.GetInGameConfigWrapper().GetVarValue('CutsceneGraphicsNG', 'AllowShafts_mod');
		AllowLensEffects_mod			= theGame.GetInGameConfigWrapper().GetVarValue('CutsceneGraphicsNG', 'AllowLensEffects_mod');
		
		//Apply changes to graphics
		ingameConfigWrapper.SetVarValue('Graphics', 'EnableRT'          		, EnableRT_mod );
		ingameConfigWrapper.SetVarValue('Graphics', 'RTGIPreset'        		, RTGIPreset_mod );
		ingameConfigWrapper.SetVarValue('Graphics', 'EnableRtRadiance'  		, EnableRtRadiance_mod  );
		ingameConfigWrapper.SetVarValue('Graphics', 'Shadows'           		, RtShadows_mod  );
		ingameConfigWrapper.SetVarValue('Graphics', 'RTAOEnabled'       		, RTAOEnabled_mod  );
		ingameConfigWrapper.SetVarValue('Graphics', 'AAMode'            		, AAMode_mod );
		ingameConfigWrapper.SetVarValue('Graphics', 'FSRQuality'       			, FSRQuality_mod );
		ingameConfigWrapper.SetVarValue('Graphics', 'DLSSQuality'       		, DLSSQuality_mod );
		ingameConfigWrapper.SetVarValue('Graphics', 'AllowMotionBlur'       	, AllowMotionBlur_mod );
		ingameConfigWrapper.SetVarValue('Graphics', 'AllowBlur'       			, AllowBlur_mod );
		ingameConfigWrapper.SetVarValue('Graphics', 'AllowBloom'       			, AllowBloom_mod );
		ingameConfigWrapper.SetVarValue('Graphics', 'AllowDOF'       			, AllowDOF_mod );
		ingameConfigWrapper.SetVarValue('Graphics', 'AllowChromaticAberration'	, AllowChromaticAberration_mod );
		ingameConfigWrapper.SetVarValue('Graphics', 'AllowVignette'       		, AllowVignette_mod );
		ingameConfigWrapper.SetVarValue('Graphics', 'AllowShafts'       		, AllowShafts_mod );
		ingameConfigWrapper.SetVarValue('Graphics', 'AllowLensEffects'       	, AllowLensEffects_mod );
	}
}

function revertBackUserSettingsCutsceneMod(ICG_userSettings : array<string>) 
{
	var ingameConfigWrapper : CInGameConfigWrapper;
	var groupVarsNum : int;
	var i : int;
	var setting : name;
	ingameConfigWrapper = theGame.GetInGameConfigWrapper();
	
	if(theGame.GetInGameConfigWrapper().GetVarValue('CutsceneGraphicsNG', 'EnableMod'))
	{
		groupVarsNum = ingameConfigWrapper.GetVarsNumByGroupName('Graphics');
		
		for (i = 0; i < groupVarsNum; i += 1)
		{
			setting = ingameConfigWrapper.GetVarNameByGroupName('Graphics', i);
			ingameConfigWrapper.SetVarValue('Graphics', setting, ICG_userSettings[i]);
		}
	}
}