/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import org.irods.jargon.core.connection.AbstractIRODSMidLevelProtocol;
import org.irods.jargon.core.connection.IRODSServerProperties;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentalInfoAccessor {
    private AbstractIRODSMidLevelProtocol irodsProtocol = null;
    private final Logger log = LoggerFactory.getLogger(EnvironmentalInfoAccessor.class);

    public EnvironmentalInfoAccessor(AbstractIRODSMidLevelProtocol irodsProtocol) throws JargonException {
        if (irodsProtocol == null) {
            throw new JargonException("null irodsProtocol");
        }
        if (!irodsProtocol.isConnected()) {
            throw new JargonException("irods protocol is not connected");
        }
        this.irodsProtocol = irodsProtocol;
    }

    public IRODSServerProperties getIRODSServerProperties() throws JargonException {
        IRODSServerProperties cached;
        this.log.info("getting irods server properties");
        this.log.debug("checking for cached properties...");
        if (this.irodsProtocol.getIrodsSession() != null && (cached = this.irodsProtocol.getIrodsSession().getDiscoveredServerPropertiesCache().retrieveIRODSServerProperties(this.irodsProtocol.getIrodsAccount().getHost(), this.irodsProtocol.getIrodsAccount().getZone())) != null) {
            this.log.info("returning cached props:{}", (Object)cached);
            return cached;
        }
        Tag response = this.irodsProtocol.irodsFunction("RODS_API_REQ", "", 700);
        this.log.info("server response obtained");
        int serverType = response.getTag("serverType").getIntValue();
        IRODSServerProperties.IcatEnabled icatEnabled = null;
        icatEnabled = serverType == 1 ? IRODSServerProperties.IcatEnabled.ICAT_ENABLED : IRODSServerProperties.IcatEnabled.NO_ICAT;
        int serverBootTime = response.getTag("serverBootTime").getIntValue();
        String relVersion = response.getTag("relVersion").getStringValue();
        String apiVersion = response.getTag("apiVersion").getStringValue();
        String rodsZone = response.getTag("rodsZone").getStringValue();
        IRODSServerProperties props = IRODSServerProperties.instance(icatEnabled, serverBootTime, relVersion, apiVersion, rodsZone);
        if (this.irodsProtocol.getIrodsSession() != null) {
            this.irodsProtocol.getIrodsSession().getDiscoveredServerPropertiesCache().cacheIRODSServerProperties(this.irodsProtocol.getIrodsAccount().getHost(), this.irodsProtocol.getIrodsAccount().getZone(), props);
            this.log.debug("cached the props for host and zone:{}", (Object)props);
        }
        return props;
    }
}

