/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import org.irods.jargon.core.connection.ClientServerNegotiationPolicy;
import org.irods.jargon.core.connection.JargonProperties;
import org.irods.jargon.core.protovalues.EncryptionAlgorithmEnum;

public class PipelineConfiguration {
    private final int irodsSocketTimeout;
    private final int irodsParallelSocketTimeout;
    private final int internalInputStreamBufferSize;
    private final int internalOutputStreamBufferSize;
    private final int internalCacheBufferSize;
    private final int sendInputStreamBufferSize;
    private final int localFileInputStreamBufferSize;
    private final int localFileOutputStreamBufferSize;
    private final String defaultEncoding;
    private final int inputToOutputCopyBufferByteSize;
    private final boolean reconnect;
    private final boolean instrument;
    private final boolean forcePamFlush;
    private final boolean parallelTcpKeepAlive;
    private final int parallelTcpSendWindowSize;
    private final int parallelTcpReceiveWindowSize;
    private final int parallelTcpPerformancePrefsConnectionTime;
    private final int parallelTcpPerformancePrefsLatency;
    private final int parallelTcpPerformancePrefsBandwidth;
    private final boolean primaryTcpKeepAlive;
    private final int primaryTcpSendWindowSize;
    private final int primaryTcpReceiveWindowSize;
    private final int primaryTcpPerformancePrefsConnectionTime;
    private final int primaryTcpPerformancePrefsLatency;
    private final int primaryTcpPerformancePrefsBandwidth;
    private final int socketRenewalIntervalInSeconds;
    private final ClientServerNegotiationPolicy.SslNegotiationPolicy negotiationPolicy;
    private final EncryptionAlgorithmEnum encryptionAlgorithmEnum;
    private final int encryptionKeySize;
    private final int encryptionSaltSize;
    private final int encryptionNumberHashRounds;

    public static PipelineConfiguration instance(JargonProperties jargonProperties) {
        return new PipelineConfiguration(jargonProperties);
    }

    private PipelineConfiguration(JargonProperties jargonProperties) {
        if (jargonProperties == null) {
            throw new IllegalArgumentException("null jargonProperties");
        }
        this.irodsSocketTimeout = jargonProperties.getIRODSSocketTimeout();
        this.irodsParallelSocketTimeout = jargonProperties.getIRODSParallelTransferSocketTimeout();
        this.internalInputStreamBufferSize = jargonProperties.getInternalInputStreamBufferSize();
        this.internalOutputStreamBufferSize = jargonProperties.getInternalOutputStreamBufferSize();
        this.internalCacheBufferSize = jargonProperties.getInternalCacheBufferSize();
        this.sendInputStreamBufferSize = jargonProperties.getSendInputStreamBufferSize();
        this.localFileInputStreamBufferSize = jargonProperties.getLocalFileInputStreamBufferSize();
        this.localFileOutputStreamBufferSize = jargonProperties.getLocalFileOutputStreamBufferSize();
        this.inputToOutputCopyBufferByteSize = jargonProperties.getInputToOutputCopyBufferByteSize();
        this.instrument = jargonProperties.isInstrument();
        this.reconnect = jargonProperties.isReconnect();
        this.defaultEncoding = jargonProperties.getEncoding();
        this.forcePamFlush = jargonProperties.isForcePamFlush();
        this.parallelTcpKeepAlive = jargonProperties.isParallelTcpKeepAlive();
        this.parallelTcpPerformancePrefsBandwidth = jargonProperties.getParallelTcpPerformancePrefsBandwidth();
        this.parallelTcpPerformancePrefsConnectionTime = jargonProperties.getParallelTcpPerformancePrefsConnectionTime();
        this.parallelTcpPerformancePrefsLatency = jargonProperties.getParallelTcpPerformancePrefsLatency();
        this.parallelTcpReceiveWindowSize = jargonProperties.getParallelTcpReceiveWindowSize();
        this.parallelTcpSendWindowSize = jargonProperties.getParallelTcpSendWindowSize();
        this.primaryTcpKeepAlive = jargonProperties.isPrimaryTcpKeepAlive();
        this.primaryTcpPerformancePrefsBandwidth = jargonProperties.getPrimaryTcpPerformancePrefsBandwidth();
        this.primaryTcpPerformancePrefsConnectionTime = jargonProperties.getPrimaryTcpPerformancePrefsConnectionTime();
        this.primaryTcpPerformancePrefsLatency = jargonProperties.getPrimaryTcpPerformancePrefsLatency();
        this.primaryTcpReceiveWindowSize = jargonProperties.getPrimaryTcpReceiveWindowSize();
        this.primaryTcpSendWindowSize = jargonProperties.getPrimaryTcpSendWindowSize();
        this.socketRenewalIntervalInSeconds = jargonProperties.getSocketRenewalIntervalInSeconds();
        this.negotiationPolicy = jargonProperties.getNegotiationPolicy();
        this.encryptionAlgorithmEnum = jargonProperties.getEncryptionAlgorithmEnum();
        this.encryptionKeySize = jargonProperties.getEncryptionKeySize();
        this.encryptionNumberHashRounds = jargonProperties.getEncryptionNumberHashRounds();
        this.encryptionSaltSize = jargonProperties.getEncryptionSaltSize();
    }

    public int getInternalInputStreamBufferSize() {
        return this.internalInputStreamBufferSize;
    }

    public int getInternalOutputStreamBufferSize() {
        return this.internalOutputStreamBufferSize;
    }

    public int getInternalCacheBufferSize() {
        return this.internalCacheBufferSize;
    }

    public int getSendInputStreamBufferSize() {
        return this.sendInputStreamBufferSize;
    }

    public int getLocalFileOutputStreamBufferSize() {
        return this.localFileOutputStreamBufferSize;
    }

    public int getIrodsSocketTimeout() {
        return this.irodsSocketTimeout;
    }

    public int getIrodsParallelSocketTimeout() {
        return this.irodsParallelSocketTimeout;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public int getInputToOutputCopyBufferByteSize() {
        return this.inputToOutputCopyBufferByteSize;
    }

    public int getLocalFileInputStreamBufferSize() {
        return this.localFileInputStreamBufferSize;
    }

    public boolean isReconnect() {
        return this.reconnect;
    }

    public boolean isInstrument() {
        return this.instrument;
    }

    synchronized boolean isForcePamFlush() {
        return this.forcePamFlush;
    }

    public boolean isParallelTcpKeepAlive() {
        return this.parallelTcpKeepAlive;
    }

    public int getParallelTcpSendWindowSize() {
        return this.parallelTcpSendWindowSize;
    }

    public int getParallelTcpReceiveWindowSize() {
        return this.parallelTcpReceiveWindowSize;
    }

    public int getParallelTcpPerformancePrefsConnectionTime() {
        return this.parallelTcpPerformancePrefsConnectionTime;
    }

    public int getParallelTcpPerformancePrefsLatency() {
        return this.parallelTcpPerformancePrefsLatency;
    }

    public int getParallelTcpPerformancePrefsBandwidth() {
        return this.parallelTcpPerformancePrefsBandwidth;
    }

    public boolean isPrimaryTcpKeepAlive() {
        return this.primaryTcpKeepAlive;
    }

    public int getPrimaryTcpSendWindowSize() {
        return this.primaryTcpSendWindowSize;
    }

    public int getPrimaryTcpReceiveWindowSize() {
        return this.primaryTcpReceiveWindowSize;
    }

    public int getPrimaryTcpPerformancePrefsConnectionTime() {
        return this.primaryTcpPerformancePrefsConnectionTime;
    }

    public int getPrimaryTcpPerformancePrefsLatency() {
        return this.primaryTcpPerformancePrefsLatency;
    }

    public int getPrimaryTcpPerformancePrefsBandwidth() {
        return this.primaryTcpPerformancePrefsBandwidth;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PipelineConfiguration [irodsSocketTimeout=");
        builder.append(this.irodsSocketTimeout);
        builder.append(", irodsParallelSocketTimeout=");
        builder.append(this.irodsParallelSocketTimeout);
        builder.append(", internalInputStreamBufferSize=");
        builder.append(this.internalInputStreamBufferSize);
        builder.append(", internalOutputStreamBufferSize=");
        builder.append(this.internalOutputStreamBufferSize);
        builder.append(", internalCacheBufferSize=");
        builder.append(this.internalCacheBufferSize);
        builder.append(", sendInputStreamBufferSize=");
        builder.append(this.sendInputStreamBufferSize);
        builder.append(", localFileInputStreamBufferSize=");
        builder.append(this.localFileInputStreamBufferSize);
        builder.append(", localFileOutputStreamBufferSize=");
        builder.append(this.localFileOutputStreamBufferSize);
        builder.append(", ");
        if (this.defaultEncoding != null) {
            builder.append("defaultEncoding=");
            builder.append(this.defaultEncoding);
            builder.append(", ");
        }
        builder.append("inputToOutputCopyBufferByteSize=");
        builder.append(this.inputToOutputCopyBufferByteSize);
        builder.append(", reconnect=");
        builder.append(this.reconnect);
        builder.append(", instrument=");
        builder.append(this.instrument);
        builder.append(", forcePamFlush=");
        builder.append(this.forcePamFlush);
        builder.append(", parallelTcpKeepAlive=");
        builder.append(this.parallelTcpKeepAlive);
        builder.append(", parallelTcpSendWindowSize=");
        builder.append(this.parallelTcpSendWindowSize);
        builder.append(", parallelTcpReceiveWindowSize=");
        builder.append(this.parallelTcpReceiveWindowSize);
        builder.append(", parallelTcpPerformancePrefsConnectionTime=");
        builder.append(this.parallelTcpPerformancePrefsConnectionTime);
        builder.append(", parallelTcpPerformancePrefsLatency=");
        builder.append(this.parallelTcpPerformancePrefsLatency);
        builder.append(", parallelTcpPerformancePrefsBandwidth=");
        builder.append(this.parallelTcpPerformancePrefsBandwidth);
        builder.append(", primaryTcpKeepAlive=");
        builder.append(this.primaryTcpKeepAlive);
        builder.append(", primaryTcpSendWindowSize=");
        builder.append(this.primaryTcpSendWindowSize);
        builder.append(", primaryTcpReceiveWindowSize=");
        builder.append(this.primaryTcpReceiveWindowSize);
        builder.append(", primaryTcpPerformancePrefsConnectionTime=");
        builder.append(this.primaryTcpPerformancePrefsConnectionTime);
        builder.append(", primaryTcpPerformancePrefsLatency=");
        builder.append(this.primaryTcpPerformancePrefsLatency);
        builder.append(", primaryTcpPerformancePrefsBandwidth=");
        builder.append(this.primaryTcpPerformancePrefsBandwidth);
        builder.append(", socketRenewalIntervalInSeconds=");
        builder.append(this.socketRenewalIntervalInSeconds);
        builder.append("]");
        return builder.toString();
    }

    public int getSocketRenewalIntervalInSeconds() {
        return this.socketRenewalIntervalInSeconds;
    }

    public ClientServerNegotiationPolicy.SslNegotiationPolicy getNegotiationPolicy() {
        return this.negotiationPolicy;
    }

    public EncryptionAlgorithmEnum getEncryptionAlgorithmEnum() {
        return this.encryptionAlgorithmEnum;
    }

    public int getEncryptionKeySize() {
        return this.encryptionKeySize;
    }

    public int getEncryptionSaltSize() {
        return this.encryptionSaltSize;
    }

    public int getEncryptionNumberHashRounds() {
        return this.encryptionNumberHashRounds;
    }
}

