/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AbstractIRODSPackingInstruction;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.rule.IRODSRule;
import org.irods.jargon.core.rule.IRODSRuleParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecMyRuleInp
extends AbstractIRODSPackingInstruction {
    public static final String PI_TAG = "ExecMyRuleInp_PI";
    public static final String MS_PARAM_ARRAY_PI = "MsParamArray_PI";
    public static final int RULE_API_NBR = 625;
    public static final String MY_RULE = "myRule";
    public static final String RHOSTADDR_PI = "RHostAddr_PI";
    public static final String HOST_ADDR = "hostAddr";
    public static final String PORT = "port";
    public static final String DUMMY_INT = "dummyInt";
    public static final String RODS_ZONE = "rodsZone";
    public static final String OUT_PARAM_DESC = "outParamDesc";
    public static final String PARAM_LEN = "paramLen";
    public static final String OPR_TYPE = "oprType";
    public static final String LABEL = "label";
    public static final String TYPE = "type";
    public static final String INT_PI = "INT_PI";
    public static final String BUF_LEN_PI = "BUF_LEN_PI";
    public static final String BUF_LEN = "buflen";
    public static final String BUF = "buf";
    public static final String STR_PI = "STR_PI";
    public static final String MY_INT = "myInt";
    public static final String MY_STR = "myStr";
    private final transient IRODSRule irodsRule;
    private final transient String host;
    private final transient int port;
    private final transient String zone;
    private static final Logger log = LoggerFactory.getLogger(ExecMyRuleInp.class);

    public static final ExecMyRuleInp instanceWithRemoteAttributes(IRODSRule irodsRule, String host, int port, String zone) throws JargonException {
        return new ExecMyRuleInp(irodsRule, host, port, zone);
    }

    public static final ExecMyRuleInp instance(IRODSRule irodsRule) throws JargonException {
        return new ExecMyRuleInp(irodsRule, "", 0, "");
    }

    private ExecMyRuleInp(IRODSRule irodsRule, String host, int port, String zone) throws JargonException {
        if (irodsRule == null) {
            throw new JargonException("null IRODS rule");
        }
        this.irodsRule = irodsRule;
        if (host == null || host.isEmpty()) {
            this.host = "";
            this.port = 0;
            this.zone = "";
        } else {
            if (port <= 1024) {
                throw new JargonException("invalid port number of " + port);
            }
            if (zone == null || zone.isEmpty()) {
                throw new JargonException("null or missing zone when remotely executing the rule");
            }
            this.host = host;
            this.port = port;
            this.zone = zone;
        }
        this.setApiNumber(625);
    }

    @Override
    public Tag getTagValue() throws JargonException {
        Tag message = new Tag(PI_TAG, new Tag[]{new Tag(MY_RULE, this.irodsRule.getRuleBody()), new Tag(RHOSTADDR_PI, new Tag[]{new Tag(HOST_ADDR, this.host), new Tag(RODS_ZONE, this.zone), new Tag(PORT, this.port), new Tag(DUMMY_INT, 0)}), Tag.createKeyValueTag(null)});
        StringBuilder sb = new StringBuilder();
        log.debug("process output parameters");
        String outputParms = this.createTagValsForRuleOutputParams(sb);
        log.debug("rule output parms: {}", (Object)outputParms);
        message.addTag(new Tag(OUT_PARAM_DESC, outputParms));
        log.debug("processing rule input params");
        Tag paramArray = new Tag(MS_PARAM_ARRAY_PI, new Tag[]{new Tag(PARAM_LEN, this.irodsRule.getIrodsRuleInputParameters().size()), new Tag(OPR_TYPE, 0)});
        for (IRODSRuleParameter irodsRuleInputParameter : this.irodsRule.getIrodsRuleInputParameters()) {
            paramArray.addTag(this.getMsParamArrayTagForInputParameter(irodsRuleInputParameter));
        }
        message.addTag(paramArray);
        return message;
    }

    private Tag getMsParamArrayTagForInputParameter(IRODSRuleParameter irodsRuleInputParameter) {
        log.debug("process input parameter: {}", (Object)irodsRuleInputParameter);
        String type = irodsRuleInputParameter.getType();
        Tag param = new Tag("MsParam_PI", new Tag[]{new Tag(LABEL, irodsRuleInputParameter.getUniqueName()), new Tag(TYPE, irodsRuleInputParameter.getType())});
        if (type.equals(INT_PI)) {
            param.addTag(new Tag(INT_PI, new Tag[]{new Tag(MY_INT, irodsRuleInputParameter.getIntValue())}));
        } else if (type.equals(BUF_LEN_PI)) {
            param.addTag(new Tag(BUF_LEN_PI, new Tag[]{new Tag(BUF_LEN, irodsRuleInputParameter.getByteValue().length), new Tag(BUF, new String(irodsRuleInputParameter.getByteValue()))}));
        } else {
            param.addTag(new Tag(STR_PI, new Tag[]{new Tag(MY_STR, irodsRuleInputParameter.getStringValue())}));
        }
        return param;
    }

    private String createTagValsForRuleOutputParams(StringBuilder sb) {
        boolean firstParm = true;
        for (IRODSRuleParameter irodsRuleOutputParameter : this.irodsRule.getIrodsRuleOutputParameters()) {
            if (firstParm) {
                firstParm = false;
            } else {
                sb.append('%');
            }
            sb.append(irodsRuleOutputParameter.getUniqueName());
        }
        return sb.toString();
    }
}

