/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;
import org.irods.jargon.core.connection.EnvironmentalInfoAccessor;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSServerProperties;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.RemoteScriptExecutionException;
import org.irods.jargon.core.pub.EnvironmentalInfoAO;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.RemoteExecutionOfCommandsAO;
import org.irods.jargon.core.pub.RuleProcessingAO;
import org.irods.jargon.core.pub.domain.RemoteCommandInformation;
import org.irods.jargon.core.rule.IRODSRuleExecResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentalInfoAOImpl
extends IRODSGenericAO
implements EnvironmentalInfoAO {
    public static final Logger log = LoggerFactory.getLogger(EnvironmentalInfoAOImpl.class);
    private final EnvironmentalInfoAccessor environmentalInfoAccessor = new EnvironmentalInfoAccessor(this.getIRODSSession().currentConnection(this.getIRODSAccount()));

    protected EnvironmentalInfoAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
    }

    @Override
    public IRODSServerProperties getIRODSServerPropertiesFromIRODSServer() throws JargonException {
        IRODSServerProperties props = this.environmentalInfoAccessor.getIRODSServerProperties();
        return props;
    }

    @Override
    public long getIRODSServerCurrentTime() throws JargonException {
        long timeVal;
        log.info("getIRODSServerCurrentTime");
        StringBuilder sb = new StringBuilder("getIRODSServerCurrentTime||msiGetSystemTime(*Time,null)##writeLine(stdout, *Time)|nop\n");
        sb.append("null\n");
        sb.append("*Time%ruleExecOut");
        RuleProcessingAO ruleProcessingAO = this.getIRODSAccessObjectFactory().getRuleProcessingAO(this.getIRODSAccount());
        IRODSRuleExecResult result = ruleProcessingAO.executeRule(sb.toString());
        String execOut = (String)result.getOutputParameterResults().get("*Time").getResultObject();
        if (execOut == null) {
            throw new JargonException("no time returned from time rule execution");
        }
        log.debug("rule result:{}", (Object)execOut);
        try {
            timeVal = Long.parseLong(execOut) * 1000L;
        }
        catch (NumberFormatException nfe) {
            log.error("error getting time val from *Time in rule results when results were:{}", (Object)result);
            throw new JargonException("error getting time value", nfe);
        }
        return timeVal;
    }

    @Override
    public boolean isAbleToRunSpecificQuery() throws JargonException {
        return this.getIRODSServerProperties().isTheIrodsServerAtLeastAtTheGivenReleaseVersion("rods3.1");
    }

    @Override
    public List<RemoteCommandInformation> listAvailableRemoteCommands() throws DataNotFoundException, JargonException {
        log.info("listAvailableRemoteCommands()");
        ArrayList<RemoteCommandInformation> remoteCommandInformation = new ArrayList<RemoteCommandInformation>();
        RemoteExecutionOfCommandsAO remoteExecutionAO = this.getIRODSAccessObjectFactory().getRemoteExecutionOfCommandsAO(this.getIRODSAccount());
        InputStream result = null;
        StringWriter writer = new StringWriter();
        try {
            result = remoteExecutionAO.executeARemoteCommandAndGetStreamGivingCommandNameAndArgs("listCommands.sh", "");
            IOUtils.copy((InputStream)result, (Writer)writer, (String)this.getJargonProperties().getEncoding());
        }
        catch (RemoteScriptExecutionException rse) {
            throw new DataNotFoundException("no data can be found, listCommands.sh is not installed");
        }
        catch (IOException e) {
            throw new JargonException("IOException processing data", e);
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (IOException iOException) {}
        }
        String rawCommandOutput = writer.toString();
        log.debug("raw command output: {}", (Object)rawCommandOutput);
        StringTokenizer st = new StringTokenizer(rawCommandOutput, "\n");
        RemoteCommandInformation remoteCommandInformationEntry = null;
        String token = null;
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            log.debug(token);
            token = token.trim();
            int trimPoint = token.lastIndexOf(32) + 1;
            String command = token.substring(trimPoint);
            if (command.charAt(0) == '.') continue;
            remoteCommandInformationEntry = new RemoteCommandInformation();
            remoteCommandInformationEntry.setRawData(token);
            remoteCommandInformationEntry.setCommand(command);
            remoteCommandInformationEntry.setHostName(this.getIRODSAccount().getHost());
            remoteCommandInformationEntry.setZone(this.getIRODSAccount().getZone());
            remoteCommandInformation.add(remoteCommandInformationEntry);
        }
        log.info("remote commands:{}", remoteCommandInformation);
        return remoteCommandInformation;
    }

    @Override
    public List<String> listAvailableMicroservices() throws JargonException {
        log.info("listAvailableMicroservices()");
        ArrayList<String> availableMicroservices = new ArrayList<String>();
        if (!this.getIRODSServerProperties().isTheIrodsServerAtLeastAtTheGivenReleaseVersion("rods3.0")) {
            throw new JargonException("service not available on servers prior to rods3.0");
        }
        RuleProcessingAO ruleProcessingAO = this.getIRODSAccessObjectFactory().getRuleProcessingAO(this.getIRODSAccount());
        IRODSRuleExecResult result = ruleProcessingAO.executeRuleFromResource("/rules/rulemsiListEnabledMS.r", null, RuleProcessingAO.RuleProcessingType.EXTERNAL);
        String resultBuff = result.getRuleExecOut().trim();
        log.info("raw microservice list:{}", (Object)resultBuff);
        StringTokenizer st = new StringTokenizer(resultBuff, "\n");
        while (st.hasMoreTokens()) {
            availableMicroservices.add(st.nextToken());
        }
        return availableMicroservices;
    }
}

