/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import org.irods.jargon.core.connection.AbstractIRODSMidLevelProtocol;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSProtocolManager;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.connection.IRODSSimpleProtocolManager;
import org.irods.jargon.core.connection.JargonProperties;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.IRODSAccessObjectFactory;
import org.irods.jargon.core.pub.IRODSAccessObjectFactoryImpl;
import org.irods.jargon.core.pub.io.IRODSFileFactory;
import org.irods.jargon.core.pub.io.IRODSFileFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IRODSFileSystem {
    private final IRODSProtocolManager irodsProtocolManager;
    private final IRODSSession irodsSession;
    private transient IRODSAccessObjectFactory irodsAccessObjectFactory = null;
    private static final Logger log = LoggerFactory.getLogger(IRODSFileSystem.class);

    public static IRODSFileSystem instance() throws JargonException {
        return new IRODSFileSystem();
    }

    public IRODSFileSystem() throws JargonException {
        this.irodsProtocolManager = IRODSSimpleProtocolManager.instance();
        this.irodsSession = IRODSSession.instance(this.irodsProtocolManager);
        log.info("IRODSfileSystem is initialized");
    }

    public IRODSFileSystem(IRODSProtocolManager irodsProtocolManager) throws JargonException {
        if (irodsProtocolManager == null) {
            throw new IllegalArgumentException("null irodsProtocolManager");
        }
        this.irodsProtocolManager = irodsProtocolManager;
        this.irodsSession = IRODSSession.instance(irodsProtocolManager);
        log.info("IRODSfileSystem is initialized");
    }

    public IRODSAccessObjectFactory getIRODSAccessObjectFactory() throws JargonException {
        if (this.irodsAccessObjectFactory == null) {
            this.irodsAccessObjectFactory = IRODSAccessObjectFactoryImpl.instance(this.irodsSession);
        }
        return this.irodsAccessObjectFactory;
    }

    public IRODSFileFactory getIRODSFileFactory(IRODSAccount irodsAccount) throws JargonException {
        return new IRODSFileFactoryImpl(this.irodsSession, irodsAccount);
    }

    public void close() throws JargonException {
        this.irodsSession.closeSession();
    }

    public void closeAndEatExceptions() {
        try {
            this.irodsSession.closeSession();
        }
        catch (Exception e) {
            log.error("exception closing connection, this is logged and ignored", (Throwable)e);
        }
    }

    public void close(IRODSAccount irodsAccount) throws JargonException {
        this.irodsSession.closeSession(irodsAccount);
    }

    public void closeAndEatExceptions(IRODSAccount irodsAccount) {
        try {
            this.irodsSession.closeSession(irodsAccount);
        }
        catch (Exception e) {
            log.error("exception closing connection, this is logged and ignored", (Throwable)e);
        }
    }

    public AbstractIRODSMidLevelProtocol getConnection() {
        return this.irodsSession.getIrodsMidLevelProtocol();
    }

    public IRODSSession getIrodsSession() {
        return this.irodsSession;
    }

    public IRODSProtocolManager getIrodsProtocolManager() {
        return this.irodsProtocolManager;
    }

    public JargonProperties getJargonProperties() {
        return this.getIrodsSession().getJargonProperties();
    }
}

