/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.CollectionNotEmptyException;
import org.irods.jargon.core.exception.CollectionNotMountedException;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.FileNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.UnixFileMkdirException;
import org.irods.jargon.core.packinstr.DataObjInpForMcoll;
import org.irods.jargon.core.packinstr.DataObjInpForUnmount;
import org.irods.jargon.core.packinstr.TransferOptions;
import org.irods.jargon.core.pub.CollectionAndDataObjectListAndSearchAO;
import org.irods.jargon.core.pub.DataTransferOperations;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.MountedCollectionAO;
import org.irods.jargon.core.pub.domain.ObjStat;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.query.CollectionAndDataObjectListingEntry;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MountedCollectionAOImpl
extends IRODSGenericAO
implements MountedCollectionAO {
    public static final Logger log = LoggerFactory.getLogger(MountedCollectionAOImpl.class);

    protected MountedCollectionAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
    }

    @Override
    public boolean unmountACollection(String absolutePathToCollectionToUnmount, String resourceName) throws JargonException {
        log.info("unmountACollection()");
        if (absolutePathToCollectionToUnmount == null || absolutePathToCollectionToUnmount.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePathToCollectionToUnmount");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("null resource name, set to blank if not specified");
        }
        boolean success = true;
        log.info("absolutePathToCollectionToUnmount:{}", (Object)absolutePathToCollectionToUnmount);
        log.info("resourceName:{}", (Object)resourceName);
        DataObjInpForUnmount dataObjInp = DataObjInpForUnmount.instanceForUnmount(absolutePathToCollectionToUnmount, resourceName);
        try {
            this.getIRODSProtocol().irodsFunction(dataObjInp);
        }
        catch (DataNotFoundException e) {
            success = false;
        }
        catch (CollectionNotMountedException e) {
            success = false;
        }
        log.debug("unmount complete, success?:{}", (Object)success);
        this.getIRODSAccessObjectFactory().closeSession(this.getIRODSAccount());
        return success;
    }

    @Override
    public void createASoftLink(String absolutePathToTheIRODSCollectionToBeMounted, String absolutePathToLinkedCollectionToBeCreated) throws FileNotFoundException, CollectionNotEmptyException, JargonException {
        log.info("createASoftLink()");
        if (absolutePathToTheIRODSCollectionToBeMounted == null || absolutePathToTheIRODSCollectionToBeMounted.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePathToTheIRODSCollectionToBeMounted");
        }
        if (absolutePathToLinkedCollectionToBeCreated == null || absolutePathToLinkedCollectionToBeCreated.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePathToLinkedCollectionToBeCreated");
        }
        log.info("absolutePathToTheIRODSCollectionToBeMounted:{}", (Object)absolutePathToTheIRODSCollectionToBeMounted);
        log.info("absolutePathToLinkedCollectionToBeCreated:{}", (Object)absolutePathToLinkedCollectionToBeCreated);
        CollectionAndDataObjectListAndSearchAO listAndSearchAO = this.getIRODSAccessObjectFactory().getCollectionAndDataObjectListAndSearchAO(this.getIRODSAccount());
        log.info("getting objstat for collection to be mounted...");
        ObjStat statForCollectionToBeMounted = listAndSearchAO.retrieveObjectStatForPath(absolutePathToTheIRODSCollectionToBeMounted);
        log.info("statForCollectionToBeMounted:{}", (Object)statForCollectionToBeMounted);
        if (statForCollectionToBeMounted.getObjectType() != CollectionAndDataObjectListingEntry.ObjectType.COLLECTION) {
            log.error("object to be mounted is not an iRODS collection, is type:{}", (Object)statForCollectionToBeMounted.getObjectType());
            throw new JargonException("object to be mounted is not an iRODS collection, mount failed");
        }
        log.info("getting objstat for collection to be created...");
        try {
            ObjStat statForCollectionTarget = listAndSearchAO.retrieveObjectStatForPath(absolutePathToLinkedCollectionToBeCreated);
            if (statForCollectionTarget.getObjectType() != CollectionAndDataObjectListingEntry.ObjectType.COLLECTION) {
                log.error("target is not an iRODS collection, is type:{}", (Object)statForCollectionTarget.getObjectType());
                throw new JargonException("link target is not an iRODS collection, mount failed");
            }
        }
        catch (FileNotFoundException fnf) {
            log.info("file was not found, go ahead and create this collection");
            IRODSFile targetCollection = this.getIRODSFileFactory().instanceIRODSFile(absolutePathToLinkedCollectionToBeCreated);
            targetCollection.mkdirs();
        }
        log.info("all is well, make the call to mount the soft link...");
        DataObjInpForMcoll dataObjInp = DataObjInpForMcoll.instanceForSoftLinkMount(absolutePathToTheIRODSCollectionToBeMounted, absolutePathToLinkedCollectionToBeCreated, this.getIRODSAccount().getDefaultStorageResource());
        this.getIRODSProtocol().irodsFunction(dataObjInp);
        log.debug("soft link creation successful");
    }

    public void removeMountedWorkflowAndWorkflowFile(String absolutePathToMssFile, String absolutePathToWorkflowCollectionToBeUnmounted) throws JargonException {
        log.info("removeMountedWorkflowAndWorkflowFile(final String absolutePathToMssFile, final String absolutePathToWorkflowCollectionToBeUnmounted)");
    }

    @Override
    public void createMountedFileSystemCollection(String absolutePhysicalPathOnServer, String absoluteIRODSTargetPathToBeMounted, String storageResource) throws CollectionNotMountedException, FileNotFoundException, JargonException {
        log.info("createMountedFileSystemCollection()");
        if (absolutePhysicalPathOnServer == null || absolutePhysicalPathOnServer.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePhysicalPathOnServer");
        }
        if (absoluteIRODSTargetPathToBeMounted == null || absoluteIRODSTargetPathToBeMounted.isEmpty()) {
            throw new IllegalArgumentException("null or empty absoluteIRODSTargetPathToBeMounted");
        }
        if (storageResource == null || storageResource.isEmpty()) {
            throw new IllegalArgumentException("null or empty storageResource");
        }
        log.info("absolutePhysicalPathOnServer:{}", (Object)absolutePhysicalPathOnServer);
        log.info("absoluteIRODSTargetPathToBeMounted:{}", (Object)absoluteIRODSTargetPathToBeMounted);
        this.getIRODSAccessObjectFactory().getCollectionAndDataObjectListAndSearchAO(this.getIRODSAccount());
        log.info("making the directory for the mount if not exists...");
        IRODSFile mountColl = this.getIRODSFileFactory().instanceIRODSFile(absoluteIRODSTargetPathToBeMounted);
        mountColl.mkdirs();
        log.info("...dirs made");
        log.info("all is well, make the call to mount file system...");
        DataObjInpForMcoll dataObjInp = DataObjInpForMcoll.instanceForFileSystemMount(absolutePhysicalPathOnServer, absoluteIRODSTargetPathToBeMounted, storageResource);
        try {
            this.getIRODSProtocol().irodsFunction(dataObjInp);
        }
        catch (DataNotFoundException dnf) {
            log.warn("Data not found exception?  Seems to be a bug in iRODS...", (Throwable)dnf);
            log.warn("overheaded for  [#1634] Strange erroneous DataNotFoundExceptions mounting a file system");
            CollectionAndDataObjectListAndSearchAO collectionAndDataObjectListAndSearchAO = this.getIRODSAccessObjectFactory().getCollectionAndDataObjectListAndSearchAO(this.getIRODSAccount());
            log.warn("got data not found, do a compensating lookup, will throw FNF if the file really is not found");
            ObjStat objStat = collectionAndDataObjectListAndSearchAO.retrieveObjectStatForPath(absoluteIRODSTargetPathToBeMounted);
            log.info("really did find the file:{}", (Object)objStat);
        }
        catch (UnixFileMkdirException e) {
            log.error("unix file level mkdir error, will wrap in collection not mounted exception", (Throwable)e);
            throw new CollectionNotMountedException(e);
        }
        log.debug("file system mount successful");
    }

    @Override
    public void createAnMSSOMountForWorkflow(String absoluteLocalPathToWorkflowFile, String absoluteIRODSTargetPathToTheWssToBeMounted, String absolutePathToMountedCollection) throws FileNotFoundException, JargonException {
        log.info("createAnMSSOMount()");
        if (absoluteLocalPathToWorkflowFile == null || absoluteLocalPathToWorkflowFile.isEmpty()) {
            throw new IllegalArgumentException("null or empty absoluteLocalPathToWssFile");
        }
        if (absoluteIRODSTargetPathToTheWssToBeMounted == null || absoluteIRODSTargetPathToTheWssToBeMounted.isEmpty()) {
            throw new IllegalArgumentException("null or empty absoluteIRODSTargetPathToTheWssToBeMounted");
        }
        if (absolutePathToMountedCollection == null || absolutePathToMountedCollection.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePathToMountedCollection");
        }
        log.info("absoluteLocalPathToWssFile:{}", (Object)absoluteLocalPathToWorkflowFile);
        log.info("absoluteIRODSTargetPathToTheWssToBeMounted:{}", (Object)absoluteIRODSTargetPathToTheWssToBeMounted);
        log.info("absolutePathToMountedCollection:{}", (Object)absolutePathToMountedCollection);
        log.info("putting the wss file as type msso");
        TransferControlBlock tcb = this.buildDefaultTransferControlBlockBasedOnJargonProperties();
        tcb.getTransferOptions().setPutOption(TransferOptions.PutOptions.MSSO_FILE);
        tcb.getTransferOptions().setForceOption(TransferOptions.ForceOption.USE_FORCE);
        DataTransferOperations dto = this.getIRODSAccessObjectFactory().getDataTransferOperations(this.getIRODSAccount());
        dto.putOperation(absoluteLocalPathToWorkflowFile, absoluteIRODSTargetPathToTheWssToBeMounted, this.getIRODSAccount().getDefaultStorageResource(), null, tcb);
        log.info("wss file is put as an msso file...now mount the collection");
        this.getIRODSAccessObjectFactory().getCollectionAndDataObjectListAndSearchAO(this.getIRODSAccount());
        log.info("making the directory for the mount if not exists...");
        IRODSFile mountColl = this.getIRODSFileFactory().instanceIRODSFile(absolutePathToMountedCollection);
        mountColl.mkdirs();
        log.info("...dirs made");
        log.info("all is well, make the call to mount the soft link...");
        DataObjInpForMcoll dataObjInp = DataObjInpForMcoll.instanceForMSSOMount(absoluteIRODSTargetPathToTheWssToBeMounted, absolutePathToMountedCollection, this.getIRODSAccount().getDefaultStorageResource());
        this.getIRODSProtocol().irodsFunction(dataObjInp);
        log.debug("MSSO creation successful");
    }
}

