/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.irods.jargon.core.packinstr.DataObjInp;
import org.irods.jargon.core.pub.io.FileIOOperations;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRODSFileInputStream
extends InputStream {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final transient IRODSFile irodsFile;
    private final transient FileIOOperations fileIOOperations;
    private transient int fd = -1;
    private transient long filePointer = 0L;

    protected IRODSFileInputStream(IRODSFile irodsFile, FileIOOperations fileIOOperations) throws FileNotFoundException {
        this.checkFileParameter(irodsFile);
        if (fileIOOperations == null) {
            throw new JargonRuntimeException("fileIOOperations is null");
        }
        if (!irodsFile.exists()) {
            String msg = "file does not exist:" + irodsFile.getAbsolutePath();
            this.log.error(msg);
            throw new FileNotFoundException(msg);
        }
        if (!irodsFile.isFile()) {
            String msg = "this is not a file, it is a directory:" + irodsFile.getAbsolutePath();
            this.log.error(msg);
            throw new FileNotFoundException(msg);
        }
        this.irodsFile = irodsFile;
        this.fileIOOperations = fileIOOperations;
        this.openFile();
    }

    private void openFile() {
        if (this.fd != -1) {
            return;
        }
        this.log.debug("file will be opened on this operation");
        try {
            this.openIRODSFile();
            this.fd = this.irodsFile.getFileDescriptor();
        }
        catch (JargonException e) {
            String msg = "JargonException caught in constructor, rethrow as JargonRuntimeException";
            this.log.error("JargonException caught in constructor, rethrow as JargonRuntimeException", (Throwable)e);
            throw new JargonRuntimeException("JargonException caught in constructor, rethrow as JargonRuntimeException", e);
        }
    }

    protected IRODSFileInputStream(IRODSFile irodsFile, FileIOOperations fileIOOperations, int fd) throws FileNotFoundException {
        if (irodsFile == null) {
            throw new IllegalArgumentException("null irodsFile");
        }
        if (fd <= 0) {
            throw new IllegalArgumentException("fd <= 0");
        }
        this.fileIOOperations = fileIOOperations;
        this.irodsFile = irodsFile;
        this.fd = fd;
    }

    private void checkFileParameter(IRODSFile file) throws JargonRuntimeException {
        if (file == null) {
            String msg = "file is null";
            this.log.error("file is null");
            throw new JargonRuntimeException("file is null");
        }
    }

    private int openIRODSFile() throws JargonException {
        this.log.info("openIRODSFile()");
        if (!this.irodsFile.exists()) {
            this.log.warn("opening non-existant file for read: {}", (Object)this.irodsFile.getAbsolutePath());
            throw new JargonException("file does not exist, cannot read");
        }
        this.log.info("opening the file");
        this.fd = this.irodsFile.open(DataObjInp.OpenFlags.READ);
        this.log.info("file descriptor from open operation:{}", (Object)this.fd);
        return this.fd;
    }

    @Override
    public int read() throws IOException {
        try {
            byte[] buffer = new byte[1];
            int temp = this.fileIOOperations.fileRead(this.fd, buffer, 0, 1);
            if (temp < 0) {
                return -1;
            }
            this.filePointer += (long)temp;
            return buffer[0] & 0xFF;
        }
        catch (JargonException e) {
            this.log.error("JargonException in read is converted to IOException for method contract", (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int temp;
        try {
            temp = this.fileIOOperations.fileRead(this.fd, b, off, len);
        }
        catch (JargonException e) {
            this.log.error("JargonException in read is converted to IOException for method contract", (Throwable)e);
            throw new IOException(e);
        }
        if (temp > 0) {
            this.filePointer += (long)temp;
        }
        return temp;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public long skip(long numberOfBytesToSkip) throws IOException {
        long length = this.availableAsLong();
        if (length <= 0L) {
            return 0L;
        }
        try {
            this.openFile();
            if (this.filePointer + numberOfBytesToSkip < length) {
                this.fileIOOperations.seek(this.fd, numberOfBytesToSkip, FileIOOperations.SeekWhenceType.SEEK_CURRENT);
                this.filePointer += numberOfBytesToSkip;
                return numberOfBytesToSkip;
            }
            this.fileIOOperations.seek(this.fd, length, FileIOOperations.SeekWhenceType.SEEK_CURRENT);
            this.filePointer += length;
            return length;
        }
        catch (JargonException e) {
            this.log.error("JargonException in operation, rethrown as IOException for contract", (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public int available() throws IOException {
        return (int)this.irodsFile.length();
    }

    public long availableAsLong() throws IOException {
        return this.irodsFile.length();
    }

    protected FileIOOperations getFileIOOperations() {
        return this.fileIOOperations;
    }

    @Override
    public void close() throws IOException {
        this.log.info("closing file stream and file");
        try {
            this.irodsFile.close();
        }
        catch (JargonException e) {
            this.log.error("JargonException in operation, rethrown as IOException for contract", (Throwable)e);
            throw new IOException(e);
        }
        this.filePointer = 0L;
    }
}

