/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Host;
import org.apache.commons.lang3.StringUtils;

public final class BookmarkNameProvider {
    private BookmarkNameProvider() {
    }

    public static String toString(Host bookmark) {
        return BookmarkNameProvider.toString(bookmark, false);
    }

    public static String toString(Host bookmark, boolean username) {
        if (StringUtils.isEmpty((CharSequence)bookmark.getNickname())) {
            if (StringUtils.isNotBlank((CharSequence)bookmark.getProtocol().getDefaultNickname())) {
                return bookmark.getProtocol().getDefaultNickname();
            }
            String prefix = username && !bookmark.getCredentials().isAnonymousLogin() && StringUtils.isNotBlank((CharSequence)bookmark.getCredentials().getUsername()) ? String.format("%s@", bookmark.getCredentials().getUsername()) : "";
            if (StringUtils.isNotBlank((CharSequence)bookmark.getHostname())) {
                return String.format("%s%s \u2013 %s", prefix, StringUtils.strip((String)bookmark.getHostname()), bookmark.getProtocol().getName());
            }
            if (StringUtils.isNotBlank((CharSequence)bookmark.getProtocol().getDefaultHostname())) {
                return String.format("%s%s \u2013 %s", prefix, StringUtils.strip((String)bookmark.getProtocol().getDefaultHostname()), bookmark.getProtocol().getName());
            }
            return String.format("%s%s", prefix, bookmark.getProtocol().getName());
        }
        return bookmark.getNickname();
    }
}

