/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.LoginCallback;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.log4j.Logger;

public class LoginCallbackFactory
extends Factory<LoginCallback> {
    private static final Logger log = Logger.getLogger(LoginCallbackFactory.class);
    private Constructor<LoginCallback> constructor;

    protected LoginCallbackFactory() {
        super("factory.logincallback.class");
    }

    public LoginCallback create(Controller controller) {
        try {
            if (null == this.constructor) {
                this.constructor = ConstructorUtils.getMatchingAccessibleConstructor((Class)this.clazz, (Class[])new Class[]{controller.getClass()});
            }
            if (null == this.constructor) {
                log.warn((Object)String.format("No matching constructor for parameter %s", controller.getClass()));
                return (LoginCallback)this.clazz.newInstance();
            }
            return this.constructor.newInstance(controller);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.error((Object)String.format("Failure loading callback class %s. %s", this.clazz, e.getMessage()));
            return new DisabledLoginCallback();
        }
    }

    public static LoginCallback get(Controller c) {
        return new LoginCallbackFactory().create(c);
    }
}

