/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractFolderHostCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostReaderFactory;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.io.watchservice.WatchServiceFactory;
import ch.cyberduck.core.local.FileWatcher;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class MonitorFolderHostCollection
extends AbstractFolderHostCollection {
    private static final Logger log = Logger.getLogger(MonitorFolderHostCollection.class);
    private final Preferences preferences = PreferencesFactory.get();
    private final FileWatcher monitor = new FileWatcher(WatchServiceFactory.get());

    public MonitorFolderHostCollection(Local f) {
        super(f);
    }

    @Override
    public void load() throws AccessDeniedException {
        super.load();
        if (this.preferences.getBoolean("bookmarks.folder.monitor")) {
            try {
                this.monitor.register(this.folder, FILE_FILTER, this);
            }
            catch (IOException e) {
                throw new LocalAccessDeniedException(String.format("Failure monitoring directory %s", this.folder.getName()), e);
            }
        }
    }

    @Override
    public void fileWritten(Local file) {
        if (this.isLocked()) {
            log.debug((Object)String.format("Skip reading bookmark from %s", file));
        } else {
            try {
                Host bookmark = HostReaderFactory.get().read(file);
                int index = this.indexOf(bookmark);
                if (index != -1) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Replace bookmark %s at index %d", bookmark, index));
                    }
                    this.replace(index, bookmark);
                }
            }
            catch (AccessDeniedException e) {
                log.warn((Object)String.format("Failure reading file %s", file));
            }
        }
    }

    @Override
    public void fileDeleted(Local file) {
        if (this.isLocked()) {
            log.debug((Object)String.format("Skip reading bookmark from %s", file));
        } else {
            Host bookmark = this.lookup(FilenameUtils.getBaseName((String)file.getName()));
            if (bookmark != null) {
                log.warn((Object)String.format("Delete bookmark %s", bookmark));
                this.remove(bookmark);
            }
        }
    }

    @Override
    public void fileCreated(Local file) {
        if (this.isLocked()) {
            log.debug((Object)String.format("Skip reading bookmark from %s", file));
        } else {
            try {
                Host bookmark = HostReaderFactory.get().read(file);
                log.warn((Object)String.format("Add bookmark %s", bookmark));
                this.add(bookmark);
            }
            catch (AccessDeniedException e) {
                log.warn((Object)String.format("Failure reading file %s", file));
            }
        }
    }
}

