/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.http;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;
import org.jets3t.service.io.UnrecoverableIOException;

public class ExtendedHttpRequestRetryHandler
extends DefaultHttpRequestRetryHandler {
    private static final Logger log = Logger.getLogger(ExtendedHttpRequestRetryHandler.class);
    private static final List<Class<? extends IOException>> exceptions = Arrays.asList(UnrecoverableIOException.class, InterruptedIOException.class, UnknownHostException.class, ConnectException.class, SSLHandshakeException.class);

    public ExtendedHttpRequestRetryHandler(int retryCount) {
        super(retryCount, true, exceptions);
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        Throwable cause = ExceptionUtils.getRootCause((Throwable)exception);
        if (cause instanceof RuntimeException) {
            log.error((Object)String.format("Cancel retry request with execution count %d for failure %s", executionCount, cause));
            return false;
        }
        boolean retry = super.retryRequest(exception, executionCount, context);
        if (retry) {
            log.info((Object)String.format("Retry request with failure %s", exception));
        } else {
            log.warn((Object)String.format("Cancel retry request with execution count %d for failure %s", executionCount, exception));
        }
        return retry;
    }
}

