/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.http;

import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.io.StatusOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public abstract class HttpResponseOutputStream<T>
extends StatusOutputStream<T> {
    private static final Logger log = Logger.getLogger(HttpResponseOutputStream.class);

    public HttpResponseOutputStream(OutputStream proxy) {
        super(proxy);
    }

    @Override
    public abstract T getStatus() throws BackgroundException;

    public void close() throws IOException {
        super.close();
        try {
            T response = this.getStatus();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Closed stream %s with response value %s", new Object[]{this, response}));
            }
        }
        catch (BackgroundException e) {
            throw new IOException(e.getDetail(), e);
        }
    }
}

