/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io;

import ch.cyberduck.core.io.Buffer;
import ch.cyberduck.core.io.BufferInputStream;
import ch.cyberduck.core.io.BufferOutputStream;
import ch.cyberduck.core.io.SegmentingOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.log4j.Logger;

public class BufferSegmentingOutputStream
extends SegmentingOutputStream {
    private static final Logger log = Logger.getLogger(BufferSegmentingOutputStream.class);
    private final OutputStream proxy;
    private final Buffer buffer;

    public BufferSegmentingOutputStream(OutputStream proxy, Long threshold, Buffer buffer) {
        super((OutputStream)new NullOutputStream(), threshold, (OutputStream)((Object)new BufferOutputStream(buffer)));
        this.proxy = proxy;
        this.buffer = buffer;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.buffer.close();
    }

    @Override
    public void flush() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Copy buffer %s to output %s", this.buffer, this.proxy));
        }
        IOUtils.copy((InputStream)new BufferInputStream(this.buffer), (OutputStream)this.proxy);
        this.buffer.truncate(0L);
    }
}

