/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.proxy;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.DefaultProxyFinder;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.proxy.ProxyFinder;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class EnvironmentVariableProxyFinder
implements ProxyFinder {
    private static final Logger log = Logger.getLogger(EnvironmentVariableProxyFinder.class);
    private final Preferences preferences = PreferencesFactory.get();

    @Override
    public Proxy find(Host target) {
        if (!this.preferences.getBoolean("connection.proxy.enable")) {
            return Proxy.DIRECT;
        }
        switch (target.getProtocol().getScheme()) {
            case ftp: 
            case ftps: 
            case sftp: {
                String ftp_proxy = System.getenv("ftp_proxy");
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{ftp_proxy})) break;
                try {
                    URI uri = new URI(ftp_proxy);
                    return new Proxy(Proxy.Type.SOCKS, uri.getHost(), uri.getPort());
                }
                catch (URISyntaxException e) {
                    log.warn((Object)String.format("Invalid URL in ftp_proxy environment variable. %s", ftp_proxy));
                    break;
                }
            }
            case http: {
                String http_proxy = System.getenv("http_proxy");
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{http_proxy})) break;
                try {
                    URI uri = new URI(http_proxy);
                    return new Proxy(Proxy.Type.HTTP, uri.getHost(), uri.getPort());
                }
                catch (URISyntaxException e) {
                    log.warn((Object)String.format("Invalid URL in ftp_proxy environment variable. %s", http_proxy));
                    break;
                }
            }
            case https: {
                String https_proxy = System.getenv("https_proxy");
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{https_proxy})) break;
                try {
                    URI uri = new URI(https_proxy);
                    return new Proxy(Proxy.Type.HTTP, uri.getHost(), uri.getPort());
                }
                catch (URISyntaxException e) {
                    log.warn((Object)String.format("Invalid URL in ftp_proxy environment variable. %s", https_proxy));
                }
            }
        }
        return new DefaultProxyFinder().find(target);
    }
}

