/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.proxy;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.proxy.ProxyFactory;
import ch.cyberduck.core.proxy.ProxyFinder;
import ch.cyberduck.core.socket.DefaultSocketConfigurator;
import ch.cyberduck.core.socket.HttpProxySocketFactory;
import ch.cyberduck.core.socket.SocketConfigurator;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.SocketFactory;
import org.apache.commons.net.DefaultSocketFactory;
import org.apache.log4j.Logger;

public class ProxySocketFactory
extends SocketFactory {
    private static final Logger log = Logger.getLogger(ProxySocketFactory.class);
    private final SocketConfigurator configurator;
    private final ProxyFinder proxyFinder;
    private final Host host;
    private final List<Proxy.Type> types = new ArrayList<Proxy.Type>(Arrays.asList(Proxy.Type.DIRECT, Proxy.Type.SOCKS, Proxy.Type.HTTP, Proxy.Type.HTTPS));
    private List<String> blacklisted = PreferencesFactory.get().getList("network.interface.blacklist");

    public ProxySocketFactory(Host host) {
        this(host, new DefaultSocketConfigurator());
    }

    public ProxySocketFactory(Host host, SocketConfigurator configurator) {
        this(host, configurator, ProxyFactory.get());
    }

    public ProxySocketFactory(Host host, ProxyFinder proxyFinder) {
        this(host, new DefaultSocketConfigurator(), proxyFinder);
    }

    public ProxySocketFactory(Host host, SocketConfigurator configurator, ProxyFinder proxyFinder) {
        this.host = host;
        this.configurator = configurator;
        this.proxyFinder = proxyFinder;
    }

    public ProxySocketFactory withBlacklistedNetworkInterfaces(List<String> names) {
        this.blacklisted = names;
        return this;
    }

    protected SocketFactory factory(String target) {
        Proxy proxy = this.proxyFinder.find(this.host);
        if (!this.types.contains((Object)proxy.getType())) {
            log.warn((Object)String.format("Use of %s proxy is disabled for socket factory %s", new Object[]{proxy.getType(), this}));
            return new DefaultSocketFactory();
        }
        switch (proxy.getType()) {
            case SOCKS: {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Configured to use SOCKS proxy %s", proxy));
                }
                java.net.Proxy socksProxy = new java.net.Proxy(Proxy.Type.SOCKS, new InetSocketAddress(proxy.getHostname(), proxy.getPort()));
                return new DefaultSocketFactory(socksProxy);
            }
            case HTTP: 
            case HTTPS: {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Configured to use HTTP proxy %s", proxy));
                }
                java.net.Proxy httpProxy = new java.net.Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy.getHostname(), proxy.getPort()));
                return new HttpProxySocketFactory(httpProxy);
            }
        }
        return new DefaultSocketFactory();
    }

    @Override
    public Socket createSocket() throws IOException {
        try {
            Socket socket = this.factory(this.host.getHostname()).createSocket();
            this.configurator.configure(socket);
            return socket;
        }
        catch (IllegalArgumentException e) {
            throw this.failure(this.host.getHostname(), e);
        }
    }

    private IOException failure(String target, IllegalArgumentException e) {
        return new ConnectException(String.format("Unsupported proxy type for target %s", target));
    }

    @Override
    public Socket createSocket(String hostname, int port) throws IOException {
        try {
            Socket socket = this.factory(hostname).createSocket(hostname, port);
            this.configurator.configure(socket);
            return socket;
        }
        catch (IllegalArgumentException e) {
            throw this.failure(hostname, e);
        }
    }

    @Override
    public Socket createSocket(String hostname, int port, InetAddress localHost, int localPort) throws IOException {
        try {
            Socket socket = this.factory(hostname).createSocket(hostname, port, localHost, localPort);
            this.configurator.configure(socket);
            return socket;
        }
        catch (IllegalArgumentException e) {
            throw this.failure(hostname, e);
        }
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int port) throws IOException {
        try {
            Socket socket = this.factory(inetAddress.getHostName()).createSocket(inetAddress, port);
            this.configurator.configure(socket);
            return socket;
        }
        catch (IllegalArgumentException e) {
            throw this.failure(inetAddress.getHostName(), e);
        }
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int port, InetAddress localHost, int localPort) throws IOException {
        try {
            Socket socket = this.factory(inetAddress.getHostName()).createSocket(inetAddress, port, localHost, localPort);
            this.configurator.configure(socket);
            return socket;
        }
        catch (IllegalArgumentException e) {
            throw this.failure(inetAddress.getHostName(), e);
        }
    }

    public ProxySocketFactory disable(Proxy.Type type) {
        this.types.remove((Object)type);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ProxySocketFactory{");
        sb.append("types=").append(this.types);
        sb.append('}');
        return sb.toString();
    }
}

