/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.synchronization;

import ch.cyberduck.core.Attributes;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.synchronization.Comparison;
import ch.cyberduck.core.synchronization.ComparisonService;
import org.apache.log4j.Logger;

public class ChecksumComparisonService
implements ComparisonService {
    private static final Logger log = Logger.getLogger(ChecksumComparisonService.class);

    @Override
    public Comparison compare(Attributes remote, Attributes local) {
        if (Checksum.NONE == remote.getChecksum()) {
            log.warn((Object)String.format("No remote checksum available for comparison %s", remote));
            return Comparison.unknown;
        }
        if (Checksum.NONE == local.getChecksum()) {
            log.warn((Object)String.format("No local checksum available for comparison %s", local));
            return Comparison.unknown;
        }
        if (remote.getChecksum().equals(local.getChecksum())) {
            return Comparison.equal;
        }
        return Comparison.notequal;
    }
}

