/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.TransferCanceledException;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.io.StreamProgress;
import ch.cyberduck.core.random.NonceGenerator;
import com.google.common.util.concurrent.Uninterruptibles;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public class TransferStatus
implements StreamCancelation,
StreamProgress {
    private static final Logger log = Logger.getLogger(TransferStatus.class);
    public static final long KILO = 1024L;
    public static final long MEGA = 0x100000L;
    public static final long GIGA = 0x40000000L;
    private Rename rename = new Rename();
    private final Displayname displayname = new Displayname();
    private boolean exists = false;
    private boolean append = false;
    private boolean segment = false;
    private boolean rejected = false;
    private boolean hidden = false;
    private final AtomicLong offset = new AtomicLong(0L);
    private long length = 0L;
    private final AtomicBoolean canceled = new AtomicBoolean();
    private final AtomicBoolean complete = new AtomicBoolean();
    private final CountDownLatch done = new CountDownLatch(1);
    private Checksum checksum = Checksum.NONE;
    private String mime;
    private PathAttributes remote = PathAttributes.EMPTY;
    private Permission permission = Permission.EMPTY;
    private Acl acl = Acl.EMPTY;
    private Encryption.Algorithm encryption = Encryption.Algorithm.NONE;
    private String storageClass;
    private Long timestamp;
    private Map<String, String> parameters = Collections.emptyMap();
    private Map<String, String> metadata = Collections.emptyMap();
    private List<TransferStatus> segments = Collections.emptyList();
    private Integer part;
    private ByteBuffer header;
    private ByteBuffer filekey;
    private NonceGenerator nonces;
    private Object lockId;
    private VersionId version;

    public TransferStatus() {
    }

    public TransferStatus(TransferStatus copy) {
        this.rename.remote = copy.rename.remote;
        this.rename.local = copy.rename.local;
        this.displayname.local = copy.displayname.local;
        this.displayname.remote = copy.displayname.remote;
        this.exists = copy.exists;
        this.append = copy.append;
        this.segment = copy.segment;
        this.segments = copy.segments;
        this.rejected = copy.rejected;
        this.hidden = copy.hidden;
        this.offset.set(copy.offset.get());
        this.length = copy.length;
        this.canceled.set(copy.canceled.get());
        this.complete.set(copy.complete.get());
        this.checksum = copy.checksum;
        this.mime = copy.mime;
        this.remote = copy.remote;
        this.permission = copy.permission;
        this.acl = copy.acl;
        this.encryption = copy.encryption;
        this.storageClass = copy.storageClass;
        this.timestamp = copy.timestamp;
        this.parameters = copy.parameters;
        this.metadata = copy.metadata;
        this.segment = copy.segment;
        this.part = copy.part;
        this.header = copy.header;
        this.filekey = copy.filekey;
        this.nonces = copy.nonces;
        this.lockId = copy.lockId;
        this.version = copy.version;
    }

    public boolean await() {
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.done);
        return this.complete.get();
    }

    public boolean isComplete() {
        return this.complete.get();
    }

    @Override
    public void setComplete() {
        this.complete.set(true);
        this.done.countDown();
    }

    public TransferStatus complete() {
        this.setComplete();
        return this;
    }

    public void setFailure() {
        this.complete.set(false);
        this.done.countDown();
    }

    public void setCanceled() {
        this.canceled.set(true);
        this.done.countDown();
    }

    @Override
    public void validate() throws ConnectionCanceledException {
        if (this.canceled.get()) {
            throw new TransferCanceledException();
        }
    }

    public long getOffset() {
        return this.offset.get();
    }

    public void setOffset(long bytes) {
        this.offset.set(bytes);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Offset set to %d bytes", bytes));
        }
    }

    @Override
    public void progress(long bytes) {
        this.setOffset(this.offset.addAndGet(bytes));
    }

    public TransferStatus skip(long bytes) {
        this.setOffset(bytes);
        return this;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long bytes) {
        this.length = bytes;
    }

    public TransferStatus length(long bytes) {
        this.setLength(bytes);
        return this;
    }

    public boolean isExists() {
        return this.exists;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    public TransferStatus exists(boolean exists) {
        this.exists = exists;
        return this;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        if (!append) {
            this.offset.set(0L);
        }
        this.append = append;
    }

    public TransferStatus append(boolean append) {
        this.setAppend(append);
        return this;
    }

    public boolean isSegment() {
        return this.segment;
    }

    public void setSegment(boolean segment) {
        this.segment = segment;
    }

    public TransferStatus segment(boolean segment) {
        this.segment = segment;
        return this;
    }

    public void setRejected(boolean rejected) {
        this.rejected = rejected;
    }

    public TransferStatus reject(boolean rejected) {
        this.setRejected(rejected);
        return this;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public TransferStatus hidden(boolean hidden) {
        this.setHidden(hidden);
        return this;
    }

    public Rename getRename() {
        return this.rename;
    }

    public Displayname getDisplayname() {
        return this.displayname;
    }

    public TransferStatus rename(Path renamed) {
        this.rename.remote = renamed;
        return this;
    }

    public TransferStatus temporary(Path temporary) {
        this.rename.remote = temporary;
        return this;
    }

    public TransferStatus withDisplayname(Path finalname) {
        this.displayname.remote = finalname;
        return this;
    }

    public TransferStatus rename(Local renamed) {
        this.rename.local = renamed;
        return this;
    }

    public TransferStatus withDisplayname(Local finalname) {
        this.displayname.local = finalname;
        return this;
    }

    public void setRename(Rename rename) {
        this.rename = rename;
    }

    public String getMime() {
        return this.mime;
    }

    public void setMime(String type) {
        this.mime = type;
    }

    public TransferStatus withMime(String type) {
        this.mime = type;
        return this;
    }

    public Checksum getChecksum() {
        return this.checksum;
    }

    public void setChecksum(Checksum checksum) {
        this.checksum = checksum;
    }

    public TransferStatus withChecksum(Checksum checksum) {
        this.setChecksum(checksum);
        return this;
    }

    public PathAttributes getRemote() {
        return this.remote;
    }

    public void setRemote(PathAttributes remote) {
        this.remote = remote;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public void setPermission(Permission permission) {
        this.permission = permission;
    }

    public Acl getAcl() {
        return this.acl;
    }

    public void setAcl(Acl acl) {
        this.acl = acl;
    }

    public Encryption.Algorithm getEncryption() {
        return this.encryption;
    }

    public void setEncryption(Encryption.Algorithm encryption) {
        this.encryption = encryption;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public TransferStatus withTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public TransferStatus withParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public TransferStatus withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Integer getPart() {
        return this.part;
    }

    public void setPart(Integer part) {
        this.part = part;
    }

    public List<TransferStatus> getSegments() {
        if (this.segments.isEmpty()) {
            return Collections.singletonList(this);
        }
        return this.segments;
    }

    public TransferStatus withSegments(List<TransferStatus> segments) {
        this.segments = segments;
        return this;
    }

    public boolean isSegmented() {
        return !this.segments.isEmpty();
    }

    public ByteBuffer getHeader() {
        return this.header;
    }

    public void setHeader(ByteBuffer header) {
        this.header = header;
    }

    public TransferStatus withHeader(ByteBuffer header) {
        this.setHeader(header);
        return this;
    }

    public ByteBuffer getFilekey() {
        return this.filekey;
    }

    public void setFilekey(ByteBuffer filekey) {
        this.filekey = filekey;
    }

    public TransferStatus withFileKey(ByteBuffer filekey) {
        this.setFilekey(filekey);
        return this;
    }

    public NonceGenerator getNonces() {
        return this.nonces;
    }

    public void setNonces(NonceGenerator nonces) {
        this.nonces = nonces;
    }

    public TransferStatus withNonces(NonceGenerator nonces) {
        this.setNonces(nonces);
        return this;
    }

    public Object getLockId() {
        return this.lockId;
    }

    public void setLockId(Object lockId) {
        this.lockId = lockId;
    }

    public TransferStatus withLockId(Object lockId) {
        this.setLockId(lockId);
        return this;
    }

    public VersionId getVersion() {
        return this.version;
    }

    public void setVersion(VersionId version) {
        this.version = version;
    }

    public TransferStatus withVersion(VersionId version) {
        this.version = version;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferStatus that = (TransferStatus)o;
        if (this.append != that.append) {
            return false;
        }
        if (this.exists != that.exists) {
            return false;
        }
        return this.length == that.length;
    }

    public int hashCode() {
        int result = this.exists ? 1 : 0;
        result = 31 * result + (this.append ? 1 : 0);
        result = 31 * result + (int)(this.length ^ this.length >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TransferStatus{");
        sb.append("exists=").append(this.exists);
        sb.append(", append=").append(this.append);
        sb.append(", segments=").append(this.segments);
        sb.append(", offset=").append(this.offset);
        sb.append(", length=").append(this.length);
        sb.append(", canceled=").append(this.canceled);
        sb.append(", renamed=").append(this.rename);
        sb.append(", version=").append(this.version);
        sb.append('}');
        return sb.toString();
    }

    public static final class Rename {
        public Path remote;
        public Local local;

        public String toString() {
            StringBuilder sb = new StringBuilder("Rename{");
            sb.append("local=").append(this.local);
            sb.append(", remote=").append(this.remote);
            sb.append('}');
            return sb.toString();
        }
    }

    public static final class Displayname {
        public Path remote;
        public Local local;

        public String toString() {
            StringBuilder sb = new StringBuilder("Temporary{");
            sb.append(", local=").append(this.local);
            sb.append('}');
            return sb.toString();
        }
    }
}

