/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.copy;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.copy.AbstractCopyFilter;
import ch.cyberduck.core.transfer.upload.UploadFilterOptions;
import java.util.Map;
import java.util.Objects;
import org.apache.log4j.Logger;

public class ChecksumFilter
extends AbstractCopyFilter {
    private static final Logger log = Logger.getLogger(ChecksumFilter.class);
    private Upload upload;

    public ChecksumFilter(Session<?> source, Session<?> destination, Map<Path, Path> files) {
        super(source, destination, files);
        this.upload = destination.getFeature(Upload.class);
    }

    public ChecksumFilter(Session<?> source, Session<?> destination, Map<Path, Path> files, UploadFilterOptions options) {
        super(source, destination, files, options);
    }

    @Override
    public boolean accept(Path source, Local local, TransferStatus parent) throws BackgroundException {
        Path target = (Path)this.files.get(source);
        if (source.isFile() && parent.isExists()) {
            PathAttributes attributes = ((AttributesFinder)this.sourceSession.getFeature(AttributesFinder.class, new DefaultAttributesFinderFeature(this.sourceSession))).withCache(this.sourceCache).find(source);
            Write.Append append = this.upload.append(target, attributes.getSize(), this.destinationCache);
            if (append.size.longValue() == attributes.getSize()) {
                if (Checksum.NONE != append.checksum) {
                    if (Objects.equals(attributes.getChecksum(), append.checksum)) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)String.format("Skip file %s with checksum %s", source, append.checksum));
                        }
                        return false;
                    }
                    log.warn((Object)String.format("Checksum mismatch for %s and %s", source, target));
                } else {
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Skip file %s with remote size %d", source, append.size));
                    }
                    return false;
                }
            }
        }
        return true;
    }
}

