/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.download;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.download.AbstractDownloadFilter;
import ch.cyberduck.core.transfer.download.DownloadFilterOptions;
import ch.cyberduck.core.transfer.symlink.SymlinkResolver;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RenameFilter
extends AbstractDownloadFilter {
    private static final Logger log = Logger.getLogger(RenameFilter.class);

    public RenameFilter(SymlinkResolver<Path> symlinkResolver, Session<?> session) {
        super(symlinkResolver, session, new DownloadFilterOptions());
    }

    public RenameFilter(SymlinkResolver<Path> symlinkResolver, Session<?> session, DownloadFilterOptions options) {
        super(symlinkResolver, session, options);
    }

    @Override
    public TransferStatus prepare(Path file, Local local, TransferStatus parent, ProgressListener progress) throws BackgroundException {
        TransferStatus status = super.prepare(file, local, parent, progress);
        if (status.isExists()) {
            String filename = file.getName();
            int no = 0;
            do {
                String proposal = String.format("%s-%d", FilenameUtils.getBaseName((String)filename), ++no);
                if (StringUtils.isNotBlank((CharSequence)FilenameUtils.getExtension((String)filename))) {
                    proposal = proposal + String.format(".%s", FilenameUtils.getExtension((String)filename));
                }
                if (parent.getRename().local != null) {
                    status.rename(LocalFactory.get(parent.getRename().local, proposal));
                    continue;
                }
                status.rename(LocalFactory.get(local.getParent(), proposal));
            } while (status.getRename().local.exists());
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Changed download target from %s to %s", local, status.getRename().local));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Clear exist flag for file %s", local));
            }
            status.setExists(false);
        } else {
            if (parent.getRename().local != null) {
                status.rename(LocalFactory.get(parent.getRename().local, file.getName()));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Changed download target from %s to %s", local, status.getRename().local));
            }
        }
        return status;
    }
}

