/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.vault.VaultRegistry;
import java.util.EnumSet;
import java.util.List;

public class VaultRegistryAclPermissionFeature
implements AclPermission {
    private final Session<?> session;
    private final AclPermission proxy;
    private final VaultRegistry registry;

    public VaultRegistryAclPermissionFeature(Session<?> session, AclPermission proxy, VaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public Acl getPermission(Path file) throws BackgroundException {
        return this.registry.find(this.session, file).getFeature(this.session, AclPermission.class, this.proxy).getPermission(file);
    }

    @Override
    public void setPermission(Path file, Acl acl) throws BackgroundException {
        this.registry.find(this.session, file).getFeature(this.session, AclPermission.class, this.proxy).setPermission(file, acl);
    }

    @Override
    public List<Acl.User> getAvailableAclUsers() {
        return this.proxy.getAvailableAclUsers();
    }

    @Override
    public List<Acl.Role> getAvailableAclRoles(List<Path> files) {
        return this.proxy.getAvailableAclRoles(files);
    }

    @Override
    public Acl getDefault(Local file) {
        return this.proxy.getDefault(file);
    }

    @Override
    public Acl getDefault(EnumSet<AbstractPath.Type> type) {
        return this.proxy.getDefault(type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryAclPermissionFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

