/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Redundancy;
import ch.cyberduck.core.worker.BooleanRecursiveCallback;
import ch.cyberduck.core.worker.Worker;
import ch.cyberduck.core.worker.WorkerListProgressListener;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import org.apache.log4j.Logger;

public class WriteRedundancyWorker
extends Worker<Boolean> {
    private static final Logger log = Logger.getLogger(WriteRedundancyWorker.class);
    private final List<Path> files;
    private final String level;
    private final Worker.RecursiveCallback<String> callback;
    private final ProgressListener listener;

    public WriteRedundancyWorker(List<Path> files, String level, boolean recursive, ProgressListener listener) {
        this(files, level, new BooleanRecursiveCallback<String>(recursive), listener);
    }

    public WriteRedundancyWorker(List<Path> files, String level, Worker.RecursiveCallback<String> callback, ProgressListener listener) {
        this.files = files;
        this.level = level;
        this.callback = callback;
        this.listener = listener;
    }

    @Override
    public Boolean run(Session<?> session) throws BackgroundException {
        Redundancy feature = session.getFeature(Redundancy.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Run with feature %s", feature));
        }
        for (Path file : this.files) {
            if (this.isCanceled()) {
                throw new ConnectionCanceledException();
            }
            this.write(session, feature, file);
        }
        return true;
    }

    protected void write(Session<?> session, Redundancy feature, Path file) throws BackgroundException {
        if (this.isCanceled()) {
            throw new ConnectionCanceledException();
        }
        if (!this.level.equals(file.attributes().getStorageClass())) {
            this.listener.message(MessageFormat.format(LocaleFactory.localizedString("Writing metadata of {0}", "Status"), file.getName()));
            feature.setClass(file, this.level);
            file.attributes().setStorageClass(this.level);
        }
        if (file.isDirectory() && this.callback.recurse(file, this.level)) {
            for (Path child : session.getFeature(ListService.class).list(file, new WorkerListProgressListener(this, this.listener))) {
                this.write(session, feature, child);
            }
        }
    }

    @Override
    public Boolean initialize() {
        return false;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Writing metadata of {0}", "Status"), this.toString(this.files));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteRedundancyWorker that = (WriteRedundancyWorker)o;
        return Objects.equals(this.files, that.files);
    }

    public int hashCode() {
        return this.files != null ? this.files.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WriteRedundancyWorker{");
        sb.append("files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

