/*
 * Decompiled with CFR 0.152.
 */
package synapticloop.b2.response;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import synapticloop.b2.Action;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.BaseB2Response;

public class B2FileResponse
extends BaseB2Response {
    private static final Logger LOGGER = LoggerFactory.getLogger(B2FileResponse.class);
    private final String fileId = this.readString("fileId");
    private final String fileName = this.readString("fileName");
    private final String accountId = this.readString("accountId");
    private final String bucketId = this.readString("bucketId");
    private final Long contentLength = this.readLong("contentLength");
    private final String contentSha1 = this.readString("contentSha1");
    private final String contentType = this.readString("contentType");
    private final Map<String, String> fileInfo = this.readMap("fileInfo");
    private Action action;
    private final Long uploadTimestamp = this.readLong("uploadTimestamp");

    public B2FileResponse(String json) throws B2ApiException {
        super(json);
        String action = this.readString("action");
        if (null != action) {
            try {
                this.action = Action.valueOf(action);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Unknown action value " + action);
            }
        }
        this.warnOnMissedKeys();
    }

    public String getFileId() {
        return this.fileId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentSha1() {
        return this.contentSha1;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, String> getFileInfo() {
        return this.fileInfo;
    }

    public Long getUploadTimestamp() {
        return this.uploadTimestamp;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("B2FileResponse{");
        sb.append("fileId='").append(this.fileId).append('\'');
        sb.append(", fileName='").append(this.fileName).append('\'');
        sb.append(", accountId='").append(this.accountId).append('\'');
        sb.append(", bucketId='").append(this.bucketId).append('\'');
        sb.append(", contentLength=").append(this.contentLength);
        sb.append(", contentSha1='").append(this.contentSha1).append('\'');
        sb.append(", contentType='").append(this.contentType).append('\'');
        sb.append(", fileInfo=").append(this.fileInfo);
        sb.append('}');
        return sb.toString();
    }

    public Action getAction() {
        return this.action;
    }
}

