/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client;

import com.joyent.manta.client.MantaMetadata;
import com.joyent.manta.client.MantaObject;
import com.joyent.manta.client.MantaObjectResponse;
import com.joyent.manta.exception.MantaResourceCloseException;
import com.joyent.manta.http.HttpHelper;
import com.joyent.manta.http.MantaHttpHeaders;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.conn.EofSensorInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MantaObjectInputStream
extends InputStream
implements MantaObject,
AutoCloseable {
    private static final long serialVersionUID = -4692104903008485259L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MantaObjectInputStream.class);
    private final MantaObjectResponse response;
    private final InputStream backingStream;
    private final transient CloseableHttpResponse httpResponse;

    public MantaObjectInputStream(MantaObjectResponse response, CloseableHttpResponse httpResponse, InputStream backingStream) {
        this.backingStream = backingStream;
        this.response = response;
        this.httpResponse = httpResponse;
    }

    protected MantaObjectInputStream(MantaObjectInputStream copy) {
        this(copy.response, copy.httpResponse, copy.backingStream);
    }

    @Override
    public String getPath() {
        return this.response.getPath();
    }

    @Override
    public Long getContentLength() {
        return this.response.getContentLength();
    }

    @Override
    public String getContentType() {
        return this.response.getContentType();
    }

    @Override
    public String getEtag() {
        return this.response.getEtag();
    }

    @Override
    public Date getLastModifiedTime() {
        return this.response.getLastModifiedTime();
    }

    @Override
    public String getMtime() {
        return this.response.getMtime();
    }

    @Override
    public String getType() {
        return this.response.getType();
    }

    @Override
    public MantaHttpHeaders getHttpHeaders() {
        return this.response.getHttpHeaders();
    }

    @Override
    public Object getHeader(String fieldName) {
        return this.response.getHeader(fieldName);
    }

    @Override
    public String getHeaderAsString(String fieldName) {
        return this.response.getHeaderAsString(fieldName);
    }

    @Override
    public MantaMetadata getMetadata() {
        return this.response.getMetadata();
    }

    @Override
    public byte[] getMd5Bytes() {
        return this.response.getMd5Bytes();
    }

    @Override
    public boolean isDirectory() {
        return this.response.isDirectory();
    }

    @Override
    public String getRequestId() {
        return this.response.getRequestId();
    }

    protected MantaObjectResponse getResponse() {
        return this.response;
    }

    public Object getHttpResponse() {
        return this.httpResponse;
    }

    public InputStream getBackingStream() {
        return this.backingStream;
    }

    @Override
    public int read() throws IOException {
        return this.backingStream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.backingStream.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.backingStream.read(b);
    }

    @Override
    public int available() throws IOException {
        return this.backingStream.available();
    }

    @Override
    public void close() throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Closing backingStream {} and response {}", (Object)this.backingStream, (Object)this.httpResponse);
        }
        if (this.backingStream instanceof EofSensorInputStream) {
            ((EofSensorInputStream)this.backingStream).abortConnection();
            this.closeHttpResponse();
        } else {
            try {
                if (this.backingStream != null) {
                    this.backingStream.close();
                }
            }
            catch (IOException e) {
                MantaResourceCloseException mio = new MantaResourceCloseException(e);
                LOGGER.error("Unable to close backing stream", (Throwable)mio);
            }
            finally {
                this.closeHttpResponse();
            }
        }
    }

    private void closeHttpResponse() {
        try {
            if (this.httpResponse != null) {
                this.httpResponse.close();
            }
        }
        catch (IOException e) {
            MantaResourceCloseException mio = new MantaResourceCloseException(e);
            HttpHelper.annotateContextedException(mio, null, (HttpResponse)this.httpResponse);
            LOGGER.error("Unable to close HTTP response object", (Throwable)mio);
        }
    }

    @Override
    public void mark(int readlimit) {
        this.backingStream.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.backingStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.backingStream.markSupported();
    }

    public void abortConnection() throws IOException {
        if (this.backingStream instanceof EofSensorInputStream) {
            ((EofSensorInputStream)this.backingStream).abortConnection();
            this.closeHttpResponse();
        } else {
            this.close();
        }
    }
}

