/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.crypto;

import java.security.Provider;
import java.security.Security;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExternalSecurityProviderLoader {
    private static final Logger LOGGER;
    private static final String PREFERRED_PROVIDERS_SYS_PROP_KEY = "manta.preferred.security.providers";
    static final String BC_PROVIDER_NAME = "BC";
    static final String PKCS11_PROVIDER_NAME = "SunPKCS11-NSS";
    static final String SUNJCE_PROVIDER_NAME = "SunJCE";
    private static final Provider PKCS11_PROVIDER;
    private static final Provider BC_PROVIDER;
    private static final Provider SUNJCE_PROVIDER;
    private static List<Provider> rankedPreferredProviders;

    private ExternalSecurityProviderLoader() {
    }

    public static Provider getPkcs11Provider() {
        return PKCS11_PROVIDER;
    }

    public static Provider getBouncyCastleProvider() {
        return BC_PROVIDER;
    }

    public static Provider getSunJceProvider() {
        return SUNJCE_PROVIDER;
    }

    private static boolean isKnownSecurityProvider(String provider) {
        if (StringUtils.isBlank((CharSequence)provider)) {
            LOGGER.warn("Blank security provider specified: [{}]", (Object)provider);
            return false;
        }
        switch (provider) {
            case "SunPKCS11-NSS": 
            case "BC": 
            case "SunJCE": {
                Provider foundProvider = Security.getProvider(provider);
                if (foundProvider == null && LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Known provider specified, but it couldn't be loaded. Provider: [{}]", (Object)provider);
                }
                return foundProvider != null;
            }
        }
        LOGGER.warn("Unknown provider specified: [{}]", (Object)provider);
        return false;
    }

    public static Provider getPreferredProvider() {
        return rankedPreferredProviders.get(0);
    }

    public static List<Provider> getRankedPreferredProviders() {
        return rankedPreferredProviders;
    }

    public static void setRankedPreferredProviders(Collection<Provider> providersRanked) {
        rankedPreferredProviders = Collections.unmodifiableList(new ArrayList<Provider>(providersRanked));
    }

    public static List<Provider> buildRankedPreferredProviders(String preferredProvidersCSV) {
        ArrayDeque<Provider> rankedProviders = new ArrayDeque<Provider>(4);
        if (PKCS11_PROVIDER != null) {
            rankedProviders.add(PKCS11_PROVIDER);
        }
        if (BC_PROVIDER != null) {
            rankedProviders.add(BC_PROVIDER);
        }
        if (SUNJCE_PROVIDER != null) {
            rankedProviders.add(SUNJCE_PROVIDER);
        }
        Object[] providers = StringUtils.isNotBlank((CharSequence)preferredProvidersCSV) ? StringUtils.split((String)preferredProvidersCSV, (String)",") : new String[]{};
        ArrayUtils.reverse((Object[])providers);
        Arrays.stream(providers).map(StringUtils::trimToEmpty).filter(StringUtils::isNotBlank).filter(ExternalSecurityProviderLoader::isKnownSecurityProvider).distinct().forEach(p -> {
            Provider preferred = Security.getProvider(p);
            rankedProviders.addFirst(preferred);
        });
        return rankedProviders.stream().distinct().collect(Collectors.toList());
    }

    static {
        Provider bouncyCastleProvider;
        LOGGER = LoggerFactory.getLogger(ExternalSecurityProviderLoader.class);
        PKCS11_PROVIDER = Security.getProvider(PKCS11_PROVIDER_NAME);
        if (PKCS11_PROVIDER != null) {
            LOGGER.debug("PKCS11 NSS provider was loaded - native crypto support available");
        }
        if ((bouncyCastleProvider = Security.getProvider(BC_PROVIDER_NAME)) == null) {
            BC_PROVIDER = new BouncyCastleProvider();
            Security.addProvider(BC_PROVIDER);
            LOGGER.debug("Bouncy Castle provider was not loaded, adding to providers");
        } else {
            BC_PROVIDER = bouncyCastleProvider;
        }
        SUNJCE_PROVIDER = Security.getProvider(SUNJCE_PROVIDER_NAME);
        rankedPreferredProviders = Collections.unmodifiableList(ExternalSecurityProviderLoader.buildRankedPreferredProviders(System.getProperty(PREFERRED_PROVIDERS_SYS_PROP_KEY)));
        if (rankedPreferredProviders.isEmpty()) {
            String msg = "There are no usable security providers for Manta client-side encryption";
            throw new SecurityException(msg);
        }
        LOGGER.info("Security provider chosen for CSE: {} ", (Object)ExternalSecurityProviderLoader.getPreferredProvider());
    }
}

