/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.multipart;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.joyent.manta.client.MantaMetadata;
import com.joyent.manta.http.MantaHttpHeaders;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.commons.lang3.StringUtils;

class CreateMPURequestBody {
    private final String objectPath;
    private final Map<String, Object> headers = new CaseInsensitiveMap();

    CreateMPURequestBody(String objectPath, MantaMetadata metadata, MantaHttpHeaders mantaHttpHeaders) {
        this.objectPath = objectPath;
        if (mantaHttpHeaders != null) {
            this.importHeaders(mantaHttpHeaders);
        }
        if (metadata != null) {
            this.importMetadata(metadata);
        }
    }

    private void importHeaders(MantaHttpHeaders mantaHttpHeaders) {
        String roles;
        String contentMd5;
        Long contentLength;
        Integer durabilityLevel;
        String contentType = mantaHttpHeaders.getContentType();
        if (!StringUtils.isBlank((CharSequence)contentType)) {
            this.headers.put("Content-Type", contentType);
        }
        if ((durabilityLevel = mantaHttpHeaders.getDurabilityLevel()) != null) {
            this.headers.put("durability-level", durabilityLevel);
        }
        if ((contentLength = mantaHttpHeaders.getContentLength()) != null) {
            this.headers.put("Content-Length", contentLength);
        }
        if (!StringUtils.isBlank((CharSequence)(contentMd5 = mantaHttpHeaders.getContentMD5()))) {
            this.headers.put("Content-MD5", contentMd5);
        }
        if (!StringUtils.isBlank((CharSequence)(roles = mantaHttpHeaders.getFirstHeaderStringValue("Role-Tag")))) {
            this.headers.put("Role-Tag", roles);
        }
    }

    private void importMetadata(MantaMetadata metadata) {
        Set<Map.Entry<String, String>> entrySet = metadata.entrySet();
        for (Map.Entry<String, String> next : entrySet) {
            if (!next.getKey().startsWith("m-")) continue;
            this.headers.put(next.getKey(), next.getValue());
        }
    }

    public String getObjectPath() {
        return this.objectPath;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, Object> getHeaders() {
        return this.headers;
    }
}

