/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.exception;

import com.joyent.manta.exception.MantaClientException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MantaErrorCode {
    ACCOUNT_BLOCKED_ERROR("AccountBlocked"),
    ACCOUNT_DOES_NOT_EXIST_ERROR("AccountDoesNotExist"),
    AUTHORIZATION_ERROR("Authorization"),
    AUTHORIZATION_FAILED_ERROR("AuthorizationFailed"),
    AUTHORIZATION_REQUIRED_ERROR("AuthorizationRequired"),
    AUTHORIZATION_SCHEME_NOT_ALLOWED_ERROR("AuthorizationSchemeNotAllowed"),
    AUTH_SCHEME_ERROR("AuthScheme"),
    BAD_REQUEST_ERROR("BadRequest"),
    CHECKSUM_ERROR("ChecksumError"),
    CONCURRENT_REQUEST_ERROR("ConcurrentRequest"),
    CONTENT_LENGTH_ERROR("ContentLength"),
    CONTENT_LENGTH_REQUIRED_ERROR("ContentLengthRequired"),
    CONTENT_MD5_MISMATCH_ERROR("ContentMD5Mismatch"),
    CROSS_ACCOUNT_ERROR("CrossAccount"),
    DIRECTORY_DOES_NOT_EXIST_ERROR("DirectoryDoesNotExist"),
    DIRECTORY_EXISTS_ERROR("DirectoryExists"),
    DIRECTORY_LIMIT_EXCEEDED_ERROR("DirectoryLimitExceeded"),
    DIRECTORY_NOT_EMPTY_ERROR("DirectoryNotEmpty"),
    DIRECTORY_OPERATION_ERROR("DirectoryOperation"),
    ENTITY_EXISTS_ERROR("EntityExists"),
    ENTITY_EXISTS_MUSKIE_ERROR("EntityAlreadyExists"),
    ETAG_CONFLICT_ERROR("EtagConflictError"),
    EXPECTED_UPGRADE_ERROR("ExpectedUpgrade"),
    INTERNAL_ERROR("InternalError"),
    INVALID_ALGORITHM_ERROR("InvalidAlgorithm"),
    INVALID_ARGUMENT_ERROR("InvalidArgumentError"),
    INVALID_AUTH_TOKEN_ERROR("InvalidAuthenticationToken"),
    INVALID_CREDENTIALS_ERROR("InvalidCredentials"),
    INVALID_DURABILITY_LEVEL_ERROR("InvalidDurabilityLevel"),
    INVALID_HEADER_ERROR("InvalidHeader"),
    INVALID_HTTP_AUTHENTICATION_TOKEN_ERROR("InvalidHttpAuthenticationToken"),
    INVALID_JOB_ERROR("InvalidJob"),
    INVALID_JOB_STATE_ERROR("InvalidJobState"),
    INVALID_KEY_ERROR("InvalidKey"),
    INVALID_KEY_ID_ERROR("InvalidKeyId"),
    INVALID_LIMIT_ERROR("InvalidLimit"),
    INVALID_LINK_ERROR("InvalidLink"),
    INVALID_MAX_CONTENT_LENGTH_ERROR("InvalidMaxContentLength"),
    INVALID_PARAMETER_ERROR("InvalidParameter"),
    INVALID_QUERY_STRING_AUTHENTICATION_ERROR("InvalidQueryStringAuthentication"),
    INVALID_RESOURCE_ERROR("InvalidResource"),
    INVALID_ROLE_ERROR("InvalidRole"),
    INVALID_ROLE_TAG_ERROR("InvalidRoleTag"),
    INVALID_SIGNATURE_ERROR("InvalidSignature"),
    INVALID_UPDATE_ERROR("InvalidUpdate"),
    JOB_CANCELLED_ERROR("JobCancelledError"),
    JOB_NOT_FOUND_ERROR("JobNotFound"),
    JOB_STATE_ERROR("JobState"),
    KEY_DOES_NOT_EXIST_ERROR("KeyDoesNotExist"),
    LINK_NOT_FOUND_ERROR("LinkNotFound"),
    LINK_NOT_OBJECT_ERROR("LinkNotObject"),
    LINK_REQUIRED_ERROR("LinkRequired"),
    LOCATION_REQUIRED_ERROR("LocationRequired"),
    MAX_CONTENT_LENGTH_EXCEEDED_ERROR("MaxContentLengthExceeded"),
    METHOD_NOT_ALLOWED("MethodNotAllowedError"),
    MISSING_PERMISSION_ERROR("MissingPermission"),
    MULTIPART_UPLOAD_INVALID_ARGUMENT("MultipartUploadInvalidArgument"),
    MULTIPART_UPLOAD_PART_SIZE("MultipartUploadPartSize"),
    MULTIPART_UPLOAD_STATE_ERROR("InvalidMultipartUploadState"),
    NOT_ACCEPTABLE_ERROR("NotAcceptable"),
    NOT_ENOUGH_SPACE_ERROR("NotEnoughSpace"),
    NOT_IMPLEMENTED_ERROR("NotImplemented"),
    NO_API_SERVERS_AVAILABLE("NoApiServersAvailable"),
    NO_CODE_ERROR(null),
    NO_DATABASE_PEERS_ERROR("NoDatabasePeersError"),
    NO_MATCHING_ROLE_TAG_ERROR("NoMatchingRoleTag"),
    OBJECT_NOT_FOUND_ERROR("ObjectNotFoundError"),
    OPERATION_NOT_ALLOWED_ON_DIRECTORY_ERROR("OperationNotAllowedOnDirectory"),
    OPERATION_NOT_ALLOWED_ON_ROOT_DIRECTORY_ERROR("OperationNotAllowedOnRootDirectory"),
    PARENT_NOT_DIRECTORY_ERROR("ParentNotDirectory"),
    PRECONDITION_FAILED_ERROR("PreconditionFailed"),
    PRECONDITION_FAILED_MUSKIE_ERROR("PreconditionFailedError"),
    PRE_SIGNED_REQUEST_ERROR("PreSignedRequest"),
    REQUESTED_RANGE_NOT_SATISFIABLE_ERROR("RequestedRangeNotSatisfiable"),
    REQUEST_ENTITY_TOO_LARGE_ERROR("RequestEntityTooLarge"),
    REQUEST_TIMEOUT_ERROR("RequestTimeout"),
    RESOURCE_NOT_FOUND_ERROR("ResourceNotFound"),
    ROOT_DIRECTORY_ERROR("RootDirectory"),
    RULES_EVALUATION_FAILED_ERROR("RulesEvaluationFailed"),
    SECURE_TRANSPORT_REQUIRED_ERROR("SecureTransportRequired"),
    SERVICE_UNAVAILABLE_ERROR("ServiceUnavailable"),
    SNAPLINKS_DISABLED_ERROR("SnaplinksDisabledError"),
    SOURCE_OBJECT_NOT_FOUND_ERROR("SourceObjectNotFound"),
    SSL_REQUIRED_ERROR("SSLRequired"),
    TASK_INIT_ERROR("TaskInitError"),
    TASK_KILLED_ERROR("TaskKilledError"),
    THROTTLED_ERROR("ThrottledError"),
    UNDEFINED("X-Undefined"),
    UNIQUE_ATTRIBUTE_ERROR("UniqueAttributeError"),
    UNKNOWN_ERROR("UnknownError"),
    UPLOAD_ABANDONED_ERROR("UploadAbandoned"),
    UPLOAD_TIMEOUT_ERROR("UploadTimeout"),
    USER_DOES_NOT_EXIST_ERROR("UserDoesNotExist"),
    USER_TASK_ERROR("UserTaskError");

    private static Map<String, MantaErrorCode> errorMap;
    private static final Logger LOG;
    private final String code;

    private MantaErrorCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public static MantaErrorCode valueOfCode(String serverCode) {
        MantaErrorCode found = errorMap.getOrDefault(serverCode, UNKNOWN_ERROR);
        if (found.equals((Object)UNKNOWN_ERROR)) {
            LOG.warn("Unknown error code received from Manta: {}", (Object)serverCode);
        }
        return found;
    }

    public static MantaErrorCode valueOfCode(Object object) {
        if (object == null) {
            return MantaErrorCode.valueOfCode(null);
        }
        return MantaErrorCode.valueOfCode(object.toString());
    }

    public static Map<String, MantaErrorCode> createErrorMap() throws MantaClientException {
        LinkedHashMap<String, MantaErrorCode> map = new LinkedHashMap<String, MantaErrorCode>(MantaErrorCode.values().length);
        for (MantaErrorCode errorCode : MantaErrorCode.values()) {
            MantaErrorCode replaced = map.put(errorCode.code, errorCode);
            if (replaced == null) continue;
            String msg = String.format("Duplicate error code specified in enum: %s", replaced.code);
            throw new IllegalArgumentException(msg);
        }
        return map;
    }

    static {
        errorMap = MantaErrorCode.createErrorMap();
        LOG = LoggerFactory.getLogger(MantaErrorCode.class);
    }
}

