/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.exception;

import com.joyent.manta.client.jobs.MantaJobError;
import com.joyent.manta.exception.MantaException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class MantaJobException
extends MantaException {
    private static final long serialVersionUID = 8649276325268003152L;
    private final List<MantaJobError> errors;
    private final UUID jobId;

    public MantaJobException(String message) {
        super(message);
        this.jobId = null;
        this.setContextValue("jobId", null);
        this.errors = Collections.emptyList();
    }

    public MantaJobException(UUID jobId, String message) {
        super(String.format("[job: %s] %s", jobId, message));
        this.jobId = jobId;
        this.setContextValue("jobId", this.jobId);
        this.errors = Collections.emptyList();
    }

    public MantaJobException(UUID jobId, String message, Throwable cause) {
        super(String.format("[job: %s] %s", jobId, message), cause);
        this.jobId = jobId;
        this.setContextValue("jobId", Objects.toString(this.jobId));
        this.errors = Collections.emptyList();
    }

    public MantaJobException(String message, Throwable cause) {
        super(message, cause);
        this.errors = Collections.emptyList();
        this.jobId = null;
        this.setContextValue("jobId", null);
    }

    public MantaJobException(UUID jobId, List<MantaJobError> errors) {
        this.jobId = jobId;
        this.setContextValue("jobId", Objects.toString(this.jobId));
        this.errors = errors;
    }

    public List<MantaJobError> getErrors() {
        return this.errors;
    }

    public UUID getJobId() {
        return this.jobId;
    }

    public String getMessage() {
        if (this.errors.isEmpty()) {
            return super.getMessage();
        }
        StringBuilder builder = new StringBuilder();
        Iterator<MantaJobError> itr = this.errors.iterator();
        while (itr.hasNext()) {
            MantaJobError error = itr.next();
            String msg = String.format("[%s] (phase: %s) %s", error.getCode(), error.getPhase(), error.getMessage());
            builder.append(" ").append(msg);
            if (!itr.hasNext()) continue;
            builder.append(msg);
        }
        return builder.toString();
    }

    public String getLocalizedMessage() {
        if (this.errors.isEmpty()) {
            return super.getLocalizedMessage();
        }
        return this.getMessage();
    }
}

